/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.client.utils.ConstructableData;
import blockrenderer6343.integration.nei.GuiMultiblockHandler;
import codechicken.nei.LayoutManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.RecipeSearchField;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public abstract class MultiblockHandler
extends TemplateRecipeHandler {
    public static final int CANDIDATE_SLOTS_X = 150;
    public static final int CANDIDATE_SLOTS_Y = 20;
    public static final int CANDIDATE_IN_COlUMN = 6;
    private static ItemStack lastStack;
    protected RecipeCacher recipeCacher = new RecipeCacher();
    protected GuiMultiblockHandler guiHandler;
    protected IConstructable[] currentMultiblocks;
    protected int oldRecipe;
    protected static RecipeSearchField recipeSearchField;
    protected static final PositionedStack DUMMY_STACK;

    public MultiblockHandler(GuiMultiblockHandler guiHandler) {
        this.guiHandler = guiHandler;
        guiHandler.setOnIngredientChanged(this::resetPositionedIngredients);
        guiHandler.setOnCandidateChanged(this::setResults);
    }

    @NotNull
    public abstract ItemStack getConstructableStack(IConstructable var1);

    @NotNull
    protected abstract ObjectSet<IConstructable> tryLoadingMultiblocks(ItemStack var1);

    public void loadCraftingRecipes(ItemStack result) {
        this.loadRecipes(result);
        super.loadCraftingRecipes(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.loadRecipes(ingredient);
        super.loadUsageRecipes(ingredient);
    }

    private void loadRecipes(ItemStack stack) {
        this.currentMultiblocks = null;
        this.oldRecipe = -1;
        ObjectSet<IConstructable> multiblocks = this.tryLoadingMultiblocks(stack);
        if (multiblocks.isEmpty()) {
            return;
        }
        lastStack = stack;
        this.currentMultiblocks = (IConstructable[])multiblocks.toArray((Object[])new IConstructable[0]);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        if (this.currentMultiblocks == null) {
            return;
        }
        if (this.oldRecipe != recipe) {
            this.oldRecipe = recipe;
            IConstructable multi = this.currentMultiblocks[recipe];
            this.guiHandler.loadMultiblock(multi, this.getConstructableStack(multi), ConstructableData.getTierData(multi).setTierFromStack(lastStack));
        }
        this.guiHandler.recalculateSearch(recipeSearchField.text());
        this.guiHandler.drawMultiblock();
    }

    @Nullable
    public static MultiblockHandler getHandlerFromGui(GuiScreen gui) {
        if (!(gui instanceof GuiRecipe)) {
            return null;
        }
        GuiRecipe recipe = (GuiRecipe)gui;
        IRecipeHandler iRecipeHandler = recipe.getHandler();
        if (iRecipeHandler instanceof MultiblockHandler) {
            MultiblockHandler handler = (MultiblockHandler)iRecipeHandler;
            return handler;
        }
        return null;
    }

    @Nullable
    public static GuiMultiblockHandler getCurrentGuiHandler() {
        MultiblockHandler handler = MultiblockHandler.getHandlerFromGui(Minecraft.func_71410_x().field_71462_r);
        if (handler != null) {
            return handler.getGuiHandler();
        }
        return null;
    }

    public String getOverlayIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int numRecipes() {
        return this.currentMultiblocks == null ? 0 : this.currentMultiblocks.length;
    }

    public String getGuiTexture() {
        return "blockrenderer6343:textures/void.png";
    }

    public String getRecipeName() {
        return StringUtils.abbreviate((String)this.guiHandler.getMultiblockName(), (int)25);
    }

    public String getRecipeTabName() {
        return StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.structure");
    }

    @NotNull
    protected GuiMultiblockHandler getGuiHandler() {
        return this.guiHandler;
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return Collections.emptyList();
    }

    public PositionedStack getResultStack(int recipe) {
        return DUMMY_STACK;
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return this.arecipes.isEmpty() ? Collections.emptyList() : ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(0)).getOtherStacks();
    }

    public void resetPositionedIngredients(List<ItemStack> ingredients) {
        RecipeCatalysts.putRecipeCatalysts((String)this.getOverlayIdentifier(), ingredients);
    }

    public void setResults(List<List<ItemStack>> results) {
        this.arecipes.clear();
        this.recipeCacher.setResults(results);
        this.arecipes.add(this.recipeCacher);
    }

    @SubscribeEvent
    public static void onPostOverlay(GuiRecipeButton.UpdateRecipeButtonsEvent.Post event) {
        GuiRecipe recipe;
        GuiScreen guiScreen = event.gui;
        if (guiScreen instanceof GuiRecipe && (recipe = (GuiRecipe)guiScreen).getHandler() instanceof MultiblockHandler) {
            event.buttonList.clear();
        }
    }

    static {
        DUMMY_STACK = new PositionedStack((Object)new ItemStack(Items.field_151170_bI), 0, 9999, false);
        API.addSearchProvider((SearchTokenParser.ISearchParserProvider)new SearchField.SearchParserProvider('\u4321', "inpreview", EnumChatFormatting.RESET, a -> new InPreviewFilter()){

            public SearchTokenParser.SearchMode getSearchMode() {
                return SearchTokenParser.SearchMode.ALWAYS;
            }
        });
        try {
            recipeSearchField = (RecipeSearchField)ReflectionHelper.findField(GuiRecipe.class, (String[])new String[]{"searchField"}).get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class RecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> positionedResults;

        public RecipeCacher() {
            super((TemplateRecipeHandler)MultiblockHandler.this);
            this.positionedResults = new ArrayList<PositionedStack>();
        }

        public void setResults(List<List<ItemStack>> results) {
            this.positionedResults.clear();
            int columnCount = results.size() / 6 + 1;
            int realCandidateInColumn = results.size() % columnCount == 0 ? results.size() / columnCount : results.size() / columnCount + 1;
            for (int i = 0; i < results.size(); ++i) {
                PositionedStack result = new PositionedStack(results.get(i), 150 - (columnCount - 1) * 18 + i / realCandidateInColumn * 18, 20 + i % realCandidateInColumn * 18);
                result.generatePermutations();
                this.positionedResults.add(result);
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(MultiblockHandler.this.cycleticks / 20, this.positionedResults);
        }
    }

    public static class InPreviewFilter
    implements ItemFilter {
        public boolean matches(ItemStack item) {
            GuiMultiblockHandler handler = MultiblockHandler.getCurrentGuiHandler();
            if (handler != null && !LayoutManager.searchField.focused()) {
                return recipeSearchField.isVisible() && recipeSearchField.focused() && !recipeSearchField.text().isEmpty();
            }
            return false;
        }
    }
}

