/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.renderer;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.client.renderer.HEBufferIds;
import com.sinthoras.hydroenergy.client.renderer.HEProgram;
import com.sinthoras.hydroenergy.client.renderer.HERenderChunk;
import com.sinthoras.hydroenergy.client.renderer.HERenderSubChunk;
import com.sinthoras.hydroenergy.client.renderer.HESortedRenderList;
import com.sinthoras.hydroenergy.config.HEConfig;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

@SideOnly(value=Side.CLIENT)
public class HETessalator {
    private static final int maxRenderDistance = (int)GameSettings.Options.RENDER_DISTANCE.func_148267_f();
    private static final int maxRenderChunksX;
    private static final int maxRenderChunksZ;
    private static final HERenderChunk[] renderChunks;
    private static final Stack<HERenderChunk> availableRenderChunks;
    private static final Stack<HEBufferIds> availableBuffers;
    private static final FloatBuffer vboBuffer;
    private static int numWaterBlocks;

    private static int getChunkIndex(int chunkX, int chunkZ) {
        return HEUtil.nonNegativeModulo(chunkX, maxRenderChunksX) + HEUtil.nonNegativeModulo(chunkZ, maxRenderChunksZ) * maxRenderChunksX;
    }

    public static void onPostRender(int blockX, int blockY, int blockZ) {
        int chunkX = HEUtil.coordBlockToChunk(blockX);
        int chunkY = HEUtil.coordBlockToChunk(blockY);
        int chunkZ = HEUtil.coordBlockToChunk(blockZ);
        HERenderSubChunk renderSubChunk = HETessalator.renderChunks[HETessalator.getChunkIndex((int)chunkX, (int)chunkZ)].renderSubChunks[chunkY];
        if (numWaterBlocks != 0) {
            if (renderSubChunk.vaoId == -1) {
                if (availableBuffers.empty()) {
                    renderSubChunk.vaoId = GL30.glGenVertexArrays();
                    renderSubChunk.vboId = GL15.glGenBuffers();
                    GL30.glBindVertexArray((int)renderSubChunk.vaoId);
                    GL15.glBindBuffer((int)34962, (int)renderSubChunk.vboId);
                    GL15.glBufferData((int)34962, (long)((long)vboBuffer.capacity() * 4L), (int)35044);
                    GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)28, (long)0L);
                    GL20.glEnableVertexAttribArray((int)0);
                    GL20.glVertexAttribPointer((int)1, (int)1, (int)5126, (boolean)false, (int)28, (long)12L);
                    GL20.glEnableVertexAttribArray((int)1);
                    GL20.glVertexAttribPointer((int)2, (int)1, (int)5126, (boolean)false, (int)28, (long)16L);
                    GL20.glEnableVertexAttribArray((int)2);
                    GL20.glVertexAttribPointer((int)3, (int)1, (int)5126, (boolean)false, (int)28, (long)20L);
                    GL20.glEnableVertexAttribArray((int)3);
                    GL20.glVertexAttribPointer((int)4, (int)1, (int)5126, (boolean)false, (int)28, (long)24L);
                    GL20.glEnableVertexAttribArray((int)4);
                    GL30.glBindVertexArray((int)0);
                } else {
                    HEBufferIds ids = availableBuffers.pop();
                    renderSubChunk.vaoId = ids.vaoId;
                    renderSubChunk.vboId = ids.vboId;
                }
            }
            vboBuffer.flip();
            GL15.glBindBuffer((int)34962, (int)renderSubChunk.vboId);
            GL15.glBufferSubData((int)34962, (long)0L, (FloatBuffer)vboBuffer);
            GL15.glBindBuffer((int)34962, (int)0);
            renderSubChunk.numWaterBlocks = numWaterBlocks;
            vboBuffer.clear();
            numWaterBlocks = 0;
        } else if (renderSubChunk.vaoId != -1) {
            HEBufferIds ids = new HEBufferIds();
            ids.vaoId = renderSubChunk.vaoId;
            ids.vboId = renderSubChunk.vboId;
            availableBuffers.push(ids);
            renderSubChunk.vaoId = -1;
            renderSubChunk.vboId = -1;
            renderSubChunk.numWaterBlocks = 0;
        }
    }

    public static void addBlock(int blockX, int blockY, int blockZ, int waterId, int worldColorModifier, boolean[] shouldSideBeRendered) {
        int renderSides = 0;
        for (int i = 0; i < shouldSideBeRendered.length; ++i) {
            if (!shouldSideBeRendered[i]) continue;
            renderSides |= 1 << i;
        }
        vboBuffer.put(blockX);
        vboBuffer.put(blockY);
        vboBuffer.put(blockZ);
        int lightXMinus = 15;
        int lightXPlus = 15;
        int lightYMinus = 15;
        int lightYPlus = 15;
        int lightZMinus = 15;
        int lightZPlus = 15;
        int light0 = 986895;
        int light1 = 986895;
        vboBuffer.put(986895.0f);
        vboBuffer.put(986895.0f);
        int info = waterId << 6 | renderSides;
        vboBuffer.put(info);
        vboBuffer.put(worldColorModifier);
        ++numWaterBlocks;
    }

    public static void render(ICamera camera) {
        if (!GLContext.getCapabilities().OpenGL30 || HEConfig.useLimitedRendering) {
            return;
        }
        if (MinecraftForgeClient.getRenderPass() == HE.waterBlocks[0].func_149701_w()) {
            Frustrum frustrum = (Frustrum)camera;
            float cameraBlockX = (float)frustrum.field_78550_b;
            float cameraBlockY = (float)frustrum.field_78551_c;
            float cameraBlockZ = (float)frustrum.field_78549_d;
            GL11.glEnable((int)3042);
            HEProgram.bind();
            HEProgram.setViewProjection(cameraBlockX, cameraBlockY, cameraBlockZ);
            HEProgram.setCameraPosition(cameraBlockX, cameraBlockY, cameraBlockZ);
            HEProgram.setWaterLevels();
            HEProgram.setDebugStates();
            HEProgram.setWaterUV();
            HEProgram.setFog();
            HEProgram.bindLightLookupTable();
            HEProgram.bindAtlasTexture();
            HESortedRenderList.setup(HEUtil.coordBlockToChunk((int)cameraBlockX), HEUtil.coordBlockToChunk((int)cameraBlockY), HEUtil.coordBlockToChunk((int)cameraBlockZ));
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int centerChunkX = HEUtil.coordBlockToChunk((int)cameraBlockX);
            int centerChunkZ = HEUtil.coordBlockToChunk((int)cameraBlockZ);
            int renderDistanceChunks = Minecraft.func_71410_x().field_71438_f.field_72739_F;
            for (int offsetChunkX = -renderDistanceChunks; offsetChunkX < renderDistanceChunks; ++offsetChunkX) {
                for (int offsetChunkZ = -renderDistanceChunks; offsetChunkZ < renderDistanceChunks; ++offsetChunkZ) {
                    int chunkX = centerChunkX + offsetChunkX;
                    int chunkZ = centerChunkZ + offsetChunkZ;
                    HERenderChunk renderChunks = HETessalator.renderChunks[HETessalator.getChunkIndex(chunkX, chunkZ)];
                    if (renderChunks == null) continue;
                    Chunk vanillaChunk = world.func_72964_e(chunkX, chunkZ);
                    for (int chunkY = 0; chunkY < 16; ++chunkY) {
                        int blockX = HEUtil.coordChunkToBlock(chunkX);
                        int blockY = HEUtil.coordChunkToBlock(chunkY);
                        int blockZ = HEUtil.coordChunkToBlock(chunkZ);
                        HERenderSubChunk renderSubChunk = renderChunks.renderSubChunks[chunkY];
                        AxisAlignedBB chunkBB = AxisAlignedBB.func_72330_a((double)blockX, (double)blockY, (double)blockZ, (double)(blockX + 16), (double)(blockY + 16), (double)(blockZ + 16));
                        if (renderSubChunk.vaoId == -1 || vanillaChunk.func_76606_c(blockY, blockY + 15) || !frustrum.func_78546_a(chunkBB)) continue;
                        HESortedRenderList.add(renderSubChunk.vaoId, renderSubChunk.numWaterBlocks, chunkX, chunkY, chunkZ);
                    }
                }
            }
            HESortedRenderList.render();
            HEProgram.unbind();
            GL11.glDisable((int)3042);
        }
    }

    public static void onRenderChunkUpdate(int oldBlockX, int oldBlockZ, int blockX, int blockY, int blockZ) {
        if (blockY == 0) {
            int oldChunkX = HEUtil.coordBlockToChunk(oldBlockX);
            int oldChunkZ = HEUtil.coordBlockToChunk(oldBlockZ);
            int chunkX = HEUtil.coordBlockToChunk(blockX);
            int chunkZ = HEUtil.coordBlockToChunk(blockZ);
            int oldChunkIndex = HETessalator.getChunkIndex(oldChunkX, oldChunkZ);
            HERenderChunk oldRenderChunk = renderChunks[oldChunkIndex];
            if (oldRenderChunk != null && oldRenderChunk.chunkX == oldChunkX && oldRenderChunk.chunkZ == oldChunkZ) {
                HETessalator.renderChunks[oldChunkIndex] = null;
                availableRenderChunks.push(oldRenderChunk);
            }
            HERenderChunk renderChunk = availableRenderChunks.isEmpty() ? new HERenderChunk() : availableRenderChunks.pop();
            renderChunk.chunkX = chunkX;
            renderChunk.chunkZ = chunkZ;
            for (HERenderSubChunk renderSubChunk : renderChunk.renderSubChunks) {
                if (renderSubChunk.vaoId == -1) continue;
                HEBufferIds ids = new HEBufferIds();
                ids.vaoId = renderSubChunk.vaoId;
                ids.vboId = renderSubChunk.vboId;
                availableBuffers.push(ids);
                renderSubChunk.vaoId = -1;
                renderSubChunk.vboId = -1;
                renderSubChunk.numWaterBlocks = 0;
            }
            int newChunkIndex = HETessalator.getChunkIndex(chunkX, chunkZ);
            if (renderChunks[newChunkIndex] != null) {
                availableRenderChunks.push(renderChunks[newChunkIndex]);
            }
            HETessalator.renderChunks[newChunkIndex] = renderChunk;
        }
    }

    public static int getGpuMemoryUsage() {
        int subChunkCounter = 0;
        for (HERenderChunk renderChunks : HETessalator.renderChunks) {
            if (renderChunks == null) continue;
            for (HERenderSubChunk renderSubChunk : renderChunks.renderSubChunks) {
                if (renderSubChunk.vaoId == -1) continue;
                ++subChunkCounter;
            }
        }
        return subChunkCounter * vboBuffer.capacity();
    }

    static {
        maxRenderChunksZ = maxRenderChunksX = 2 * maxRenderDistance + 1;
        renderChunks = new HERenderChunk[maxRenderChunksX * maxRenderChunksZ];
        availableRenderChunks = new Stack();
        availableBuffers = new Stack();
        vboBuffer = GLAllocation.func_74529_h((int)28672);
        numWaterBlocks = 0;
    }
}

