/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe;

import java.io.OutputStream;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.io.Output;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil;

public class UnsafeOutput
extends Output {
    public UnsafeOutput() {
    }

    public UnsafeOutput(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public UnsafeOutput(int bufferSize, int maxBufferSize) {
        super(bufferSize, maxBufferSize);
    }

    public UnsafeOutput(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public UnsafeOutput(byte[] buffer, int maxBufferSize) {
        super(buffer, maxBufferSize);
    }

    public UnsafeOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public UnsafeOutput(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
    }

    @Override
    public void write(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++, (byte)value);
    }

    @Override
    public void writeByte(byte value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++, value);
    }

    @Override
    public void writeByte(int value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++, (byte)value);
    }

    @Override
    public void writeInt(int value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe.putInt(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public void writeLong(long value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe.putLong(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public void writeFloat(float value) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe.putFloat(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public void writeDouble(double value) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe.putDouble(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public void writeShort(int value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe.putShort(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, (short)value);
        this.position += 2;
    }

    @Override
    public void writeChar(char value) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe.putChar(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, value);
        this.position += 2;
    }

    @Override
    public void writeBoolean(boolean value) throws KryoException {
        if (this.position == this.capacity) {
            this.require(1);
        }
        UnsafeUtil.unsafe.putByte(this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position++, value ? (byte)1 : 0);
    }

    @Override
    public void writeInts(int[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.intArrayBaseOffset, array.length << 2);
    }

    @Override
    public void writeLongs(long[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.longArrayBaseOffset, array.length << 3);
    }

    @Override
    public void writeFloats(float[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.floatArrayBaseOffset, array.length << 2);
    }

    @Override
    public void writeDoubles(double[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.doubleArrayBaseOffset, array.length << 3);
    }

    @Override
    public void writeShorts(short[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.shortArrayBaseOffset, array.length << 1);
    }

    @Override
    public void writeChars(char[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.charArrayBaseOffset, array.length << 1);
    }

    @Override
    public void writeBooleans(boolean[] array, int offset, int count) throws KryoException {
        this.writeBytes(array, UnsafeUtil.booleanArrayBaseOffset, array.length);
    }

    @Override
    public void writeBytes(byte[] array, int offset, int count) throws KryoException {
        this.writeBytes((Object)array, UnsafeUtil.byteArrayBaseOffset + (long)offset, count);
    }

    public void writeBytes(Object from, long offset, int count) throws KryoException {
        int copyCount = Math.min(this.capacity - this.position, count);
        while (true) {
            UnsafeUtil.unsafe.copyMemory(from, offset, this.buffer, UnsafeUtil.byteArrayBaseOffset + (long)this.position, copyCount);
            this.position += copyCount;
            if ((count -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(this.capacity, count);
            this.require(copyCount);
        }
    }
}

