/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

@SideOnly(value=Side.CLIENT)
public class ClientChatUtils {
    private static final char sectionChar = '\u00a7';

    private static EnumChatFormatting getFormattingFromChar(char c) {
        for (EnumChatFormatting format : EnumChatFormatting.values()) {
            if (format.func_96298_a() != c) continue;
            return format;
        }
        return EnumChatFormatting.RESET;
    }

    private static void applyStyleFormat(ChatStyle style, EnumChatFormatting format) {
        switch (format) {
            case BLACK: 
            case DARK_BLUE: 
            case DARK_GREEN: 
            case DARK_AQUA: 
            case DARK_RED: 
            case DARK_PURPLE: 
            case GOLD: 
            case GRAY: 
            case DARK_GRAY: 
            case BLUE: 
            case GREEN: 
            case AQUA: 
            case RED: 
            case LIGHT_PURPLE: 
            case YELLOW: 
            case WHITE: {
                style.func_150238_a(format);
                break;
            }
            case OBFUSCATED: {
                style.func_150237_e(Boolean.valueOf(true));
                break;
            }
            case BOLD: {
                style.func_150227_a(Boolean.valueOf(true));
                break;
            }
            case STRIKETHROUGH: {
                style.func_150225_c(Boolean.valueOf(true));
                break;
            }
            case UNDERLINE: {
                style.func_150228_d(Boolean.valueOf(true));
                break;
            }
            case ITALIC: {
                style.func_150217_b(Boolean.valueOf(true));
                break;
            }
            case RESET: {
                style.func_150238_a(null);
                style.func_150237_e(null);
                style.func_150227_a(null);
                style.func_150225_c(null);
                style.func_150228_d(null);
                style.func_150217_b(null);
            }
        }
    }

    private static void createChatComponent(IChatComponent parent, String piece) {
        int formatIdx = piece.indexOf(167);
        if (formatIdx >= 0) {
            int codePos;
            if (formatIdx != 0) {
                parent.func_150257_a((IChatComponent)new ChatComponentText(piece.substring(0, formatIdx)));
            }
            ChatStyle style = new ChatStyle();
            String formattedPiece = piece.substring(formatIdx);
            for (codePos = 1; codePos < formattedPiece.length(); ++codePos) {
                ClientChatUtils.applyStyleFormat(style, ClientChatUtils.getFormattingFromChar(formattedPiece.charAt(codePos)));
                if (codePos + 2 < formattedPiece.length() && formattedPiece.charAt(++codePos) != '\u00a7') break;
            }
            String rest = formattedPiece.substring(codePos);
            int endFormatIdx = rest.indexOf(167);
            boolean childParent = false;
            if (endFormatIdx >= 0) {
                if (endFormatIdx + 2 <= rest.length() && rest.charAt(endFormatIdx + 1) != 'r') {
                    childParent = true;
                    --endFormatIdx;
                }
            } else {
                endFormatIdx = rest.length();
            }
            ChatComponentText newChild = new ChatComponentText(rest.substring(0, endFormatIdx));
            newChild.func_150255_a(style);
            parent.func_150257_a((IChatComponent)newChild);
            if (endFormatIdx < rest.length() - 1) {
                ClientChatUtils.createChatComponent((IChatComponent)(childParent ? newChild : parent), rest.substring(endFormatIdx));
            }
        } else {
            parent.func_150257_a((IChatComponent)new ChatComponentText(piece));
        }
    }

    public static void printLocalizedMessage(String key, Object ... extraItems) {
        ArrayList translatedPieces = Lists.newArrayList((Iterable)new ChatComponentTranslation(key, extraItems));
        ChatComponentText finalMessage = new ChatComponentText("");
        StringBuilder translatedMessage = new StringBuilder();
        for (IChatComponent chatPiece : translatedPieces) {
            translatedMessage.append(chatPiece.func_150261_e());
        }
        ClientChatUtils.createChatComponent((IChatComponent)finalMessage, translatedMessage.toString());
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)finalMessage);
    }
}

