/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ClientHandler;
import codechicken.nei.FormattedTextField;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.TextField;
import codechicken.nei.Widget;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.NEIRecipeWidget;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class DebugHandlerWidget
extends Widget
implements IContainerInputHandler {
    private final int[] COLORS = new int[]{0x2200FF00, 0x22FF0000, 0x220000FF, 0x2200FFFF, 0x22FF00FF, 0x22FFFF00};
    private IRecipeHandler handler;
    private HandlerInfo handlerInfo;
    private static final int WINDOW_WIDTH = 176;
    private static final int LINE_HEIGHT = 16;
    private static final int INLINE_PADDING = 6;
    private static final int LABEL_WIDTH = 50;
    private IntegerField order;
    private IntegerField yShift;
    private IntegerField handlerHeight;
    private IntegerField handlerWidth;
    private Button multipleWidgetsAllowed;
    private Button useCustomScroll;
    private Point dragPoint = null;
    public boolean showWidget = false;
    private static final int BORDER_PADDING = 6;
    private final DrawableResource BG_TEXTURE = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 166).build();
    private static Map<String, String[]> patches = new HashMap<String, String[]>();

    public DebugHandlerWidget() {
        GuiContainerManager.addInputHandler(this);
        this.order = new IntegerField("order", 0){

            @Override
            public void onTextChange(String oldText) {
                if (NEIClientConfig.handlerOrdering.get(DebugHandlerWidget.this.handler.getOverlayIdentifier()) != null) {
                    if (this.getInteger() != NEIClientConfig.handlerOrdering.get(DebugHandlerWidget.this.handler.getOverlayIdentifier()).intValue()) {
                        DebugHandlerWidget.this.updatePatch(5, this.getInteger(), this.defaultValue);
                    }
                } else if (NEIClientConfig.handlerOrdering.get(DebugHandlerWidget.this.handler.getHandlerId()) != null && this.getInteger() != NEIClientConfig.handlerOrdering.get(DebugHandlerWidget.this.handler.getHandlerId()).intValue()) {
                    DebugHandlerWidget.this.updatePatch(5, this.getInteger(), this.defaultValue);
                }
            }
        };
        this.yShift = new IntegerField("yShift", 0){

            @Override
            public void onTextChange(String oldText) {
                if (this.getInteger() != DebugHandlerWidget.this.handlerInfo.getYShift()) {
                    DebugHandlerWidget.this.handlerInfo.setYShift(this.getInteger());
                    DebugHandlerWidget.this.updatePatch(1, this.getInteger(), this.defaultValue);
                }
            }
        };
        this.multipleWidgetsAllowed = new Button(){
            {
                this.h = 16;
                this.z = 2;
            }

            @Override
            public String getRenderLabel() {
                return DebugHandlerWidget.this.handlerInfo.isMultipleWidgetsAllowed() ? "On" : "Off";
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                DebugHandlerWidget.this.handlerInfo.setHandlerDimensions(DebugHandlerWidget.this.handlerInfo.getWidth(), DebugHandlerWidget.this.handlerInfo.getHeight(), !DebugHandlerWidget.this.handlerInfo.isMultipleWidgetsAllowed());
                DebugHandlerWidget.this.updatePatch(4, DebugHandlerWidget.this.handlerInfo.isMultipleWidgetsAllowed() ? 1 : 0, 1);
                return true;
            }
        };
        this.handlerHeight = new IntegerField("handlerHeight", HandlerInfo.DEFAULT_HEIGHT){

            @Override
            public void draw(int mx, int my) {
                this.field.func_146184_c(DebugHandlerWidget.this.handler.getRecipeHeight(0) <= 0);
                super.draw(mx, my);
            }

            @Override
            public void onTextChange(String oldText) {
                if (this.getInteger() != DebugHandlerWidget.this.handlerInfo.getHeight()) {
                    DebugHandlerWidget.this.handlerInfo.setHandlerDimensions(DebugHandlerWidget.this.handlerInfo.getWidth(), this.getInteger(), DebugHandlerWidget.this.handlerInfo.isMultipleWidgetsAllowed());
                    DebugHandlerWidget.this.updatePatch(2, this.getInteger(), this.defaultValue);
                }
            }
        };
        this.handlerWidth = new IntegerField("handlerWidth", HandlerInfo.DEFAULT_WIDTH){

            @Override
            public void onTextChange(String oldText) {
                if (this.getInteger() != DebugHandlerWidget.this.handlerInfo.getWidth()) {
                    DebugHandlerWidget.this.handlerInfo.setHandlerDimensions(this.getInteger(), DebugHandlerWidget.this.handlerInfo.getHeight(), DebugHandlerWidget.this.handlerInfo.isMultipleWidgetsAllowed());
                    DebugHandlerWidget.this.updatePatch(3, this.getInteger(), this.defaultValue);
                }
            }
        };
        this.useCustomScroll = new Button(){
            {
                this.h = 16;
                this.z = 2;
            }

            @Override
            public String getRenderLabel() {
                return DebugHandlerWidget.this.handlerInfo.getUseCustomScroll() ? "On" : "Off";
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                DebugHandlerWidget.this.handlerInfo.setUseCustomScroll(!DebugHandlerWidget.this.handlerInfo.getUseCustomScroll());
                DebugHandlerWidget.this.updatePatch(6, DebugHandlerWidget.this.handlerInfo.getUseCustomScroll() ? 1 : 0, 0);
                return true;
            }
        };
        this.w = 176;
        this.h = 218;
        this.x = 10;
        this.y = 50;
        this.z = 1;
    }

    private void updatePatch(int key, int value, int defaultValue) {
        String handlerKey = DebugHandlerWidget.getHandlerID(this.handler);
        if (!patches.containsKey(handlerKey)) {
            patches.put(handlerKey, new String[]{handlerKey, null, null, null, null, null, null});
        }
        DebugHandlerWidget.patches.get((Object)handlerKey)[key] = value == defaultValue ? null : String.valueOf(value);
        DebugHandlerWidget.saveHandlerInfoPatch();
        GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
        if (guiContainer instanceof GuiRecipe) {
            GuiRecipe recipe = (GuiRecipe)guiContainer;
            recipe.forceRefreshPage();
        }
    }

    private void drawKeyLabel(String keyLabel, int topShift) {
        GuiDraw.drawString((String)NEIClientUtils.cropText(GuiDraw.fontRenderer, keyLabel, 50), (int)(this.x + 6), (int)topShift, (int)0x66555555, (boolean)false);
        GuiDraw.drawString((String)":", (int)(this.x + 6 + 50), (int)topShift, (int)0x66555555, (boolean)false);
    }

    private void drawDetail(String keyLabel, String valueLabel, int topShift, int spaceWidth) {
        this.drawKeyLabel(keyLabel, topShift);
        GuiDraw.drawString((String)NEIClientUtils.cropText(GuiDraw.fontRenderer, valueLabel, this.w - 12 - 50 - spaceWidth), (int)(this.x + 6 + 50 + spaceWidth), (int)topShift, (int)0xFFFFFF);
    }

    private void drawControl(String keyLabel, Widget field, int topShift, int spaceWidth) {
        this.drawKeyLabel(keyLabel, topShift);
        field.x = this.x + 6 + 50 + spaceWidth;
        field.y = topShift - 4;
        field.w = this.w - 12 - 50 - spaceWidth;
    }

    @Override
    public void draw(int mx, int my) {
        if (this.handler != null) {
            int spaceWidth = GuiDraw.fontRenderer.func_78256_a(": ");
            int topShift = this.y + 6 + 12 + 6;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScaled((double)1.0, (double)1.0, (double)2.0);
            GL11.glDisable((int)2929);
            this.BG_TEXTURE.draw(this.x, this.y, this.w, this.h, 6, 6, 6, 6);
            GuiDraw.drawRect((int)(this.x + 6), (int)(this.y + 6), (int)(this.w - 12), (int)12, (int)0x30000000);
            GuiDraw.drawStringC((String)"Debug Recipe Handler", (int)(this.x + this.w / 2), (int)(this.y + 6 + 2), (int)0xFFFFFF);
            for (Map.Entry<String, String> entry : this.getDetailsInfo().entrySet()) {
                this.drawDetail(entry.getKey(), entry.getValue(), topShift, spaceWidth);
                topShift += 16;
            }
            this.drawControl("Order", this.order, topShift, spaceWidth);
            this.drawControl("yShift", this.yShift, topShift += 16, spaceWidth);
            this.drawControl("Multi Widgets", this.multipleWidgetsAllowed, topShift += 16, spaceWidth);
            this.drawControl("Height", this.handlerHeight, topShift += 16, spaceWidth);
            this.drawControl("Width", this.handlerWidth, topShift += 16, spaceWidth);
            this.drawControl("Use Custom Scroll", this.useCustomScroll, topShift += 16, spaceWidth);
            topShift += 16;
            GL11.glScaled((double)1.0, (double)1.0, (double)0.5);
        }
    }

    private Map<String, String> getDetailsInfo() {
        LinkedHashMap<String, String> lines = new LinkedHashMap<String, String>();
        boolean isHeightHackApplied = NEIClientConfig.heightHackHandlerRegex.stream().map(pattern -> pattern.matcher(this.handler.getHandlerId())).anyMatch(Matcher::matches);
        lines.put("Name", this.handler.getRecipeName());
        lines.put("ID", this.handler.getOverlayIdentifier());
        lines.put("Key", this.handler.getHandlerId());
        lines.put("H.Hack", String.valueOf(isHeightHackApplied));
        lines.put("Mod Name", this.handlerInfo.getModName());
        lines.put("Mod ID", this.handlerInfo.getModId());
        return lines;
    }

    public void setVisible() {
        if (this.showWidget && this.handler != null) {
            LayoutManager.addWidget(this.order);
            LayoutManager.addWidget(this.yShift);
            LayoutManager.addWidget(this.handlerHeight);
            LayoutManager.addWidget(this.handlerWidth);
            LayoutManager.addWidget(this.multipleWidgetsAllowed);
            LayoutManager.addWidget(this.useCustomScroll);
        }
    }

    @Override
    public void update() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        if (this.showWidget && gui instanceof GuiRecipe) {
            GuiRecipe recipe = (GuiRecipe)gui;
            if (this.handler != recipe.getHandler()) {
                this.handler = recipe.getHandler();
                this.handlerInfo = GuiRecipeTab.getHandlerInfo(this.handler);
                this.order.setText(String.valueOf(NEIClientConfig.getHandlerOrder(this.handler)));
                this.yShift.setText(String.valueOf(this.handlerInfo.getYShift()));
                this.handlerHeight.setText(String.valueOf(this.handlerInfo.getHeight()));
                this.handlerWidth.setText(String.valueOf(this.handlerInfo.getWidth()));
            }
        } else {
            this.handler = null;
            this.handlerInfo = null;
            this.showWidget = false;
        }
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (this.handler != null) {
            int spaceWidth = GuiDraw.fontRenderer.func_78256_a(": ");
            int leftShift = this.x + 6;
            if (mx >= leftShift && mx < this.x + 176 - 6) {
                int topShift = this.y + 6 + 12 + 6;
                for (Map.Entry<String, String> entry : this.getDetailsInfo().entrySet()) {
                    if (my >= topShift && my < topShift + 16) {
                        if (mx < leftShift + 50 + spaceWidth) {
                            tooltip.add(String.valueOf(entry.getKey()));
                            break;
                        }
                        tooltip.add(String.valueOf(entry.getValue()));
                        break;
                    }
                    topShift += 16;
                }
            }
        }
        return tooltip;
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        if (NEIClientConfig.getBooleanSetting("inventory.guirecipe.handlerInfo") && this.showWidget && keyCode == 46 && NEIClientUtils.controlKey()) {
            int spaceWidth = GuiDraw.fontRenderer.func_78256_a(": ");
            Point mouse = GuiDraw.getMousePosition();
            if (mouse.x >= this.x + 6 + 50 + spaceWidth && mouse.x < this.x + 176 - 6) {
                int topShift = this.y + 6 + 12 + 6;
                for (Map.Entry<String, String> entry : this.getDetailsInfo().entrySet()) {
                    if (mouse.y >= topShift && mouse.y < topShift + 16) {
                        GuiScreen.func_146275_d((String)entry.getValue());
                        return true;
                    }
                    topShift += 16;
                }
            }
        }
        return false;
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (NEIClientConfig.getBooleanSetting("inventory.guirecipe.handlerInfo") && keyID == 32 && NEIClientUtils.shiftKey()) {
            this.showWidget = !this.showWidget;
            return true;
        }
        if (this.handler != null) {
            return this.order.focused() || this.yShift.focused() || this.handlerHeight.focused() || this.handlerWidth.focused();
        }
        return false;
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        if (this.handler != null && new Rectangle4i(this.x + 6, this.y + 6, this.w - 12, 12).contains(mousex, mousey)) {
            this.dragPoint = new Point(mousex, mousey);
        }
    }

    @Override
    public boolean contains(int px, int py) {
        return this.handler != null && super.contains(px, py);
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        this.dragPoint = null;
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public boolean handleClickExt(int mx, int my, int button) {
        return false;
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        if (this.dragPoint != null) {
            this.x -= this.dragPoint.x - mousex;
            this.y -= this.dragPoint.y - mousey;
            this.dragPoint.move(mousex, mousey);
        }
    }

    public void drawGuiPlaceholder(NEIRecipeWidget widget) {
        if (!this.showWidget) {
            return;
        }
        NEIClientUtils.gl2DRenderContext(() -> {
            GuiDraw.drawRect((int)widget.x, (int)widget.y, (int)widget.w, (int)widget.h, (int)this.COLORS[widget.handlerRef.recipeIndex % this.COLORS.length]);
            GuiDraw.drawRect((int)(widget.x + widget.w / 2 - 1), (int)widget.y, (int)1, (int)widget.h, (int)-1996488705);
            GuiDraw.drawRect((int)widget.x, (int)(widget.y + widget.h / 2 - 1), (int)widget.w, (int)1, (int)-1996488705);
            GuiDraw.drawRect((int)(widget.x + 14), (int)(widget.y + 5), (int)(widget.w - 38), (int)1, (int)-16777046);
            GuiDraw.drawRect((int)(widget.x + 14), (int)(widget.y + widget.h - 7), (int)(widget.w - 38), (int)1, (int)-16777046);
            GuiDraw.drawRect((int)(widget.x + 24), (int)(widget.y + (widget.h - 16) / 2), (int)1, (int)16, (int)-5635926);
            GuiDraw.drawRect((int)(widget.x + Math.min(168, widget.w) - 27), (int)(widget.y + widget.h - 6 - 24 - 4), (int)12, (int)1, (int)-5635926);
            GuiDraw.drawRect((int)(widget.x + Math.min(168, widget.w) - 35), (int)(widget.y + widget.h - 6 - 12 - 3), (int)20, (int)1, (int)-16733696);
            GuiDraw.drawRect((int)(widget.x + 14), (int)(widget.y + widget.h - 7 - 6), (int)38, (int)1, (int)-5635926);
            IRecipeHandler patt20590$temp = widget.handlerRef.handler;
            if (patt20590$temp instanceof TemplateRecipeHandler) {
                TemplateRecipeHandler handler = (TemplateRecipeHandler)patt20590$temp;
                int yShift = widget.getHandlerInfo().getYShift();
                for (TemplateRecipeHandler.RecipeTransferRect rect : handler.transferRects) {
                    GuiDraw.drawRect((int)(widget.x + rect.rect.x), (int)(widget.y + yShift + rect.rect.y), (int)rect.rect.width, (int)rect.rect.height, (int)0x40FF0000);
                }
            }
        });
    }

    public static void loadHandlerInfoPatch() {
        ClientHandler.loadSettingsFile("handlers.patch", lines -> {
            for (String line : lines.collect(Collectors.toCollection(HashSet::new))) {
                String[] parts = line.split(",");
                String handler = parts[0];
                if (GuiRecipeTab.handlerMap.containsKey(handler)) {
                    HandlerInfo info = GuiRecipeTab.handlerMap.get(handler);
                    int yShift = DebugHandlerWidget.intOrDefault(parts[1], info.getYShift());
                    int height = DebugHandlerWidget.intOrDefault(parts[2], info.getHeight());
                    int width = DebugHandlerWidget.intOrDefault(parts[3], info.getWidth());
                    boolean isMultipleWidgetsAllowed = DebugHandlerWidget.intOrDefault(parts[4], info.isMultipleWidgetsAllowed() ? 1 : 0) == 1;
                    int order = DebugHandlerWidget.intOrDefault(parts[5], NEIClientConfig.handlerOrdering.getOrDefault(handler, 0));
                    boolean useCustomScroll = DebugHandlerWidget.intOrDefault(parts[6], info.getUseCustomScroll() ? 1 : 0) == 1;
                    info.setYShift(yShift);
                    info.setHandlerDimensions(width, height, isMultipleWidgetsAllowed);
                    info.setUseCustomScroll(useCustomScroll);
                    NEIClientConfig.handlerOrdering.put(handler, order);
                }
                patches.put(handler, parts);
            }
        });
    }

    private static void saveHandlerInfoPatch() {
        ArrayList<String> lines = new ArrayList<String>();
        for (CharSequence[] charSequenceArray : patches.values()) {
            lines.add(String.join((CharSequence)",", charSequenceArray));
        }
        File path = new File(NEIClientConfig.configDir, "handlers.patch");
        try (FileOutputStream iOException = new FileOutputStream(path);){
            IOUtils.writeLines(lines, (String)"\n", (OutputStream)iOException, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException2) {
            // empty catch block
        }
    }

    private static int intOrDefault(String str, int defaultValue) {
        if (str == null || str.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String getHandlerID(IRecipeHandler handler) {
        if (GuiRecipeTab.handlerMap.containsKey(handler.getHandlerId())) {
            return handler.getHandlerId();
        }
        if (handler instanceof TemplateRecipeHandler) {
            return handler.getOverlayIdentifier();
        }
        return null;
    }

    private static abstract class IntegerField
    extends TextField {
        protected int defaultValue = 0;

        public IntegerField(String ident, int defaultValue) {
            super(ident);
            this.defaultValue = defaultValue;
            this.h = 16;
            this.z = 2;
            ((FormattedTextField)this.field).setPlaceholder(Integer.toString(this.defaultValue));
        }

        @Override
        protected void initInternalTextField() {
            this.field = new FormattedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0){

                public String func_146179_b() {
                    String text = super.func_146179_b();
                    return !this.func_146206_l() && this.placeholder.equals(text) ? "" : text;
                }

                @Override
                protected boolean beforeWrite(String text) {
                    if (text == null || text.isEmpty()) {
                        return true;
                    }
                    try {
                        return Integer.parseInt(text) >= 0;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                public boolean func_146201_a(char keyChar, int keyID) {
                    if (!this.func_146206_l()) {
                        return false;
                    }
                    if (super.func_146201_a(keyChar, keyID)) {
                        return true;
                    }
                    if (keyID == 208) {
                        this.func_146180_a(Integer.toString(this.getInteger() - 1));
                        return true;
                    }
                    if (keyID == 200) {
                        this.func_146180_a(Integer.toString(this.getInteger() + 1));
                        return true;
                    }
                    return false;
                }
            };
            this.field.func_146203_f(256);
            this.field.func_146196_d();
        }

        protected int getInteger() {
            try {
                return Integer.parseInt(this.text());
            }
            catch (NumberFormatException nfe) {
                return this.defaultValue;
            }
        }

        @Override
        public boolean onMouseWheel(int i, int mx, int my) {
            if (!this.contains(mx, my)) {
                return false;
            }
            this.setText(Integer.toString(this.getInteger() + i));
            return true;
        }
    }
}

