/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.guihook.GuiContainerManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class FastTransferManager {
    public LinkedList<LinkedList<Integer>> slotZones = new LinkedList();
    public HashMap<Integer, Integer> slotZoneMap = new HashMap();

    private void generateSlotMap(Container container, ItemStack stack) {
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        for (int slotNo = 0; slotNo < container.field_75151_b.size(); ++slotNo) {
            if (this.slotZoneMap.containsKey(slotNo) || !container.func_75139_a(slotNo).func_75214_a(stack)) continue;
            HashSet<Integer> connectedSlots = new HashSet<Integer>();
            this.findConnectedSlots(container, slotNo, connectedSlots);
            LinkedList<Integer> zoneSlots = new LinkedList<Integer>(connectedSlots);
            zoneSlots.sort(new SlotPositionComparator(container));
            this.slotZones.add(zoneSlots);
            Iterator iterator = zoneSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.slotZoneMap.put(i, this.slotZones.size() - 1);
            }
        }
    }

    private void findConnectedSlots(Container container, int slotNo, HashSet<Integer> connectedSlots) {
        connectedSlots.add(slotNo);
        Slot slot = container.func_75139_a(slotNo);
        int threshold = 18;
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            if (connectedSlots.contains(i)) continue;
            Slot slot1 = container.func_75139_a(i);
            if (Math.abs(slot.field_75223_e - slot1.field_75223_e) > 18 || Math.abs(slot.field_75221_f - slot1.field_75221_f) > 18) continue;
            this.findConnectedSlots(container, i, connectedSlots);
        }
    }

    public static int findSlotWithItem(Container container, ItemStack teststack) {
        for (int slotNo = 0; slotNo < container.field_75151_b.size(); ++slotNo) {
            ItemStack stack = container.func_75139_a(slotNo).func_75211_c();
            if (!NEIServerUtils.areStacksSameType(stack, teststack)) continue;
            return slotNo;
        }
        return -1;
    }

    public static void clearSlots(Container container) {
        for (int slotNo = 0; slotNo < container.field_75151_b.size(); ++slotNo) {
            ((Slot)container.field_75151_b.get(slotNo)).func_75215_d(null);
        }
    }

    public void performMassTransfer(GuiContainer window, int fromSlot, int toSlot, ItemStack heldStack) {
        this.generateSlotMap(window.field_147002_h, heldStack);
        Integer fromZone = this.slotZoneMap.get(fromSlot);
        Integer toZone = this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone.equals(toZone)) {
            return;
        }
        if (NEIClientUtils.getHeldItem() != null && !NEIServerUtils.areStacksSameType(heldStack, NEIClientUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator iterator = this.slotZones.get(fromZone).iterator();
        while (iterator.hasNext()) {
            int transferFrom = (Integer)iterator.next();
            ItemStack transferStack = window.field_147002_h.func_75139_a(transferFrom).func_75211_c();
            if (!NEIServerUtils.areStacksSameType(heldStack, transferStack)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            FastTransferManager.clickSlot(window, transferFrom);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findShiftClickDestinationSlot(Container container, int fromSlot) {
        LinkedList<ItemStack> save = this.saveContainer(container);
        Slot slot = container.func_75139_a(fromSlot);
        ItemStack stack = slot.func_75211_c();
        if (stack == null) {
            return -1;
        }
        stack.field_77994_a = 1;
        slot.func_75215_d(stack.func_77946_l());
        LinkedList<ItemStack> compareBefore = this.saveContainer(container);
        container.func_75144_a(fromSlot, 0, 1, (EntityPlayer)NEIClientUtils.mc().field_71439_g);
        LinkedList<ItemStack> compareAfter = this.saveContainer(container);
        try {
            for (int i = 0; i < compareBefore.size(); ++i) {
                ItemStack after;
                ItemStack before;
                if (i == fromSlot || NEIServerUtils.areStacksIdentical(before = compareBefore.get(i), after = compareAfter.get(i)) || after == null || !(before == null ? NEIServerUtils.areStacksSameType(stack, after) : NEIServerUtils.areStacksSameType(stack, after) && after.field_77994_a - before.field_77994_a > 0)) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList<ItemStack> saveContainer(Container container) {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            stacks.add(NEIServerUtils.copyStack(container.func_75139_a(i).func_75211_c()));
        }
        return stacks;
    }

    public void restoreContainer(Container container, LinkedList<ItemStack> items) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            container.func_75139_a(i).func_75215_d(items.get(i));
        }
        container.func_75144_a(-999, 0, 0, (EntityPlayer)NEIClientUtils.mc().field_71439_g);
    }

    public void transferItem(GuiContainer window, int fromSlot) {
        int toSlot = this.findShiftClickDestinationSlot(window.field_147002_h, fromSlot);
        if (toSlot == -1) {
            return;
        }
        Slot from = window.field_147002_h.func_75139_a(fromSlot);
        if (from.func_75214_a(from.func_75211_c())) {
            this.moveOneItem(window, fromSlot, toSlot);
        } else {
            this.moveOutputSet(window, fromSlot, toSlot);
        }
    }

    public void transferItems(GuiContainer window, int fromSlot, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            this.transferItem(window, fromSlot);
        }
    }

    public void moveOutputSet(GuiContainer window, int fromSlot, int toSlot) {
        if (NEIClientUtils.getHeldItem() != null) {
            return;
        }
        FastTransferManager.clickSlot(window, fromSlot);
        if (NEIClientUtils.getHeldItem() == null) {
            return;
        }
        FastTransferManager.clickSlot(window, toSlot);
    }

    public void moveOneItem(GuiContainer window, int fromSlot, int toSlot) {
        FastTransferManager.clickSlot(window, fromSlot);
        FastTransferManager.clickSlot(window, toSlot, 1);
        FastTransferManager.clickSlot(window, fromSlot);
    }

    public void retrieveItem(GuiContainer window, int toSlot) {
        Integer integer;
        Slot slot = window.field_147002_h.func_75139_a(toSlot);
        ItemStack slotStack = slot.func_75211_c();
        if (slotStack == null || slotStack.field_77994_a == slot.func_75219_a() || slotStack.field_77994_a == slotStack.func_77976_d()) {
            return;
        }
        this.generateSlotMap(window.field_147002_h, slotStack);
        Integer destZone = this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.field_147002_h, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && (integer = this.slotZoneMap.get(firstZoneSlot)) != null && this.retrieveItemFromZone(window, firstZone = integer.intValue(), toSlot)) {
            return;
        }
        for (int zone = 0; zone < this.slotZones.size(); ++zone) {
            if (zone == destZone || zone == firstZone || !this.retrieveItemFromZone(window, zone, toSlot)) continue;
            return;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(GuiContainer window, int zone, int toSlot) {
        Slot slot;
        ItemStack stack1;
        int i;
        ItemStack stack = window.field_147002_h.func_75139_a(toSlot).func_75211_c();
        Iterator iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.field_147002_h.func_75139_a(i)).func_75211_c()) || stack1.field_77994_a == slot.func_75219_a() || stack1.field_77994_a == stack1.func_77976_d()) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            if (i == toSlot || !NEIServerUtils.areStacksSameType(stack, stack1 = (slot = window.field_147002_h.func_75139_a(i)).func_75211_c())) continue;
            this.moveOneItem(window, i, toSlot);
            return true;
        }
        return false;
    }

    public static void clickSlot(GuiContainer window, int slotIndex) {
        FastTransferManager.clickSlot(window, slotIndex, 0);
    }

    public static void clickSlot(GuiContainer window, int slotIndex, int button) {
        FastTransferManager.clickSlot(window, slotIndex, button, 0);
    }

    public static void clickSlot(GuiContainer window, int slotIndex, int button, int modifier) {
        GuiContainerManager.getManager(window).handleSlotClick(slotIndex, button, modifier);
    }

    public static int dropHeldItem(GuiContainer window) {
        EntityClientPlayerMP player = window.field_146297_k.field_71439_g;
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held == null) {
            return -1;
        }
        for (int i = 0; held != null && i < window.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)window.field_147002_h.field_75151_b.get(i);
            if (!(slot.field_75224_c instanceof InventoryPlayer) || slot.func_75216_d() || !slot.func_75214_a(held)) continue;
            FastTransferManager.clickSlot(window, i, 0, 0);
            if (player.field_71071_by.func_70445_o() != null) continue;
            return i;
        }
        return -1;
    }

    private boolean fillZoneWithHeldItem(GuiContainer window, int zoneIndex) {
        ItemStack inToSlot;
        ItemStack held;
        int transferTo;
        Iterator iterator = this.slotZones.get(zoneIndex).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.field_147002_h.func_75139_a(transferTo).func_75211_c();
            if (!NEIServerUtils.areStacksSameType(inToSlot, held)) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        iterator = this.slotZones.get(zoneIndex).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIClientUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.field_147002_h.func_75139_a(transferTo).func_75211_c();
            if (inToSlot != null) continue;
            FastTransferManager.clickSlot(window, transferTo);
        }
        return NEIClientUtils.getHeldItem() == null;
    }

    public void throwAll(GuiContainer window, int pickedUpFromSlot) {
        ItemStack held = NEIClientUtils.getHeldItem();
        if (held == null) {
            return;
        }
        FastTransferManager.clickSlot(window, -999);
        this.generateSlotMap(window.field_147002_h, held);
        Integer zone = this.slotZoneMap.get(pickedUpFromSlot);
        if (zone == null) {
            return;
        }
        Iterator iterator = this.slotZones.get(zone).iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            Slot slot = window.field_147002_h.func_75139_a(slotIndex);
            if (!NEIServerUtils.areStacksSameType(held, slot.func_75211_c())) continue;
            FastTransferManager.clickSlot(window, slotIndex);
            FastTransferManager.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator<Integer> {
        final Container container;

        public SlotPositionComparator(Container c) {
            this.container = c;
        }

        @Override
        public int compare(Integer arg0, Integer arg1) {
            Slot slot1 = this.container.func_75139_a(arg0.intValue());
            Slot slot2 = this.container.func_75139_a(arg1.intValue());
            if (slot2.field_75221_f != slot1.field_75221_f) {
                return slot1.field_75221_f - slot2.field_75221_f;
            }
            return slot1.field_75223_e - slot2.field_75223_e;
        }
    }
}

