/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils;

import com.cleanroommc.modularui.api.drawable.IInterpolation;
import com.cleanroommc.modularui.utils.Interpolations;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.NotNull;

public enum Interpolation implements IInterpolation
{
    LINEAR("linear"){

        @Override
        public float interpolate(float a, float b, float x) {
            return Interpolations.lerp(a, b, x);
        }
    }
    ,
    QUAD_IN("quad_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * x * x;
        }
    }
    ,
    QUAD_OUT("quad_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a - (b - a) * x * (x - 2.0f);
        }
    }
    ,
    QUAD_INOUT("quad_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            if ((x *= 2.0f) < 1.0f) {
                return a + (b - a) / 2.0f * x * x;
            }
            return a - (b - a) / 2.0f * ((x -= 1.0f) * (x - 2.0f) - 1.0f);
        }
    }
    ,
    CUBIC_IN("cubic_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * x * x * x;
        }
    }
    ,
    CUBIC_OUT("cubic_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * ((x -= 1.0f) * x * x + 1.0f);
        }
    }
    ,
    CUBIC_INOUT("cubic_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            if ((x *= 2.0f) < 1.0f) {
                return a + (b - a) / 2.0f * x * x * x;
            }
            return a + (b - a) / 2.0f * ((x -= 2.0f) * x * x + 2.0f);
        }
    }
    ,
    EXP_IN("exp_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * (float)Math.pow(2.0, 10.0f * (x - 1.0f));
        }
    }
    ,
    EXP_OUT("exp_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            return a + (b - a) * (float)(-Math.pow(2.0, -10.0f * x) + 1.0);
        }
    }
    ,
    EXP_INOUT("exp_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            if (x == 0.0f) {
                return a;
            }
            if (x == 1.0f) {
                return b;
            }
            if ((x *= 2.0f) < 1.0f) {
                return a + (b - a) / 2.0f * (float)Math.pow(2.0, 10.0f * (x - 1.0f));
            }
            return a + (b - a) / 2.0f * (float)(-Math.pow(2.0, -10.0f * (x -= 1.0f)) + 2.0);
        }
    }
    ,
    BACK_IN("back_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c3 = 2.70158f;
            return Interpolations.lerp(a, b, 2.70158f * x * x * x - 1.70158f * x * x);
        }
    }
    ,
    BACK_OUT("back_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c3 = 2.70158f;
            return Interpolations.lerp(a, b, 1.0f + 2.70158f * (float)Math.pow(x - 1.0f, 3.0) + 1.70158f * (float)Math.pow(x - 1.0f, 2.0));
        }
    }
    ,
    BACK_INOUT("back_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c1 = 1.70158f;
            float c2 = 2.5949094f;
            float factor = (double)x < 0.5 ? (float)Math.pow(2.0f * x, 2.0) * (7.189819f * x - 2.5949094f) / 2.0f : ((float)Math.pow(2.0f * x - 2.0f, 2.0) * (3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0f) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_IN("elastic_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c4 = 2.0943952f;
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : -((float)Math.pow(2.0, 10.0f * x - 10.0f)) * (float)Math.sin(((double)(x * 10.0f) - 10.75) * 2.094395160675049));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_OUT("elastic_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c4 = 2.0943952f;
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : (float)Math.pow(2.0, -10.0f * x) * (float)Math.sin(((double)(x * 10.0f) - 0.75) * 2.094395160675049) + 1.0f);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    ELASTIC_INOUT("elastic_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float c5 = 1.3962635f;
            float v = (float)Math.sin(((double)(20.0f * x) - 11.125) * 1.3962634801864624);
            float factor = x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : ((double)x < 0.5 ? -((float)Math.pow(2.0, 20.0f * x - 10.0f) * v) / 2.0f : (float)Math.pow(2.0, -20.0f * x + 10.0f) * v / 2.0f + 1.0f));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    BOUNCE_IN("bounce_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            return Interpolations.lerp(a, b, 1.0f - BOUNCE_OUT.interpolate(0.0f, 1.0f, 1.0f - x));
        }
    }
    ,
    BOUNCE_OUT("bounce_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float n1 = 7.5625f;
            float d1 = 2.75f;
            float factor = x < 0.36363637f ? 7.5625f * x * x : (x < 0.72727275f ? 7.5625f * (x -= 0.54545456f) * x + 0.75f : ((double)x < 0.9090909090909091 ? 7.5625f * (x -= 0.8181818f) * x + 0.9375f : 7.5625f * (x -= 0.95454544f) * x + 0.984375f));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    BOUNCE_INOUT("bounce_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? (1.0f - BOUNCE_OUT.interpolate(0.0f, 1.0f, 1.0f - 2.0f * x)) / 2.0f : (1.0f + BOUNCE_OUT.interpolate(0.0f, 1.0f, 2.0f * x - 1.0f)) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_IN("sine_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.cos((double)x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_OUT("sine_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (float)Math.sin((double)x * Math.PI / 2.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    SINE_INOUT("sine_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (float)(-(Math.cos(Math.PI * (double)x) - 1.0) / 2.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_IN("quart_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_OUT("quart_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.pow(1.0f - x, 4.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUART_INOUT("quart_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? 8.0f * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_IN("quint_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = x * x * x * x * x;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_OUT("quint_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = 1.0f - (float)Math.pow(1.0f - x, 5.0);
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    QUINT_INOUT("quint_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)x < 0.5 ? 16.0f * x * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_IN("circle_in"){

        @Override
        public float interpolate(float a, float b, float x) {
            x = MathHelper.func_76131_a((float)x, (float)0.0f, (float)1.0f);
            float factor = 1.0f - (float)Math.sqrt(1.0 - Math.pow(x, 2.0));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_OUT("circle_out"){

        @Override
        public float interpolate(float a, float b, float x) {
            x = MathHelper.func_76131_a((float)x, (float)0.0f, (float)1.0f);
            float factor = (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
            return Interpolations.lerp(a, b, factor);
        }
    }
    ,
    CIRCLE_INOUT("circle_inout"){

        @Override
        public float interpolate(float a, float b, float x) {
            float factor = (double)(x = MathHelper.func_76131_a((float)x, (float)0.0f, (float)1.0f)) < 0.5 ? (float)(1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0f : (float)(Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0f;
            return Interpolations.lerp(a, b, factor);
        }
    };

    public final String name;

    private Interpolation(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public static Interpolation getForName(String name) {
        for (Interpolation interpolation : Interpolation.values()) {
            if (!interpolation.name.equals(name)) continue;
            return interpolation;
        }
        return null;
    }
}

