/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.EntityAILavaMonsterAttack;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class EntityLavaMonster
extends EntityMob
implements ISpecialMob {
    public static final double MAX_HEALTH = Properties.getDouble("lavamonster_general", "lavamonster_health");
    public static final int BASE_ARMOR = Properties.getInt("lavamonster_general", "lavamonster_armor");
    public static final double SPAWN_CHANCE = Properties.getDouble("lavamonster_spawning", "lavamonster_spawn_chance");
    public static final boolean ANIMATE_TEXTURE = Properties.getBoolean("lavamonster_general", "lavamonster_animated_texture");
    public static final boolean START_FIRES = Properties.getBoolean("lavamonster_general", "lavamonster_fires");
    public static final boolean BASIC_LOOT = Properties.getBoolean("lavamonster_general", "lavamonster_basic_loot");
    public static final int HEAL_TIME = Properties.getInt("lavamonster_general", "lavamonster_heal_time");
    public static final double HEAL_PERCENT = Properties.getDouble("lavamonster_general", "lavamonster_heal_percent");
    public static final double HEAL_MAX = Properties.getDouble("lavamonster_general", "lavamonster_heal_max");
    public static ArrayList<ChatComponentText> chatSnark = new ArrayList();
    public static ArrayList<ChatComponentText> chatSuper = new ArrayList();
    public int attackDelay = 0;
    private boolean textureInc = true;
    private byte textureTicks = 0;
    private byte textureIndex = 0;

    public EntityLavaMonster(World world) {
        super(world);
        this.func_70105_a(0.8f, 2.2f);
        this.field_70178_ae = true;
        this.field_70728_aV = 8;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILavaMonsterAttack(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(MAX_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)0);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + BASE_ARMOR);
    }

    public void func_70636_d() {
        float damage;
        if (this.field_70170_p.field_72995_K) {
            this.updateTexture();
        } else {
            this.attackDelay = Math.max(0, this.attackDelay - 1);
            if (this.func_70026_G()) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(100) == 0) {
            this.field_70170_p.func_72869_a("lava", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + (double)this.field_70131_O / 2.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            this.field_70170_p.func_72956_a((Entity)this, "liquid.lavapop", 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.field_70170_p.func_72956_a((Entity)this, "liquid.lava", 0.2f + this.field_70146_Z.nextFloat() * 0.2f, 0.9f + this.field_70146_Z.nextFloat() * 0.15f);
        }
        if (this.field_70146_Z.nextInt(HEAL_TIME * 2) == 0 && this.field_70170_p.func_147439_a((int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v)).func_149688_o() == Material.field_151587_i && (damage = this.func_110138_aP() - this.func_110143_aJ()) != 0.0f) {
            damage = (float)Math.max((double)damage * HEAL_PERCENT, 1.0);
            this.func_70691_i((float)Math.min((double)damage, HEAL_MAX));
        }
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (START_FIRES && this.field_70170_p.func_147437_c(x, y, z)) {
            this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 2);
        }
        if (this.func_70013_c(1.0f) > 0.5f) {
            this.field_70708_bq -= 2;
        }
        super.func_70636_d();
    }

    public void attackEntityWithFireball(EntityLivingBase target) {
        EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, target.field_70165_t - this.field_70165_t, target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - (double)(this.field_70131_O / 2.0f), target.field_70161_v - this.field_70161_v);
        fireball.field_70163_u = this.field_70163_u + (double)this.field_70131_O - 0.5;
        this.func_85030_a("mob.ghast.fireball", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.isDamageSourceEffective(damageSource)) {
            damage = Math.max(this.func_110138_aP() / 2.0f - 1.0f, damage);
            this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSuper);
        }
        if (damageSource.func_76347_k()) {
            this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSnark);
            damage = 0.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean isDamageSourceEffective(DamageSource damageSource) {
        if (damageSource != null) {
            ItemStack heldItem;
            if (damageSource.func_76357_e()) {
                return true;
            }
            if (damageSource.func_76364_f() instanceof EntitySnowball || Properties.EntityFrostShardClass.isInstance(damageSource.func_76364_f()) || Properties.EntityIceArrow.isInstance(damageSource.func_76364_f())) {
                return true;
            }
            Entity attacker = damageSource.func_76346_g();
            if (attacker instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)attacker).func_70694_bm()) != null && Properties.ItemTFIceSword.isInstance(heldItem.func_77973_b())) {
                return true;
            }
            if ("frost".equals(damageSource.func_76355_l())) {
                return true;
            }
        }
        return false;
    }

    protected Item func_146068_u() {
        return Items.field_151059_bz;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151044_h, 1);
        }
        if (recentlyHit && (this.field_70146_Z.nextInt(2) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151059_bz, 1);
        }
        if (!BASIC_LOOT && recentlyHit && this.field_70146_Z.nextInt(15) == 0) {
            this.func_145779_a(Items.field_151129_at, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        if (superRare == 0 || BASIC_LOOT) {
            ItemStack drop = new ItemStack((Item)Items.field_151167_ab);
            drop.func_151001_c("\u00a7cLava Slippers");
            drop.func_77966_a(Enchantment.field_77329_d, 3);
            this.func_70099_a(drop, 1.0f);
        } else {
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    ItemStack drop = new ItemStack((Item)Items.field_151175_af);
                    drop.func_151001_c("\u00a7cFirefighter Boots");
                    drop.func_77966_a(Enchantment.field_77329_d, 4);
                    drop.func_77966_a(Enchantment.field_77330_e, 2);
                    this.func_70099_a(drop, 1.0f);
                    break;
                }
                case 1: {
                    ItemStack drop = new ItemStack((Item)Items.field_151173_ae);
                    drop.func_151001_c("\u00a7cFirefighter Pants");
                    drop.func_77966_a(Enchantment.field_77329_d, 4);
                    drop.func_77966_a(Enchantment.field_77327_f, 2);
                    this.func_70099_a(drop, 1.0f);
                    break;
                }
                case 2: {
                    ItemStack drop = new ItemStack((Item)Items.field_151163_ad);
                    drop.func_151001_c("\u00a7cFirefighter Jacket");
                    drop.func_77966_a(Enchantment.field_77329_d, 4);
                    drop.func_77966_a(Enchantment.field_77328_g, 2);
                    this.func_70099_a(drop, 1.0f);
                    break;
                }
                case 3: {
                    ItemStack drop = new ItemStack((Item)Items.field_151161_ac);
                    drop.func_151001_c("\u00a7cFirefighter Helmet");
                    drop.func_77966_a(Enchantment.field_77329_d, 4);
                    drop.func_77966_a(Enchantment.field_77340_h, 2);
                    this.func_70099_a(drop, 0.0f);
                }
            }
        }
    }

    public boolean func_70027_ad() {
        return this.field_70180_af.func_75683_a(31) == 1;
    }

    public void setBurningState(boolean state) {
        this.field_70180_af.func_75692_b(31, (Object)(state ? (byte)1 : 0));
    }

    public void updateTexture() {
        if (!ANIMATE_TEXTURE || (this.textureTicks = (byte)(this.textureTicks + 1)) < 2) {
            return;
        }
        this.textureTicks = 0;
        this.textureIndex = (byte)(this.textureIndex + (this.textureInc ? 1 : -1));
        if (this.textureIndex < 0) {
            this.textureIndex = 1;
            this.textureInc = true;
        } else if (this.textureIndex > 19) {
            this.textureIndex = (byte)18;
            this.textureInc = false;
        }
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return this.field_70146_Z.nextDouble() < SPAWN_CHANCE && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
    }

    protected String func_70621_aR() {
        return "mob.ghast.scream";
    }

    protected String func_70673_aS() {
        return "mob.ghast.death";
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public int getEntityBrightnessForRender(float f) {
        return 0xF000F0;
    }

    public float getEntityBrightness(float f) {
        return 1.0f;
    }

    @Override
    public SpecialMobData getSpecialData() {
        return null;
    }

    @Override
    public void adjustEntityAttributes() {
    }

    static {
        ISpecialMob.loadChat("entity.SpecialMobs.LavaMonster", chatSnark, chatSuper);
    }
}

