/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.lib.LibRenderIDs;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockModDoubleFlower
extends BlockDoublePlant
implements ILexiconable {
    private static final int COUNT = 8;
    IIcon[] field_149894_N;
    IIcon[] field_149893_M;
    IIcon[] doublePlantTopIconsAlt;
    IIcon[] doublePlantBottomIconsAlt;
    final int offset;

    public BlockModDoubleFlower(boolean second) {
        this.offset = second ? 8 : 0;
        this.func_149663_c("doubleFlower" + (second ? 2 : 1));
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        this.func_149675_a(false);
        this.func_149647_a(BotaniaCreativeTab.INSTANCE);
    }

    public Block func_149663_c(String name) {
        if (!name.equals("doublePlant")) {
            GameRegistry.registerBlock((Block)this, ItemBlockWithMetadataAndName.class, (String)name);
        }
        return super.func_149663_c(name);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return null;
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149888_a(boolean top, int index) {
        return (ConfigHandler.altFlowerTextures ? (top ? this.doublePlantTopIconsAlt : this.doublePlantBottomIconsAlt) : (top ? this.field_149894_N : this.field_149893_M))[index & 7];
    }

    public void func_149889_c(World world, int x, int y, int z, int baseMeta, int flags) {
        world.func_147465_d(x, y, z, (Block)this, baseMeta, flags);
        world.func_147465_d(x, y + 1, z, (Block)this, baseMeta | 8, flags);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        world.func_147465_d(x, y + 1, z, (Block)this, itemIn.func_77960_j() | 8, 2);
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return false;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (world.field_72995_K || player.func_71045_bC() == null || player.func_71045_bC().func_77973_b() != Items.field_151097_aZ || BlockModDoubleFlower.func_149887_c((int)meta)) {
            this.harvestBlockCopy(world, player, x, y, z, meta);
        }
    }

    public void harvestBlockCopy(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[BlockModDoubleFlower.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(world, player, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_149644_j(meta);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                this.func_149642_a(world, x, y, z, is);
            }
        } else {
            this.harvesters.set(player);
            int i1 = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_149697_b(world, x, y, z, meta, i1);
            this.harvesters.set(null);
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (BlockModDoubleFlower.func_149887_c((int)meta)) {
            if (world.func_147439_a(x, y - 1, z) == this) {
                if (!player.field_71075_bZ.field_75098_d) {
                    int i1 = world.func_72805_g(x, y - 1, z);
                    int j1 = BlockModDoubleFlower.func_149890_d((int)i1);
                    if (j1 == 3 || j1 == 2) {
                        world.func_147468_f(x, y - 1, z);
                    }
                } else {
                    world.func_147468_f(x, y - 1, z);
                }
            }
        } else if (player.field_71075_bZ.field_75098_d && world.func_147439_a(x, y + 1, z) == this) {
            world.func_147465_d(x, y + 1, z, Blocks.field_150350_a, 0, 2);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 7));
        return ret;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public IIcon func_149691_a(int side, int meta) {
        boolean top = BlockModDoubleFlower.func_149887_c((int)meta);
        return (ConfigHandler.altFlowerTextures ? (top ? this.doublePlantTopIconsAlt : this.doublePlantBottomIconsAlt) : (top ? this.field_149894_N : this.field_149893_M))[meta & 7];
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        boolean top = BlockModDoubleFlower.func_149887_c((int)meta);
        if (top) {
            meta = world.func_72805_g(x, y - 1, z);
        }
        return (ConfigHandler.altFlowerTextures ? (top ? this.doublePlantBottomIconsAlt : this.doublePlantTopIconsAlt) : (top ? this.field_149893_M : this.field_149894_N))[meta & 7];
    }

    public void func_149651_a(IIconRegister register) {
        this.field_149894_N = new IIcon[8];
        this.field_149893_M = new IIcon[8];
        this.doublePlantTopIconsAlt = new IIcon[8];
        this.doublePlantBottomIconsAlt = new IIcon[8];
        for (int i = 0; i < 8; ++i) {
            int off = this.offset(i);
            this.field_149894_N[i] = IconHelper.forName(register, "flower" + off + "Tall0");
            this.field_149893_M[i] = IconHelper.forName(register, "flower" + off + "Tall1");
            this.doublePlantTopIconsAlt[i] = IconHelper.forName(register, "flower" + off + "Tall0", "alt");
            this.doublePlantBottomIconsAlt[i] = IconHelper.forName(register, "flower" + off + "Tall1", "alt");
        }
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        return 0xFFFFFF;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 8; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149645_b() {
        return LibRenderIDs.idDoubleFlower;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        float[] color = EntitySheep.field_70898_d[this.offset(meta & 7)];
        if (random.nextDouble() < ConfigHandler.flowerParticleFrequency) {
            Botania.proxy.sparkleFX(world, (double)x + 0.3 + (double)random.nextFloat() * 0.5, (double)y + 0.5 + (double)random.nextFloat() * 0.5, (double)z + 0.3 + (double)random.nextFloat() * 0.5, color[0], color[1], color[2], random.nextFloat(), 5);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, int x, int y, int z, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.flowers;
    }

    int offset(int meta) {
        return meta + this.offset;
    }
}

