/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSword;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBamboo
extends BaseBlock
implements IPlantable,
IGrowable {
    public IIcon[] leaves;
    private static final Vec3 OFFSET_VEC = Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.5);

    public BlockBamboo() {
        super(Material.field_151575_d);
        this.func_149658_d("bamboo_stalk");
        this.setHarvestLevel("axe", 0);
        this.setBlockSound(ModSounds.soundBamboo);
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149675_a(true);
        this.func_149713_g(0);
    }

    public float func_149737_a(EntityPlayer player, World worldIn, int x, int y, int z) {
        if (player.func_71045_bC() != null) {
            Set classes = player.func_71045_bC().func_77973_b().getToolClasses(player.func_71045_bC());
            if (player.func_71045_bC().func_77973_b() instanceof ItemSword || classes.contains("sword")) {
                return Float.POSITIVE_INFINITY;
            }
        }
        return super.func_149737_a(player, worldIn, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        return ModBlocks.BAMBOO_SAPLING.get().func_149742_c(world, x, y, z) || block == ModBlocks.BAMBOO_SAPLING.get() || block == this;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y - 1, z);
        return ModBlocks.BAMBOO_SAPLING.get().func_149707_d(world, x, y, z, side) || block == ModBlocks.BAMBOO_SAPLING.get() || block == this;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        return ModBlocks.BAMBOO_SAPLING.get().func_149718_j(world, x, y, z) || block == ModBlocks.BAMBOO_SAPLING.get() || block == this;
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (world.func_147439_a(x, y + 1, z) == this && BlockBamboo.getStalkSize(world.func_72805_g(x, y + 1, z)) > BlockBamboo.getStalkSize(meta)) {
            world.func_147465_d(x, y, z, (Block)this, BlockBamboo.setStalkSize(meta, true), 3);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int i;
        this.checkAndDropBlock(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (BlockBamboo.getStage(meta) == 0 && rand.nextInt(3) == 0 && world.func_147437_c(x, y + 1, z) && world.func_72957_l(x, y + 1, z) >= 9 && (i = this.getHeightBelowUpToMax(world, x, y, z) + 1) < 16) {
            this.growBamboo(world, x, y, z, rand, i);
        }
    }

    protected void checkAndDropBlock(World worldIn, int x, int y, int z) {
        if (!this.func_149718_j(worldIn, x, y, z)) {
            this.func_149697_b(worldIn, x, y, z, worldIn.func_72805_g(x, y, z), 0);
            worldIn.func_147468_f(x, y, z);
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float subX, float subY, float subZ, int meta) {
        if (world.func_147439_a(x, y - 1, z) == this) {
            int metaLower = world.func_72805_g(x, y - 1, z);
            int bambooMeta = 0;
            bambooMeta = BlockBamboo.setStalkSize(bambooMeta, BlockBamboo.getStalkSize(metaLower) == 1);
            bambooMeta = BlockBamboo.setStage(bambooMeta, BlockBamboo.getStage(metaLower) == 1);
            return bambooMeta;
        }
        return super.func_149660_a(world, x, y, z, side, subX, subY, subZ, meta);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return ModItems.BAMBOO.get();
    }

    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return ModItems.BAMBOO.get();
    }

    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.leaves = new IIcon[]{reg.func_94245_a("bamboo_singleleaf"), reg.func_94245_a("bamboo_small_leaves"), reg.func_94245_a("bamboo_large_leaves")};
    }

    public int func_149645_b() {
        return RenderIDs.BAMBOO;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side > 1 || !(world.func_147439_a(x, y, z) instanceof BlockBamboo) && super.func_149646_a(world, x, y, z, side);
    }

    public static int getLeavesSize(int meta) {
        return (meta & 6) >> 1;
    }

    public static int setLeavesSize(int meta, int size) {
        return (meta &= 0xFFFFFFF9) | (size == 0 ? 0 : (size == 1 ? 2 : 4));
    }

    public static int getStage(int meta) {
        return meta >> 3;
    }

    public static int setStage(int meta, boolean complete) {
        return (meta &= 0xFFFFFEFF) | (complete ? 8 : 0);
    }

    public static int getStalkSize(int meta) {
        return meta & 1;
    }

    public static int setStalkSize(int meta, boolean large) {
        return (meta &= 0xFFFFFFFD) | (large ? 1 : 0);
    }

    public static Vec3 getOffset(int x, int z) {
        BlockBamboo.OFFSET_VEC.field_72450_a = 0.1875 + (double)(Math.abs(Utils.cantor((long)x * 2654435761L, (long)z * -2654435761L)) % 41L) * 0.015625;
        BlockBamboo.OFFSET_VEC.field_72449_c = 0.1875 + (double)(Math.abs(Utils.cantor((long)z * 2654435761L, (long)x * -2654435761L)) % 41L) * 0.015625;
        return OFFSET_VEC;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        Vec3 offsetBox = BlockBamboo.getOffset(x, z);
        int meta = world.func_72805_g(x, y, z);
        double size = 0.1875;
        if (BlockBamboo.getLeavesSize(meta) == 2) {
            size += 0.125;
        }
        this.func_149676_a((float)(offsetBox.field_72450_a - size), 0.0f, (float)(offsetBox.field_72449_c - size), (float)(offsetBox.field_72450_a + size), 1.0f, (float)(offsetBox.field_72449_c + size));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        Vec3 offsetBox = BlockBamboo.getOffset(x, z);
        int meta = world.func_72805_g(x, y, z);
        double size = 0.1875;
        if (BlockBamboo.getLeavesSize(meta) == 2) {
            size += 0.125;
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + offsetBox.field_72450_a - size), (double)y, (double)((double)z + offsetBox.field_72449_c - size), (double)((double)x + offsetBox.field_72450_a + size), (double)(y + 1), (double)((double)z + offsetBox.field_72449_c + size));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        Vec3 offsetBox = BlockBamboo.getOffset(x, z);
        double size = BlockBamboo.getStalkSize(world.func_72805_g(x, y, z)) == 1 ? 0.09375 : 0.0625;
        return AxisAlignedBB.func_72330_a((double)((double)x + offsetBox.field_72450_a - size), (double)y, (double)((double)z + offsetBox.field_72449_c - size), (double)((double)x + offsetBox.field_72450_a + size), (double)(y + 1), (double)((double)z + offsetBox.field_72449_c + size));
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 30;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z);
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean unused) {
        int j;
        int i = this.getHeightAboveUpToMax(world, x, y, z);
        return i + (j = this.getHeightBelowUpToMax(world, x, y, z)) + 1 < 16 && BlockBamboo.getStage(world.func_72805_g(x, y + i, z)) != 1;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        int i = this.getHeightAboveUpToMax(world, x, y, z);
        int j = this.getHeightBelowUpToMax(world, x, y, z);
        int k = i + j + 1;
        int l = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            Block block = world.func_147439_a(x, y + i, z);
            int meta = world.func_72805_g(x, y + i, z);
            if (k >= 16 || block != this || BlockBamboo.getStage(meta) == 1 || !world.func_147437_c(x, y + i + 1, z)) {
                return;
            }
            this.growBamboo(world, x, y + i, z, rand, k);
            ++i;
            ++k;
        }
    }

    protected void growBamboo(World world, int x, int y, int z, Random rand, int height) {
        Block origin = world.func_147439_a(x, y, z);
        if (origin == this) {
            int originMeta = world.func_72805_g(x, y, z);
            Block blockBelow1 = world.func_147439_a(x, y - 1, z);
            int metaBelow1 = world.func_72805_g(x, y - 1, z);
            Block blockBelow2 = world.func_147439_a(x, y - 2, z);
            int metaBelow2 = world.func_72805_g(x, y - 2, z);
            int bambooleaves = 0;
            if (height >= 1) {
                if (blockBelow1 == this && BlockBamboo.getLeavesSize(metaBelow1) != 0) {
                    bambooleaves = 2;
                    if (blockBelow2 == this) {
                        world.func_147465_d(x, y - 1, z, (Block)this, BlockBamboo.setLeavesSize(metaBelow1, 1), 3);
                        world.func_147465_d(x, y - 2, z, (Block)this, BlockBamboo.setLeavesSize(metaBelow2, 0), 3);
                    }
                } else {
                    bambooleaves = 1;
                }
            }
            boolean stalkSize = BlockBamboo.getStalkSize(originMeta) == 1 || blockBelow2 == this;
            boolean complete = height >= 11 && rand.nextFloat() < 0.25f || height == 15;
            world.func_147465_d(x, y + 1, z, (Block)this, BlockBamboo.setLeavesSize(BlockBamboo.setStage(BlockBamboo.setStalkSize(0, stalkSize), complete), bambooleaves), 3);
        }
    }

    protected int getHeightAboveUpToMax(World world, int x, int y, int z) {
        int i;
        for (i = 0; i < 16 && world.func_147439_a(x, y + i + 1, z) == this; ++i) {
        }
        return i;
    }

    protected int getHeightBelowUpToMax(World world, int x, int y, int z) {
        int i;
        for (i = 0; i < 16 && world.func_147439_a(x, y - (i + 1), z) == this; ++i) {
        }
        return i;
    }
}

