/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.Lists;
import java.util.List;
import openmods.calc.Environment;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.calc.SingleReturnCallable;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;
import openmods.utils.StackValidationException;

public class GenericFunctions {
    public static <E> void createStackManipulationFunctions(Environment<E> calculator) {
        calculator.setGlobalSymbol("swap", new FixedCallable<E>(2, 2){

            @Override
            public void call(Frame<E> frame) {
                Stack stack = frame.stack();
                Object first = stack.pop();
                Object second = stack.pop();
                stack.push(first);
                stack.push(second);
            }
        });
        calculator.setGlobalSymbol("pop", new ICallable<E>(){

            @Override
            public void call(Frame<E> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                if (returnsCount.isPresent() && returnsCount.get() != 0) {
                    throw new StackValidationException("Invalid expected return values on 'pop'");
                }
                Stack stack = frame.stack();
                int count = argumentsCount.or(1);
                for (int i = 0; i < count; ++i) {
                    stack.pop();
                }
            }
        });
        calculator.setGlobalSymbol("dup", new ICallable<E>(){

            @Override
            public void call(Frame<E> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                Stack stack = frame.stack();
                List values = Lists.newArrayList();
                int in = argumentsCount.or(1);
                for (int i = 0; i < in; ++i) {
                    Object value = stack.pop();
                    values.add(value);
                }
                values = Lists.reverse((List)values);
                int out = returnsCount.or(2 * in);
                for (int i = 0; i < out; ++i) {
                    Object value = values.get(i % in);
                    stack.push(value);
                }
            }
        });
    }

    public static abstract class AccumulatorFunction<E>
    extends SingleReturnCallable<E> {
        private final E nullValue;

        public AccumulatorFunction(E nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public E call(Frame<E> frame, OptionalInt argumentsCount) {
            Stack<E> stack = frame.stack();
            int args = argumentsCount.or(2);
            if (args == 0) {
                return this.nullValue;
            }
            E result = stack.pop();
            for (int i = 1; i < args; ++i) {
                E value = stack.pop();
                result = this.accumulate(value, result);
            }
            return this.process(result, args);
        }

        protected E process(E result, int argCount) {
            return result;
        }

        protected abstract E accumulate(E var1, E var2);
    }

    public static interface Accumulator<E> {
        public E accumulate(E var1, E var2);
    }
}

