/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.pool;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.pool.ObjectPool;

public final class ConcurrentQueueObjectPool<O>
implements ObjectPool<O> {
    private final AtomicInteger count = new AtomicInteger(0);
    private final Queue<O> queue = new ConcurrentLinkedQueue<O>();
    private final ObjectPool.ObjectSupplier<O> supplier;
    private final int maxCapacity;
    private final ObjectPool.ObjectSanitizer<O> sanitizer;

    public ConcurrentQueueObjectPool(ObjectPool.ObjectSupplier<@NonNull O> supplier, ObjectPool.ObjectSanitizer<@NonNull O> sanitizer, int maxCapacity) {
        if (maxCapacity < 0) {
            throw new IllegalArgumentException("maxCapacity");
        }
        this.supplier = Objects.requireNonNull(supplier);
        this.sanitizer = Objects.requireNonNull(sanitizer);
        this.maxCapacity = maxCapacity;
    }

    @Override
    public ObjectPool.Lease<O> take() {
        O obj = this.queue.poll();
        if (obj == null) {
            obj = Objects.requireNonNull(this.supplier.get());
        } else {
            this.count.decrementAndGet();
        }
        return new LeaseImpl(obj);
    }

    private final class LeaseImpl
    implements ObjectPool.Lease<O> {
        private @Nullable O obj;

        public LeaseImpl(O obj) {
            this.obj = obj;
        }

        @Override
        public O get() {
            return this.obj;
        }

        @Override
        public synchronized void close() {
            @Nullable O theObject = this.obj;
            this.obj = null;
            if (theObject != null && ConcurrentQueueObjectPool.this.count.get() < ConcurrentQueueObjectPool.this.maxCapacity && ConcurrentQueueObjectPool.this.sanitizer.sanitize(theObject) && ConcurrentQueueObjectPool.this.queue.offer(theObject)) {
                ConcurrentQueueObjectPool.this.count.incrementAndGet();
            }
        }

        @Override
        public void discard() {
            this.obj = null;
        }
    }
}

