/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.model.ModelCraneBackpack;
import openblocks.common.CraneRegistry;
import openmods.infobook.BookDocumentation;

@BookDocumentation(customName="crane_backpack", hasVideo=true)
public class ItemCraneBackpack
extends ItemArmor {
    private static final int ARMOR_CHESTPIECE = 1;
    public static final String TEXTURE_CRANE = "openblocks:textures/models/crane.png";

    public ItemCraneBackpack() {
        super(ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return armorSlot == 1 ? ModelCraneBackpack.instance : null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE_CRANE;
    }

    private static boolean isPointInBlock(World world, EntityPlayer player, double radius) {
        double posZ;
        double posY;
        double posX = player.field_70165_t + radius * (double)MathHelper.func_76134_b((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(posX - 0.1), (double)((posY = player.field_70163_u + (double)player.func_70047_e() + 0.2) - 0.1), (double)((posZ = player.field_70161_v + radius * (double)MathHelper.func_76126_a((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f))) - 0.1), (double)(posX + 0.1), (double)(posY + 0.1), (double)(posZ + 0.1));
        return !world.func_72945_a((Entity)player, aabb).isEmpty();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        CraneRegistry.Data data = CraneRegistry.instance.getData(player, true);
        if (!world.field_72995_K) {
            CraneRegistry.instance.ensureMagnetExists(player);
        }
        if (Config.doCraneCollisionCheck) {
            boolean isColliding;
            boolean bl = isColliding = ItemCraneBackpack.isPointInBlock(world, player, 2.0) || ItemCraneBackpack.isPointInBlock(world, player, 1.3333333333333333) || ItemCraneBackpack.isPointInBlock(world, player, 0.6666666666666666);
            if (isColliding) {
                player.field_70177_z = data.prevYaw;
                player.field_70165_t = data.prevPosX;
                player.field_70163_u = data.prevPosY;
                player.field_70161_v = data.prevPosZ;
                player.field_70179_y = 0.0;
                player.field_70181_x = 0.0;
                player.field_70159_w = 0.0;
            } else {
                data.prevYaw = player.field_70177_z;
                data.prevPosX = player.field_70165_t;
                data.prevPosY = player.field_70163_u;
                data.prevPosZ = player.field_70161_v;
            }
        }
    }

    public static boolean isWearingCrane(EntityPlayer player) {
        ItemStack armor = player.func_82169_q(2);
        return armor != null && armor.func_77973_b() instanceof ItemCraneBackpack;
    }
}

