/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.prediction;

import ic2.api.crops.CropCard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.inventory.GuiBreeding;
import speiger.src.crops.prediction.BreedResult;

public class BreedTask
implements Callable<List<BreedResult>> {
    static final Comparator<CropCard> SORTER = new Comparator<CropCard>(){

        @Override
        public int compare(CropCard o1, CropCard o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    };
    CropCard[] input;
    int hashCode;

    public BreedTask(CropCard ... input) {
        this.input = input;
        Arrays.sort(this.input, SORTER);
        this.hashCode = Arrays.hashCode(this.input);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreedTask) {
            return this.matches((BreedTask)obj);
        }
        return false;
    }

    public boolean matches(BreedTask other) {
        if (other.input.length != this.input.length) {
            return false;
        }
        if (this.hashCode == other.hashCode) {
            return true;
        }
        int m = this.input.length;
        for (int i = 0; i < m; ++i) {
            if (other.input[i] == this.input[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BreedResult> call() {
        ArrayList<CropCard> toBreed = new ArrayList<CropCard>();
        int m = this.input.length;
        for (int i = 0; i < m; ++i) {
            toBreed.add(this.input[i]);
        }
        ArrayList<CropCard> resultList = new ArrayList<CropCard>(IC2NeiPlugin.ALL_CROPS);
        int[] ratios = new int[resultList.size()];
        int total = 0;
        int m2 = resultList.size();
        for (int i = 0; i < m2; ++i) {
            CropCard card = (CropCard)resultList.get(i);
            int n = toBreed.size();
            for (int j = 0; j < n; ++j) {
                int chance = GuiBreeding.calculateRatioFor(card, (CropCard)toBreed.get(j));
                int n2 = i;
                ratios[n2] = ratios[n2] + chance;
                total += chance;
            }
        }
        ArrayList<BreedResult> results = new ArrayList<BreedResult>();
        int m3 = resultList.size();
        for (int i = 0; i < m3; ++i) {
            if (ratios[i] <= 0 || !this.valid((CropCard)resultList.get(i))) continue;
            results.add(new BreedResult((CropCard)resultList.get(i), ratios[i], total, this.input));
        }
        return results;
    }

    protected boolean valid(CropCard result) {
        int m = this.input.length;
        for (int i = 0; i < m; ++i) {
            if (this.input[i] != result) continue;
            return false;
        }
        return true;
    }
}

