/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.logic.FluidInventoryLogic;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;

public class ControllerFluidLogic {
    private final Map<UUID, FluidInventoryLogic> inventories = new HashMap<UUID, FluidInventoryLogic>();
    private final Set<Pair<UUID, FluidInventoryLogic>> unallocatedInventories = new HashSet<Pair<UUID, FluidInventoryLogic>>();

    public void addInventory(@Nonnull UUID id, @Nonnull FluidInventoryLogic inventory) {
        Pair<UUID, FluidInventoryLogic> found = this.checkIfInventoryExistsAsUnallocated(inventory);
        if (inventory.isUpgradeInventory() && found != null) {
            this.unallocatedInventories.remove(found);
            this.inventories.put(id, (FluidInventoryLogic)found.getRight());
            return;
        }
        this.inventories.put(id, inventory);
    }

    @Nonnull
    public UUID addInventory(@Nonnull FluidInventoryLogic inventory) {
        Pair<UUID, FluidInventoryLogic> found = this.checkIfInventoryExistsAsUnallocated(inventory);
        if (inventory.isUpgradeInventory() && found != null) {
            this.unallocatedInventories.remove(found);
            this.inventories.put((UUID)found.getLeft(), (FluidInventoryLogic)found.getRight());
            return Objects.requireNonNull((UUID)found.getLeft());
        }
        UUID generatedUUID = Objects.requireNonNull(UUID.randomUUID());
        this.inventories.put(generatedUUID, inventory);
        return generatedUUID;
    }

    @Nullable
    private Pair<UUID, FluidInventoryLogic> checkIfInventoryExistsAsUnallocated(@Nonnull FluidInventoryLogic inventory) {
        if (this.unallocatedInventories.isEmpty()) {
            return null;
        }
        return this.unallocatedInventories.stream().filter(unallocated -> ((FluidInventoryLogic)unallocated.getRight()).getTier() == inventory.getTier()).findFirst().get();
    }

    @Nonnull
    public FluidInventoryLogic removeInventory(@Nonnull UUID id) {
        return Objects.requireNonNull(this.inventories.remove(id));
    }

    @Nonnull
    public FluidInventoryLogic getAllInventoryLogics() {
        return new FluidInventoryLogic(this.inventories.values().stream().map(inv -> inv.getInventory()).collect(Collectors.toList()));
    }

    @Nonnull
    public FluidInventoryLogic getInventoryLogic(@Nullable UUID id) {
        if (id == null) {
            return this.getAllInventoryLogics();
        }
        return Objects.requireNonNull(this.inventories.getOrDefault(id, this.getAllInventoryLogics()));
    }

    @Nonnull
    public Set<Map.Entry<UUID, FluidInventoryLogic>> getAllInventoryLogicsAsEntrySet() {
        return Objects.requireNonNull(this.inventories.entrySet());
    }

    @Nonnull
    public String getInventoryDisplayName(@Nullable UUID id) {
        if (id == null) {
            return "";
        }
        FluidInventoryLogic logic = this.inventories.get(id);
        if (logic == null) {
            return "";
        }
        String displayName = logic.getDisplayName();
        if (displayName == null) {
            return Objects.requireNonNull(id.toString());
        }
        return displayName;
    }

    public void setInventoryDisplayName(@Nullable UUID id, @Nullable String displayName) {
        if (id == null) {
            return;
        }
        FluidInventoryLogic logic = this.inventories.get(id);
        if (logic == null) {
            return;
        }
        logic.setDisplayName(displayName);
    }

    @Nonnull
    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList inventoriesNBT = new NBTTagList();
        this.inventories.forEach((uuid, inventory) -> {
            NBTTagCompound inventoryNBT = new NBTTagCompound();
            inventoryNBT.func_74782_a("inventory", (NBTBase)inventory.saveToNBT());
            inventoryNBT.func_74778_a("uuid", uuid.toString());
            inventoryNBT.func_74768_a("invSize", inventory.getInventory().getTanks());
            inventoryNBT.func_74772_a("tankCapacity", inventory.getInventory().getTankCapacity(0));
            inventoriesNBT.func_74742_a((NBTBase)inventoryNBT);
        });
        nbt.func_74782_a("inventories", (NBTBase)inventoriesNBT);
        return nbt;
    }

    public void loadFromNBT(@Nonnull NBTTagCompound nbt) {
        NBTTagList inventoriesNBT = nbt.func_150295_c("inventories", 10);
        if (inventoriesNBT == null) {
            return;
        }
        for (int i = 0; i < inventoriesNBT.func_74745_c(); ++i) {
            NBTTagCompound inventoryNBT = inventoriesNBT.func_150305_b(i);
            UUID uuid = UUID.fromString(inventoryNBT.func_74779_i("uuid"));
            FluidInventoryLogic inventory = new FluidInventoryLogic(inventoryNBT.func_74762_e("invSize"), inventoryNBT.func_74763_f("tankCapacity"));
            inventory.loadFromNBT(inventoryNBT.func_74775_l("inventory"));
            if (inventory.isUpgradeInventory()) {
                this.unallocatedInventories.add((Pair<UUID, FluidInventoryLogic>)Pair.of((Object)uuid, (Object)inventory));
                continue;
            }
            this.inventories.put(uuid, inventory);
        }
    }
}

