/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.management.ManagementFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.helpers.BuiltInResourcePack;
import org.embeddedt.archaicfix.helpers.SoundDeviceThread;
import org.embeddedt.archaicfix.proxy.CommonProxy;

public class ClientProxy
extends CommonProxy {
    SoundDeviceThread soundThread = null;
    public static volatile boolean soundSystemReloadLock = false;
    float lastIntegratedTickTime;
    private float gameStartTime = -1.0f;

    @Override
    public void preinit() {
        super.preinit();
        Minecraft.field_71444_a = new byte[0];
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (ArchaicConfig.modernizeTextures) {
            BuiltInResourcePack.register("vanilla_overrides");
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.phase == TickEvent.Phase.END) {
            IntegratedServer srv = Minecraft.func_71410_x().func_71401_C();
            if (srv != null) {
                long currentTickTime = srv.field_71311_j[srv.func_71259_af() % 100];
                this.lastIntegratedTickTime = this.lastIntegratedTickTime * 0.8f + (float)currentTickTime / 1000000.0f * 0.2f;
            } else {
                this.lastIntegratedTickTime = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!event.isCanceled() && event.gui instanceof GuiMainMenu && this.gameStartTime == -1.0f) {
            this.gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            ArchaicLogger.LOGGER.info("The game loaded in " + this.gameStartTime + " seconds.");
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        soundSystemReloadLock = false;
        if (this.soundThread == null) {
            ArchaicLogger.LOGGER.info("Starting sound device thread");
            this.soundThread = new SoundDeviceThread();
            this.soundThread.start();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (Float.isNaN(event.red)) {
            event.red = 0.0f;
        }
        if (Float.isNaN(event.green)) {
            event.green = 0.0f;
        }
        if (Float.isNaN(event.blue)) {
            event.blue = 0.0f;
        }
    }
}

