/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.isolator;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.PackageGeneticBase;
import binnie.genetics.machine.isolator.EthanolTankValidator;
import binnie.genetics.machine.isolator.Isolator;
import binnie.genetics.machine.isolator.IsolatorComponentFX;
import binnie.genetics.machine.isolator.IsolatorComponentLogic;

public class IsolatorPackage
extends PackageGeneticBase
implements IMachineInformation {
    public IsolatorPackage() {
        super("isolator", GeneticsTexture.Isolator, 0xFF6F0F, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Isolator);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot enzymeSlot = inventory.addSlot(0, "enzyme");
        enzymeSlot.setValidator(new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.IconEnzyme));
        enzymeSlot.forbidExtraction();
        InventorySlot vialSlot = inventory.addSlot(1, "sequencervial");
        vialSlot.setValidator(new SlotValidator.Item(GeneticsItems.EmptySequencer.get(1), ModuleMachine.IconSequencer));
        vialSlot.forbidExtraction();
        inventory.addSlotArray(Isolator.SLOT_RESERVE, "input");
        for (InventorySlot slot : inventory.getSlots(Isolator.SLOT_RESERVE)) {
            slot.setValidator(new SlotValidator.Individual());
            slot.forbidExtraction();
        }
        InventorySlot targetSlot = inventory.addSlot(5, "process");
        targetSlot.setValidator(new SlotValidator.Individual());
        targetSlot.setReadOnly();
        targetSlot.forbidInteraction();
        InventorySlot resultSlot = inventory.addSlot(6, "output");
        resultSlot.setReadOnly();
        resultSlot.forbidInteraction();
        inventory.addSlotArray(Isolator.SLOT_FINISHED, "output");
        for (InventorySlot slot : inventory.getSlots(Isolator.SLOT_FINISHED)) {
            slot.setReadOnly();
            slot.forbidInsertion();
        }
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        tanks.addTank(0, "input", 1000);
        tanks.getTankSlot(0).setValidator(new EthanolTankValidator());
        ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
        chargedSlots.addCharge(0);
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Isolator.SLOT_RESERVE, 5, 1);
        transfer.addStorage(6, Isolator.SLOT_FINISHED);
        new ComponentPowerReceptor(machine, 20000);
        new IsolatorComponentLogic(machine);
        new IsolatorComponentFX(machine);
    }
}

