/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenCedar
extends WorldGenTree {
    public WorldGenCedar(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        float leafSpawn = this.height + 3;
        float bottom = this.randBetween(2, 3);
        float width = (float)this.height * this.randBetween(0.7f, 0.75f);
        if (width > 7.0f) {
            width = 7.0f;
        }
        float coneHeight = leafSpawn - bottom;
        while (leafSpawn > bottom) {
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), this.girth, 1, this.leaf, false);
        }
        for (leafSpawn = (float)(this.height + 3); leafSpawn > bottom; leafSpawn += (float)(1 + this.rand.nextInt(2))) {
            float cone = 1.0f - (leafSpawn - bottom) / coneHeight;
            cone *= 2.0f - cone;
            float radius = (0.7f + this.rand.nextFloat() * 0.3f) * width;
            if ((radius *= cone) < 2.0f) {
                radius = 2.0f;
            }
            float xOffset = (-width + this.rand.nextFloat() * 2.0f * width) / 2.0f;
            if ((xOffset *= cone) > radius / 2.0f) {
                xOffset = radius / 2.0f;
            }
            float yOffset = (-width + this.rand.nextFloat() * 2.0f * width) / 2.0f;
            if ((yOffset *= cone) > radius / 2.0f) {
                yOffset = radius / 2.0f;
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(xOffset, f, yOffset), 0.7f * radius, 1, this.leaf, false);
            float f2 = leafSpawn;
            leafSpawn = f2 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(xOffset, f2, yOffset), radius, 1, this.leaf, false);
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(xOffset, f3, yOffset), 0.5f * radius, 1, this.leaf, false);
        }
        this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.7f * width, 1, this.leaf, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 2);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

