/*
 * Decompiled with CFR 0.152.
 */
package baubles.api.expanded;

import baubles.api.BaubleType;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import java.util.ArrayList;
import java.util.Arrays;

public class BaubleExpandedSlots {
    public static final int slotLimit = 20;
    public static final String invalidType = "";
    public static final String unknownType = "unknown";
    public static final String ringType = "ring";
    public static final String amuletType = "amulet";
    public static final String beltType = "belt";
    public static final String universalType = "universal";
    public static final String headType = "head";
    public static final String bodyType = "body";
    public static final String charmType = "charm";
    public static final String capeType = "cape";
    public static final String shieldType = "shield";
    public static final String quiverType = "quiver";
    public static final String gauntletType = "gauntlet";
    public static final String earringType = "earring";
    public static final String wingsType = "wings";
    private static int newSlotsRemaining;
    private static final String[] assignedSlots;
    private static final ArrayList<String> registeredTypes;

    public static boolean tryRegisterType(String type) {
        if (type != null && type.length() > 0) {
            if (BaubleExpandedSlots.isTypeRegistered(type)) {
                return true;
            }
            if (Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION) {
                registeredTypes.add(type);
                return true;
            }
        }
        return false;
    }

    public static boolean tryAssignSlotsUpToMinimum(String type, int minimumOfType) {
        if (minimumOfType >= 1 && BaubleExpandedSlots.isTypeRegistered(type) && !type.equals(unknownType) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION) {
            int total = 0;
            for (int slotToCheck = 0; slotToCheck < 20; ++slotToCheck) {
                if (!assignedSlots[slotToCheck].equals(type)) continue;
                ++total;
            }
            if (total < minimumOfType) {
                total = minimumOfType - total;
                for (int i = 0; i < total; ++i) {
                    if (newSlotsRemaining >= 1) {
                        BaubleExpandedSlots.assignedSlots[20 - BaubleExpandedSlots.newSlotsRemaining] = type;
                        --newSlotsRemaining;
                        continue;
                    }
                    return false;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean tryUnassignSlotsDownToMaximum(String type, int maximumOfType) {
        if (maximumOfType < 0) {
            maximumOfType = 0;
        }
        if (BaubleExpandedSlots.isTypeRegistered(type) && !type.equals(unknownType) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION) {
            int total = 0;
            for (int slotToCheck = 0; slotToCheck < 20; ++slotToCheck) {
                if (!assignedSlots[slotToCheck].equals(type)) continue;
                ++total;
            }
            if (total > maximumOfType) {
                total -= maximumOfType;
                block1: for (int i = 0; i < total; ++i) {
                    for (int slotToCheck = BaubleExpandedSlots.slotsCurrentlyUsed(); slotToCheck > 0; --slotToCheck) {
                        if (!assignedSlots[slotToCheck].equals(type)) continue;
                        for (int slotToMove = slotToCheck + 1; slotToMove < 20; ++slotToMove) {
                            BaubleExpandedSlots.assignedSlots[slotToMove - 1] = assignedSlots[slotToMove];
                        }
                        BaubleExpandedSlots.assignedSlots[19] = unknownType;
                        ++newSlotsRemaining;
                        continue block1;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean tryAssignSlotOfType(String type) {
        if (newSlotsRemaining >= 1 && BaubleExpandedSlots.isTypeRegistered(type) && !type.equals(unknownType) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION) {
            BaubleExpandedSlots.assignedSlots[20 - BaubleExpandedSlots.newSlotsRemaining] = type;
            --newSlotsRemaining;
            return true;
        }
        return false;
    }

    public static boolean tryUnassignSlotOfType(String type) {
        if (newSlotsRemaining < 20 && type != null && !type.equals(unknownType) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION) {
            for (int slotToCheck = BaubleExpandedSlots.slotsCurrentlyUsed(); slotToCheck > 0; --slotToCheck) {
                if (!assignedSlots[slotToCheck].equals(type)) continue;
                for (int slotToMove = slotToCheck + 1; slotToMove < 20; ++slotToMove) {
                    BaubleExpandedSlots.assignedSlots[slotToMove - 1] = assignedSlots[slotToMove];
                }
                BaubleExpandedSlots.assignedSlots[19] = unknownType;
                ++newSlotsRemaining;
                return true;
            }
        }
        return false;
    }

    public static int totalCurrentlyAssignedSlotsOfType(String type) {
        int total = 0;
        if (BaubleExpandedSlots.isTypeRegistered(type)) {
            for (int slotToCheck = 0; slotToCheck < 20; ++slotToCheck) {
                if (!assignedSlots[slotToCheck].equals(type)) continue;
                ++total;
            }
        }
        return total;
    }

    public static int[] getIndexesOfAssignedSlotsOfType(String type) {
        int[] slotIndexes = new int[]{};
        if (BaubleExpandedSlots.isTypeRegistered(type)) {
            for (int slotToCheck = 0; slotToCheck < 20; ++slotToCheck) {
                if (!assignedSlots[slotToCheck].equals(type)) continue;
                slotIndexes = Arrays.copyOf(slotIndexes, slotIndexes.length + 1);
                slotIndexes[slotIndexes.length - 1] = slotToCheck;
            }
        }
        return slotIndexes;
    }

    public static boolean isTypeRegistered(String type) {
        return registeredTypes.contains(type);
    }

    public static int slotsCurrentlyUsed() {
        return 20 - newSlotsRemaining;
    }

    public static int slotsCurrentlyUnused() {
        return newSlotsRemaining;
    }

    public static String getSlotType(int slot) {
        if (slot >= 0 & slot < 20) {
            return assignedSlots[slot];
        }
        return unknownType;
    }

    public static int getIndexOfTypeInRegisteredTypes(String type) {
        return registeredTypes.indexOf(type);
    }

    public static ArrayList<String> getCurrentlyRegisteredTypes() {
        return registeredTypes;
    }

    public static String[] getCurrentSlotAssignments() {
        return assignedSlots;
    }

    public static String getTypeFromBaubleType(BaubleType type) {
        String string;
        if (type == null) {
            return invalidType;
        }
        switch (type) {
            case RING: {
                string = ringType;
                break;
            }
            case AMULET: {
                string = amuletType;
                break;
            }
            case BELT: {
                string = beltType;
                break;
            }
            case UNIVERSAL: {
                string = universalType;
                break;
            }
            default: {
                string = unknownType;
            }
        }
        return string;
    }

    public static void overrideSlots(String[] overrideSlots) {
        if (Loader.instance().getLoaderState() == LoaderState.INITIALIZATION) {
            newSlotsRemaining = 0;
            for (int slot = 0; slot < 20; ++slot) {
                if (slot < overrideSlots.length && BaubleExpandedSlots.isTypeRegistered(overrideSlots[slot]) && !overrideSlots[slot].equals(unknownType)) {
                    BaubleExpandedSlots.assignedSlots[slot] = overrideSlots[slot];
                    continue;
                }
                BaubleExpandedSlots.assignedSlots[slot] = unknownType;
                ++newSlotsRemaining;
            }
        }
    }

    static {
        assignedSlots = new String[20];
        registeredTypes = new ArrayList();
        registeredTypes.add(unknownType);
        registeredTypes.add(ringType);
        registeredTypes.add(amuletType);
        registeredTypes.add(beltType);
        registeredTypes.add(universalType);
        registeredTypes.add(headType);
        registeredTypes.add(bodyType);
        registeredTypes.add(charmType);
        registeredTypes.add(capeType);
        registeredTypes.add(shieldType);
        registeredTypes.add(quiverType);
        registeredTypes.add(gauntletType);
        registeredTypes.add(earringType);
        registeredTypes.add(wingsType);
        BaubleExpandedSlots.assignedSlots[0] = amuletType;
        BaubleExpandedSlots.assignedSlots[1] = ringType;
        BaubleExpandedSlots.assignedSlots[2] = ringType;
        BaubleExpandedSlots.assignedSlots[3] = beltType;
        newSlotsRemaining = 16;
        for (int slot = 4; slot < 20; ++slot) {
            BaubleExpandedSlots.assignedSlots[slot] = unknownType;
        }
    }
}

