/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.attacks.special;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetPositionSetEvent;
import chylex.hee.entity.boss.dragon.attacks.special.event.TargetSetEvent;
import chylex.hee.entity.boss.dragon.managers.DragonShotManager;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public class DragonAttackFireburst
extends DragonSpecialAttackBase {
    private Entity target;
    private byte shootTimer;
    private byte shotAmount;
    private byte runCounter;
    private byte waitTimer;
    private boolean ended;

    public DragonAttackFireburst(EntityBossDragon dragon, int attackId, int weight) {
        super(dragon, attackId, weight);
    }

    @Override
    public void init() {
        super.init();
        this.target = null;
        this.waitTimer = 0;
        this.runCounter = 0;
        this.shotAmount = 0;
        this.shootTimer = 0;
        this.ended = false;
        this.dragon.target = null;
    }

    @Override
    public void update() {
        super.update();
        if (this.target == null || this.target.field_70128_L) {
            if (this.waitTimer <= 0 || (this.waitTimer = (byte)(this.waitTimer - 1)) <= 0) {
                this.target = this.dragon.attacks.getRandomPlayer();
                if (this.target == null) {
                    this.ended = true;
                } else if (MathUtil.distance(this.dragon.targetX - this.dragon.field_70165_t, this.dragon.targetZ - this.dragon.field_70161_v) < 60.0) {
                    this.target = null;
                    this.waitTimer = (byte)60;
                    double dist = 10.0;
                    Vec3 vec = Vec3.func_72443_a((double)this.dragon.field_70159_w, (double)0.0, (double)this.dragon.field_70179_y).func_72432_b();
                    for (int attempt = 0; attempt < 10; ++attempt) {
                        this.dragon.targetX = this.dragon.field_70165_t + vec.field_72450_a * dist + (this.rand.nextDouble() - 0.5) * 4.0;
                        this.dragon.targetZ = this.dragon.field_70161_v + vec.field_72449_c * dist + (this.rand.nextDouble() - 0.5) * 4.0;
                        if (!(MathUtil.distance(this.dragon.targetX - this.dragon.field_70165_t, this.dragon.targetZ - this.dragon.field_70161_v) > 65.0)) {
                            dist += 5.0;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.waitTimer = (byte)8;
                }
            }
        } else {
            this.dragon.targetX = this.target.field_70165_t;
            this.dragon.targetY = this.target.field_70163_u + 10.0;
            this.dragon.targetZ = this.target.field_70161_v;
            double dist = MathUtil.distance(this.dragon.targetX - this.dragon.field_70165_t, this.dragon.targetZ - this.dragon.field_70161_v);
            boolean stopShooting = false;
            if (dist < 90.0 && (this.waitTimer <= 0 || (this.waitTimer = (byte)(this.waitTimer - 1)) <= 0)) {
                if (dist < 30.0) {
                    stopShooting = true;
                } else {
                    this.shootTimer = (byte)(this.shootTimer + 1);
                    if (this.shootTimer > 13 - this.getDifficulty() * 2 - (ModCommonProxy.opMobs ? 3 : 0)) {
                        this.dragon.shots.createNew(DragonShotManager.ShotType.FIREBALL).setTarget(this.target).setRandom().shoot();
                        this.shootTimer = 0;
                        this.shotAmount = (byte)(this.shotAmount + 1);
                        if (this.shotAmount > 7 + this.rand.nextInt(6) + this.getDifficulty()) {
                            stopShooting = true;
                        }
                    }
                }
            }
            if (stopShooting) {
                this.waitTimer = (byte)110;
                this.shotAmount = 0;
                this.shootTimer = 0;
                this.target = null;
                this.runCounter = (byte)(this.runCounter + 1);
                if (this.runCounter > 3 + Math.min(4, this.dragon.attacks.getViablePlayers().size())) {
                    this.ended = true;
                }
            }
        }
    }

    @Override
    public boolean hasEnded() {
        return this.ended;
    }

    @Override
    public void onTargetSetEvent(TargetSetEvent event) {
        event.newTarget = null;
    }

    @Override
    public void onTargetPositionSetEvent(TargetPositionSetEvent event) {
        if (this.target != null) {
            event.cancel();
        }
    }
}

