/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.glease.tc4tweak.ConfigurationHandler;
import net.glease.tc4tweak.TC4Tweak;
import net.glease.tc4tweak.asm.PacketAspectCombinationToServerVisitor;
import net.glease.tc4tweak.asm.PacketPlayerCompleteToServerVisitor;
import net.glease.tc4tweak.modules.blockJar.EntityCollisionBox;
import net.glease.tc4tweak.modules.findCrucibleRecipe.FindCrucibleRecipe;
import net.glease.tc4tweak.modules.findRecipes.FindRecipes;
import net.glease.tc4tweak.modules.generateItemHash.GenerateItemHash;
import net.glease.tc4tweak.modules.getResearch.GetResearch;
import net.glease.tc4tweak.modules.objectTag.GetObjectTags;
import net.glease.tc4tweak.network.NetworkedConfiguration;
import net.glease.tc4tweak.network.TileHoleSyncPacket;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import thaumcraft.api.BlockCoordinates;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.container.ContainerDummy;
import thaumcraft.common.entities.ai.fluid.AILiquidGather;
import thaumcraft.common.items.baubles.ItemAmuletVis;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.world.dim.CellLoc;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.TileArcaneWorkbench;
import thaumcraft.common.tiles.TileResearchTable;

public class ASMCallhookServer {
    private static final Marker securityMarker = MarkerManager.getMarker((String)"SuspiciousPackets");
    private static Method getRenderDistanceChunks;

    private ASMCallhookServer() {
    }

    public static boolean isValidFocusItemStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemFocusBasic;
    }

    public static ResearchItem getResearch(String key) {
        return GetResearch.getResearch(key);
    }

    public static ItemStack findMatchingArcaneRecipe(IInventory awb, EntityPlayer player) {
        IArcaneRecipe recipe = FindRecipes.findArcaneRecipe(awb, player);
        return recipe == null ? null : recipe.getCraftingResult(awb);
    }

    public static AspectList findMatchingArcaneRecipeAspects(IInventory awb, EntityPlayer player) {
        IArcaneRecipe recipe = FindRecipes.findArcaneRecipe(awb, player);
        return recipe == null ? new AspectList() : (recipe.getAspects() == null ? recipe.getAspects(awb) : recipe.getAspects());
    }

    public static int generateItemHash(Item item, int meta) {
        return GenerateItemHash.generateItemHash(item, meta);
    }

    public static AspectList getObjectTags(ItemStack itemstack) {
        return GetObjectTags.getObjectTags(itemstack);
    }

    public static void onArcaneWorkbenchChanged(TileArcaneWorkbench tileEntity, InventoryPlayer ip) {
        ItemWandCasting wand;
        if (ConfigurationHandler.INSTANCE.isCheckWorkbenchRecipes() && (!tileEntity.func_145831_w().field_72995_K || NetworkedConfiguration.isCheckWorkbenchRecipes())) {
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerDummy(), 3, 3);
            for (int a = 0; a < 9; ++a) {
                ic.func_70299_a(a, tileEntity.func_70301_a(a));
            }
            tileEntity.setInventorySlotContentsSoftly(9, CraftingManager.func_77594_a().func_82787_a(ic, tileEntity.func_145831_w()));
        } else {
            tileEntity.setInventorySlotContentsSoftly(9, null);
        }
        if (tileEntity.func_70301_a(9) == null && tileEntity.func_70301_a(10) != null && tileEntity.func_70301_a(10).func_77973_b() instanceof ItemWandCasting && (wand = (ItemWandCasting)tileEntity.func_70301_a(10).func_77973_b()).consumeAllVisCrafting(tileEntity.func_70301_a(10), ip.field_70458_d, ThaumcraftCraftingManager.findMatchingArcaneRecipeAspects((IInventory)tileEntity, (EntityPlayer)ip.field_70458_d), false)) {
            tileEntity.setInventorySlotContentsSoftly(9, ThaumcraftCraftingManager.findMatchingArcaneRecipe((IInventory)tileEntity, (EntityPlayer)ip.field_70458_d));
        }
    }

    public static int hash(CellLoc thiz) {
        return 1664525 * thiz.x + 1013904223 ^ 1664525 * (thiz.z ^ 0xDEADBEEF) + 1013904223;
    }

    public static int hash(BlockCoordinates thiz) {
        return thiz.y * 31 + thiz.x * 91 + thiz.z * 29303;
    }

    public static int hash(WorldCoordinates thiz) {
        return thiz.y * 31 + thiz.x * 91 + thiz.z * 29303 + thiz.dim * 39916801;
    }

    public static void postThaumcraftApiClinit() {
        ThaumcraftApi.objectTags = GetObjectTags.newReplacementObjectTagsMap();
    }

    public static NBTTagCompound writeMazeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry entry : MazeHandler.labyrinth.entrySet()) {
            short v;
            if (entry.getValue() == null || (v = ((Short)entry.getValue()).shortValue()) <= 0) continue;
            CellLoc loc = (CellLoc)entry.getKey();
            NBTTagCompound cell = new NBTTagCompound();
            cell.func_74768_a("x", loc.x);
            cell.func_74768_a("z", loc.z);
            cell.func_74777_a("cell", v);
            tagList.func_74742_a((NBTBase)cell);
        }
        nbt.func_74782_a("cells", (NBTBase)tagList);
        return nbt;
    }

    public static CrucibleRecipe getCrucibleRecipeFromHash(int hash) {
        return FindCrucibleRecipe.getCrucibleRecipeFromHash(hash);
    }

    public static Entity onlyIfAlive(Entity sus) {
        return sus != null && sus.func_70089_S() ? sus : null;
    }

    public static boolean canNodeBeSeen(TileVisNode source, TileVisNode target) {
        World world = source.func_145831_w();
        Vec3 v1 = Vec3.func_72443_a((double)((double)source.field_145851_c + 0.5), (double)((double)source.field_145848_d + 0.5), (double)((double)source.field_145849_e + 0.5));
        Vec3 v2 = Vec3.func_72443_a((double)((double)target.field_145851_c + 0.5), (double)((double)target.field_145848_d + 0.5), (double)((double)target.field_145849_e + 0.5));
        if (Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c)) {
            return false;
        }
        if (Double.isNaN(v2.field_72450_a) || Double.isNaN(v2.field_72448_b) || Double.isNaN(v2.field_72449_c)) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)v2.field_72450_a);
        int j = MathHelper.func_76128_c((double)v2.field_72448_b);
        int k = MathHelper.func_76128_c((double)v2.field_72449_c);
        int l = MathHelper.func_76128_c((double)v1.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)v1.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)v1.field_72449_c);
        int k1 = source.getRange() * 5;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            int l1;
            int b0;
            if (Double.isNaN(v1.field_72450_a) || Double.isNaN(v1.field_72448_b) || Double.isNaN(v1.field_72449_c)) {
                return false;
            }
            if (l == i && i1 == j && j1 == k) continue;
            boolean flag6 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag6 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = v2.field_72450_a - v1.field_72450_a;
            double d7 = v2.field_72448_b - v1.field_72448_b;
            double d8 = v2.field_72449_c - v1.field_72449_c;
            if (flag6) {
                d3 = (d0 - v1.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - v1.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - v1.field_72449_c) / d8;
            }
            if (d3 < d4 && d3 < d5) {
                b0 = i > l ? 4 : 5;
                v1.field_72450_a = d0;
                v1.field_72448_b += d7 * d3;
                v1.field_72449_c += d8 * d3;
            } else if (d4 < d5) {
                b0 = j > i1 ? 0 : 1;
                v1.field_72450_a += d6 * d4;
                v1.field_72448_b = d1;
                v1.field_72449_c += d8 * d4;
            } else {
                b0 = k > j1 ? 2 : 3;
                v1.field_72450_a += d6 * d5;
                v1.field_72448_b += d7 * d5;
                v1.field_72449_c = d2;
            }
            l = MathHelper.func_76128_c((double)v1.field_72450_a);
            if (b0 == 5) {
                --l;
            }
            i1 = MathHelper.func_76128_c((double)v1.field_72448_b);
            if (b0 == 1) {
                --i1;
            }
            j1 = MathHelper.func_76128_c((double)v1.field_72449_c);
            if (b0 == 3) {
                --j1;
            }
            if (l == target.field_145851_c && i1 == target.field_145848_d && j1 == target.field_145849_e) {
                return true;
            }
            Block block1 = world.func_147439_a(l, i1, j1);
            if (!block1.func_149678_a(l1 = world.func_72805_g(l, i1, j1), false) || block1.func_149668_a(world, l, i1, j1) == null || (movingobjectposition1 = block1.func_149731_a(world, l, i1, j1, v1, v2)) == null || movingobjectposition1.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) continue;
            return false;
        }
        return false;
    }

    public static float getBlockJarEntityCollisionBoxParameter(int index) {
        return EntityCollisionBox.getBlockJarEntityCollisionBoxParameter(index);
    }

    public static boolean addToPlayerInventoryBiased(InventoryPlayer inv, ItemStack s) {
        if (s == null || s.field_77994_a == 0 || s.func_77973_b() == null) {
            return false;
        }
        for (ItemStack stack : inv.field_70462_a) {
            if (stack == null || !stack.func_77985_e() || stack.func_77973_b() != s.func_77973_b() || stack.field_77994_a >= Math.min(stack.func_77976_d(), inv.func_70297_j_()) || stack.func_77981_g() && stack.func_77960_j() != s.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)s)) continue;
            int toAdd = Math.min(s.field_77994_a, Math.min(stack.func_77976_d(), inv.func_70297_j_()) - stack.field_77994_a);
            s.field_77994_a -= toAdd;
            stack.field_77994_a += toAdd;
            stack.field_77992_b = 5;
            if (s.field_77994_a != 0) continue;
            return true;
        }
        if (inv.field_70461_c >= 0 && inv.field_70461_c < InventoryPlayer.func_70451_h() && inv.func_70448_g() == null) {
            inv.func_70299_a(inv.field_70461_c, s);
            return true;
        }
        return inv.func_70441_a(s);
    }

    public static Packet createTileHoleSyncPacket(S35PacketUpdateTileEntity origin) {
        try {
            return TC4Tweak.INSTANCE.CHANNEL.getPacketFrom((IMessage)new TileHoleSyncPacket(origin));
        }
        catch (Exception ex) {
            return origin;
        }
    }

    public static boolean sanityPlayerComplete(PacketPlayerCompleteToServerVisitor.PacketPlayerCompleteToServerAccess packet, MessageContext ctx) {
        if (packet.type() != 0) {
            return true;
        }
        EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
        ResearchItem research = packet.research();
        if (research == null) {
            return false;
        }
        boolean secondary = ASMCallhookServer.isSecondaryResearch(research);
        if (secondary && ASMCallhookServer.hasAspect(playerEntity, research)) {
            return true;
        }
        TC4Tweak.log.info(securityMarker, "Player {} sent suspicious packet to complete research {}@{}", new Object[]{playerEntity.func_146103_bH(), research.key, research.category});
        return false;
    }

    private static boolean hasAspect(EntityPlayerMP playerEntity, ResearchItem research) {
        return research.tags.aspects.entrySet().stream().noneMatch(e -> e.getValue() != null && !ASMCallhookServer.hasAspect(playerEntity, (Aspect)e.getKey(), (Integer)e.getValue()));
    }

    private static boolean isSecondaryResearch(ResearchItem research) {
        return research.tags != null && research.tags.size() > 0 && (Config.researchDifficulty == -1 || Config.researchDifficulty == 0 && research.isSecondary());
    }

    public static boolean sanityCheckAspectCombination(PacketAspectCombinationToServerVisitor.PacketAspectCombinationToServerAccess packet, MessageContext ctx) {
        if (ASMCallhookServer.sanityCheckAspectCombination0(packet)) {
            return true;
        }
        EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
        TC4Tweak.log.info(securityMarker, "Player {} sent suspicious packet to get more aspects", new Object[]{playerEntity.func_146103_bH()});
        return false;
    }

    private static boolean sanityCheckAspectCombination0(PacketAspectCombinationToServerVisitor.PacketAspectCombinationToServerAccess packet) {
        TileResearchTable table = packet.table();
        if (table == null) {
            return false;
        }
        EntityPlayerMP player = packet.player();
        if (player == null) {
            return false;
        }
        return ASMCallhookServer.hasAspect(table, player, packet.lhs()) && ASMCallhookServer.hasAspect(table, player, packet.rhs());
    }

    private static boolean hasAspect(TileResearchTable table, EntityPlayerMP player, Aspect aspect) {
        return ASMCallhookServer.hasAspect(player, aspect, 0) || table.bonusAspects.getAmount(aspect) > 0;
    }

    private static boolean hasAspect(EntityPlayerMP player, Aspect aspect, int threshold) {
        return Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(player.func_70005_c_(), aspect) > threshold;
    }

    public static ItemStack copyIfNotNull(ItemStack stack) {
        if (!ConfigurationHandler.INSTANCE.isMoreRandomizedLoot()) {
            return stack;
        }
        return stack == null ? null : stack.func_77946_l();
    }

    public static ItemStack mutateGeneratedLoot(ItemStack stack) {
        if (!ConfigurationHandler.INSTANCE.isMoreRandomizedLoot()) {
            return stack.func_77946_l();
        }
        if (stack.func_77973_b() == ConfigItems.itemAmuletVis) {
            ItemAmuletVis ai = (ItemAmuletVis)stack.func_77973_b();
            for (Aspect a : Aspect.getPrimalAspects()) {
                ai.storeVis(stack, a, ThreadLocalRandom.current().nextInt(5) * 100);
            }
        }
        return stack;
    }

    public static boolean infusionItemMatches(ItemStack playerInput, ItemStack recipeSpec, boolean fuzzy) {
        if (playerInput == null) {
            return recipeSpec == null;
        }
        if (recipeSpec == null) {
            return false;
        }
        if (!ThaumcraftApiHelper.areItemStackTagsEqualForCrafting((ItemStack)playerInput, (ItemStack)recipeSpec)) {
            return false;
        }
        if (fuzzy && ConfigurationHandler.INSTANCE.getInfusionOreDictMode().test(playerInput, recipeSpec)) {
            return true;
        }
        return playerInput.func_77973_b() == recipeSpec.func_77973_b() && (playerInput.func_77960_j() == recipeSpec.func_77960_j() || recipeSpec.func_77960_j() == Short.MAX_VALUE) && playerInput.field_77994_a <= playerInput.func_77976_d();
    }

    public static double getViewDistance(World w) {
        int chunks;
        try {
            if (getRenderDistanceChunks == null) {
                getRenderDistanceChunks = ReflectionHelper.findMethod(World.class, null, (String[])new String[]{"getRenderDistanceChunks", "func_152379_p", "p"}, (Class[])new Class[0]);
            }
            chunks = (Integer)getRenderDistanceChunks.invoke((Object)w, new Object[0]);
        }
        catch (ReflectionHelper.UnableToFindMethodException | ReflectiveOperationException ex) {
            TC4Tweak.log.error("error calling World#getRenderDistanceChunks", ex);
            chunks = 12;
        }
        return (double)chunks * 16.0;
    }

    public static void getConnectedFluidBlocks(AILiquidGather thiz, World world, int x, int y, int z, Fluid fluid, ArrayList<Object> sources, float pumpDist, MethodHandle ctor) throws Throwable {
        if (fluid == null) {
            return;
        }
        HashSet<ChunkCoordinates> seen = new HashSet<ChunkCoordinates>();
        ArrayDeque<ChunkCoordinates> toVisit = new ArrayDeque<ChunkCoordinates>();
        ChunkCoordinates origin = new ChunkCoordinates(x, y, z);
        toVisit.add(origin);
        while (!toVisit.isEmpty()) {
            Fluid f;
            ChunkCoordinates v = (ChunkCoordinates)toVisit.poll();
            if (seen.contains(v)) continue;
            seen.add(v);
            float dist = v.func_71569_e(x, y, z);
            if (dist > pumpDist) continue;
            Block block = world.func_147439_a(v.field_71574_a, v.field_71572_b, v.field_71573_c);
            if (block == Blocks.field_150356_k) {
                block = Blocks.field_150353_l;
            } else if (block == Blocks.field_150358_i) {
                block = Blocks.field_150355_j;
            }
            if ((f = FluidRegistry.lookupFluidForBlock((Block)block)) != fluid) continue;
            if (ASMCallhookServer.validFluidBlock(world, fluid, v.field_71574_a, v.field_71572_b, v.field_71573_c)) {
                sources.add(ctor.invokeExact(thiz, v, dist));
                if (sources.size() >= ConfigurationHandler.INSTANCE.getDecantMaxBlocks()) {
                    return;
                }
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                toVisit.add(new ChunkCoordinates(v.field_71574_a + direction.offsetX, v.field_71572_b + direction.offsetY, v.field_71573_c + direction.offsetZ));
            }
        }
    }

    private static boolean validFluidBlock(World world, Fluid fluid, int i, int j, int k) {
        FluidStack fs;
        Block bi = world.func_147439_a(i, j, k);
        if (FluidRegistry.lookupFluidForBlock((Block)bi) != fluid) {
            return false;
        }
        if (bi instanceof BlockFluidBase && ((IFluidBlock)bi).canDrain(world, i, j, k) && (fs = ((IFluidBlock)bi).drain(world, i, j, k, false)) != null) {
            return true;
        }
        return (FluidRegistry.lookupFluidForBlock((Block)bi) == FluidRegistry.WATER && fluid == FluidRegistry.WATER || FluidRegistry.lookupFluidForBlock((Block)bi) == FluidRegistry.LAVA && fluid == FluidRegistry.LAVA) && world.func_72805_g(i, j, k) == 0;
    }

    public static Class<? extends Entity> getEarthShockEntityFilter() {
        if (ConfigurationHandler.INSTANCE.getEarthShockHarmMode() == ConfigurationHandler.EarthShockHarmMode.OnlyLiving) {
            return EntityLivingBase.class;
        }
        return Entity.class;
    }

    public static boolean canEarthShockHurt(Entity entity) {
        switch (ConfigurationHandler.INSTANCE.getEarthShockHarmMode()) {
            case OnlyLiving: {
                return entity instanceof EntityLivingBase;
            }
            case ExceptItemXp: {
                return !(entity instanceof EntityItem) && !(entity instanceof EntityXPOrb);
            }
        }
        return true;
    }
}

