/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.Controlling;
import com.blamejared.controlling.client.gui.GuiNewControls;
import com.blamejared.controlling.client.gui.SearchType;
import committee.nova.mkb.api.IKeyBinding;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiKeyBindingList;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class GuiNewKeyBindingList
extends GuiKeyBindingList {
    private static final int YELLOW_HIGHLIGHT_COLOR = -2108409;
    private static final int DARK_TEXT_HIGHLIGHT_COLOR = 0x404040;
    private final GuiNewControls controlsScreen;
    private final Minecraft mc;
    private final List<GuiListExtended.IGuiListEntry> displayedEntries = new ArrayList<GuiListExtended.IGuiListEntry>();
    private final List<GuiListExtended.IGuiListEntry> allEntries = new ArrayList<GuiListExtended.IGuiListEntry>();
    private int maxListLabelWidth;

    public GuiNewKeyBindingList(GuiNewControls controls, Minecraft mcIn) {
        super((GuiControls)controls, mcIn);
        this.field_148155_a = controls.field_146294_l + 45;
        this.field_148158_l = controls.field_146295_m;
        this.field_148153_b = 63;
        this.field_148154_c = controls.field_146295_m - 80;
        this.field_148151_d = controls.field_146294_l + 45;
        this.controlsScreen = controls;
        this.mc = mcIn;
        Object[] keyBindings = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(keyBindings);
        String prevCategory = null;
        CategoryEntry prevCategoryEntry = null;
        for (Object keybinding : keyBindings) {
            String category = keybinding.func_151466_e();
            if (category.endsWith(".hidden")) continue;
            if (!category.equals(prevCategory)) {
                prevCategory = category;
                prevCategoryEntry = new CategoryEntry(category);
                this.allEntries.add(prevCategoryEntry);
            }
            this.maxListLabelWidth = Math.max(this.maxListLabelWidth, mcIn.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0])));
            this.allEntries.add(new KeyEntry((KeyBinding)keybinding, prevCategoryEntry));
        }
        this.displayedEntries.addAll(this.allEntries);
    }

    protected int func_148127_b() {
        return this.displayedEntries.size();
    }

    public GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.displayedEntries.get(index);
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 15 + 20;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    public List<GuiListExtended.IGuiListEntry> getAllEntries() {
        return this.allEntries;
    }

    public void setDisplayedEntries(List<GuiListExtended.IGuiListEntry> displayedEntries) {
        this.displayedEntries.clear();
        this.displayedEntries.addAll(displayedEntries);
    }

    private void drawHighlightedString(String text, int x, int y, boolean highlight) {
        int index = text.toLowerCase().indexOf(this.controlsScreen.getSearchString().toLowerCase());
        if (highlight && index > -1) {
            int indexEndHighlight = index + this.controlsScreen.getSearchString().length();
            String textStart = text.substring(0, index);
            String textMiddle = text.substring(index, indexEndHighlight);
            String textEnd = text.substring(indexEndHighlight);
            int rectLeft = x + this.mc.field_71466_p.func_78256_a(textStart);
            int rectRight = rectLeft + this.mc.field_71466_p.func_78256_a(textMiddle);
            int rectBottom = y + this.mc.field_71466_p.field_78288_b;
            Gui.func_73734_a((int)rectLeft, (int)y, (int)rectRight, (int)rectBottom, (int)-2108409);
            this.mc.field_71466_p.func_78261_a(textStart, x, y, 0xFFFFFF);
            this.mc.field_71466_p.func_78276_b(textMiddle, rectLeft, y, 0x404040);
            this.mc.field_71466_p.func_78261_a(textEnd, rectRight, y, 0xFFFFFF);
        } else {
            this.mc.field_71466_p.func_78261_a(text, x, y, 0xFFFFFF);
        }
    }

    private boolean shouldHighlightCategoryName() {
        return !this.controlsScreen.getSearchString().isEmpty() && (this.controlsScreen.getSearchType() == SearchType.ALL || this.controlsScreen.getSearchType() == SearchType.CATEGORY_NAME);
    }

    private boolean shouldHighlightKeybindName() {
        return !this.controlsScreen.getSearchString().isEmpty() && (this.controlsScreen.getSearchType() == SearchType.ALL || this.controlsScreen.getSearchType() == SearchType.KEYBIND_NAME);
    }

    private boolean shouldHighlightKeyName() {
        return !this.controlsScreen.getSearchString().isEmpty() && (this.controlsScreen.getSearchType() == SearchType.ALL || this.controlsScreen.getSearchType() == SearchType.KEY_NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public class CategoryEntry
    implements GuiListExtended.IGuiListEntry {
        private final String labelText;
        private final int labelWidth;

        public CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(this.labelText);
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            GuiNewKeyBindingList.this.drawHighlightedString(this.labelText, ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71462_r.field_146294_l / 2 - this.labelWidth / 2, y + slotHeight - ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.field_78288_b - 1, GuiNewKeyBindingList.this.shouldHighlightCategoryName());
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class KeyEntry
    implements GuiListExtended.IGuiListEntry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final CategoryEntry categoryEntry;
        private final GuiButton btnChangeKeyBinding;
        private final GuiButton btnResetKeyBinding;

        private KeyEntry(KeyBinding keyBinding, CategoryEntry categoryEntry) {
            this.keybinding = keyBinding;
            this.keyDesc = I18n.func_135052_a((String)keyBinding.func_151464_g(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new GuiButton(2000, 0, 0, 95, 20, this.keyDesc);
            this.categoryEntry = categoryEntry;
            this.btnResetKeyBinding = new GuiButton(2001, 0, 0, 50, 20, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0]));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            String string;
            KeyBinding keyBinding;
            boolean isKeySelected = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f == this.keybinding;
            GuiNewKeyBindingList.this.drawHighlightedString(this.keyDesc, x + 90 - GuiNewKeyBindingList.this.maxListLabelWidth, y + slotHeight / 2 - ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.field_78288_b / 2, GuiNewKeyBindingList.this.shouldHighlightKeybindName());
            this.btnResetKeyBinding.field_146128_h = x + 190 + 20;
            this.btnResetKeyBinding.field_146129_i = y;
            this.btnResetKeyBinding.field_146124_l = this.keybinding.func_151463_i() != this.keybinding.func_151469_h();
            this.btnResetKeyBinding.func_146112_a(GuiNewKeyBindingList.this.mc, mouseX, mouseY);
            this.btnChangeKeyBinding.field_146128_h = x + 105;
            this.btnChangeKeyBinding.field_146129_i = y;
            if (Controlling.isModernKeybindingInstalled && (keyBinding = this.keybinding) instanceof IKeyBinding) {
                IKeyBinding modernKB = (IKeyBinding)keyBinding;
                string = modernKB.getDisplayName();
            } else {
                string = GameSettings.func_74298_c((int)this.keybinding.func_151463_i());
            }
            this.btnChangeKeyBinding.field_146126_j = string;
            boolean hasConflict = false;
            boolean modConflict = true;
            if (this.keybinding.func_151463_i() != 0) {
                for (KeyBinding key : ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71474_y.field_74324_K) {
                    if (key == this.keybinding) continue;
                    if (Controlling.isModernKeybindingInstalled && key instanceof IKeyBinding) {
                        IKeyBinding modernKB = (IKeyBinding)key;
                        KeyBinding keyBinding2 = this.keybinding;
                        if (keyBinding2 instanceof IKeyBinding) {
                            IKeyBinding modernKB2 = (IKeyBinding)keyBinding2;
                            if (modernKB.conflicts(this.keybinding)) {
                                hasConflict = true;
                                modConflict &= modernKB2.hasKeyCodeModifierConflict(key);
                                continue;
                            }
                        }
                    }
                    if (this.keybinding.func_151463_i() != key.func_151463_i()) continue;
                    hasConflict = true;
                    break;
                }
            }
            String displayText = this.btnChangeKeyBinding.field_146126_j;
            String searchString = GuiNewKeyBindingList.this.controlsScreen.getSearchString();
            int index = this.btnChangeKeyBinding.field_146126_j.toLowerCase().indexOf(searchString.toLowerCase());
            int indexEndHighlight = index + GuiNewKeyBindingList.this.controlsScreen.getSearchString().length();
            boolean highlight = GuiNewKeyBindingList.this.shouldHighlightKeyName() && index > -1;
            String textStart = null;
            String textMiddle = null;
            String textEnd = null;
            if (highlight) {
                textStart = displayText.substring(0, index);
                textMiddle = displayText.substring(index, indexEndHighlight);
                textEnd = displayText.substring(indexEndHighlight);
            }
            String prefix = "";
            String suffix = "";
            if (isKeySelected) {
                prefix = EnumChatFormatting.YELLOW + "> " + EnumChatFormatting.RESET + EnumChatFormatting.UNDERLINE;
                suffix = EnumChatFormatting.RESET.toString() + EnumChatFormatting.YELLOW + " <";
            } else if (hasConflict) {
                EnumChatFormatting clr = modConflict ? EnumChatFormatting.GOLD : EnumChatFormatting.RED;
                prefix = clr + "[ " + EnumChatFormatting.RESET;
                suffix = clr + " ]";
            }
            this.btnChangeKeyBinding.field_146126_j = prefix + this.btnChangeKeyBinding.field_146126_j + suffix;
            if (highlight) {
                this.drawButtonWithHighlightedText(mouseX, mouseY, prefix, textStart, textMiddle, textEnd, suffix);
            } else {
                this.btnChangeKeyBinding.func_146112_a(GuiNewKeyBindingList.this.mc, mouseX, mouseY);
            }
        }

        private void drawButtonWithHighlightedText(int mouseX, int mouseY, String prefix, String textStart, String textMiddle, String textEnd, String suffix) {
            if (prefix.contains(EnumChatFormatting.UNDERLINE.toString())) {
                textMiddle = EnumChatFormatting.UNDERLINE + textMiddle;
                textEnd = EnumChatFormatting.UNDERLINE + textEnd;
            }
            String saveStr = this.btnChangeKeyBinding.field_146126_j;
            this.btnChangeKeyBinding.field_146126_j = "";
            this.btnChangeKeyBinding.func_146112_a(GuiNewKeyBindingList.this.mc, mouseX, mouseY);
            this.btnChangeKeyBinding.field_146126_j = saveStr;
            int xString = this.btnChangeKeyBinding.field_146128_h + this.btnChangeKeyBinding.field_146120_f / 2 - ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(this.btnChangeKeyBinding.field_146126_j) / 2;
            int yString = this.btnChangeKeyBinding.field_146129_i + (this.btnChangeKeyBinding.field_146121_g - 8) / 2;
            String drawnTextStart = prefix + textStart;
            int rectLeft = xString + ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(drawnTextStart);
            int rectRight = rectLeft + ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(textMiddle);
            int rectBottom = yString + ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.field_78288_b;
            Gui.func_73734_a((int)rectLeft, (int)yString, (int)rectRight, (int)rectBottom, (int)-2108409);
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78261_a(drawnTextStart, xString, yString, 0xFFFFFF);
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78276_b(textMiddle, rectLeft, yString, 0x404040);
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78261_a(textEnd + suffix, rectRight, yString, 0xFFFFFF);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnChangeKeyBinding.func_146116_c(GuiNewKeyBindingList.this.mc, mouseX, mouseY)) {
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f = this.keybinding;
                return true;
            }
            if (this.btnResetKeyBinding.func_146116_c(GuiNewKeyBindingList.this.mc, mouseX, mouseY)) {
                KeyBinding keyBinding;
                if (Controlling.isModernKeybindingInstalled && (keyBinding = this.keybinding) instanceof IKeyBinding) {
                    IKeyBinding modernKB = (IKeyBinding)keyBinding;
                    modernKB.setToDefault();
                } else {
                    this.keybinding.func_151462_b(this.keybinding.func_151469_h());
                }
                ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71474_y.func_151440_a(this.keybinding, this.keybinding.func_151469_h());
                KeyBinding.func_74508_b();
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnChangeKeyBinding.func_146118_a(x, y);
            this.btnResetKeyBinding.func_146118_a(x, y);
        }

        public KeyBinding getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public CategoryEntry getCategoryEntry() {
            return this.categoryEntry;
        }
    }
}

