/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.tp;

import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.task.NotifyTask;

public class CmdHome
extends CmdBase {
    public CmdHome() {
        super("home", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdHome.func_71531_a((String[])args, ServerUtilitiesPlayerData.get((ForgePlayer)Universe.get().getPlayer((ICommandSender)sender)).homes.list());
        }
        return super.func_71516_a(sender, args);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }

    public void func_71515_b(ICommandSender sender, String[] args0) throws CommandException {
        String[] args;
        if (args0.length == 0) {
            args0 = new String[]{"home"};
        }
        if ((args = args0)[0].equals("list")) {
            ForgePlayer p = CommandUtils.getSelfOrOther(sender, args, 1, "serverutilities.other_player.homes.list");
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(p);
            Collection<String> list = data.homes.list();
            IChatComponent msg = p.getDisplayName().func_150258_a(": " + list.size() + " / " + p.getRankConfig("serverutilities.homes.max").getInt() + ": ");
            if (!list.isEmpty()) {
                boolean first = true;
                for (String s : list) {
                    if (first) {
                        first = false;
                    } else {
                        msg.func_150258_a(", ");
                    }
                    ChatComponentText h = new ChatComponentText(s);
                    h.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("/home " + s + " " + p.getName())));
                    h.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/home " + s + " " + p.getName()));
                    h.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                    msg.func_150257_a((IChatComponent)h);
                }
            }
            sender.func_145747_a(msg);
            return;
        }
        if (args[0].equals("list_all")) {
            for (ForgePlayer p : Universe.get().getPlayers()) {
                this.func_71515_b(sender, new String[]{"list", p.getName()});
            }
            return;
        }
        ForgePlayer p = CommandUtils.getSelfOrOther(sender, args, 1, "serverutilities.other_player.homes.teleport");
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(p);
        BlockDimPos pos = data.homes.get(args[0]);
        if (pos == null) {
            throw ServerUtilities.error(sender, "serverutilities.lang.homes.not_set", args[0]);
        }
        EntityPlayerMP player = CmdHome.func_71521_c((ICommandSender)sender);
        if (player.field_71093_bK != pos.dim && !PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.homes.cross_dim")) {
            throw ServerUtilities.error(sender, "serverutilities.lang.homes.cross_dim", new Object[0]);
        }
        NotifyTask task = new NotifyTask(-1L, player, ServerUtilitiesNotifications.TELEPORT.createNotification("serverutilities.lang.warps.tp", args[0]));
        data.checkTeleportCooldown(sender, TeleportType.HOME);
        data.teleport(pos.teleporter(), TeleportType.HOME, task);
    }
}

