/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.core.util.AutoMap;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class BlockPos
implements Serializable {
    private static final long serialVersionUID = -7271947491316682006L;
    public final int xPos;
    public final int yPos;
    public final int zPos;
    public final int dim;
    public final World world;

    public BlockPos(int x, int y, int z) {
        this(x, y, z, 0);
    }

    public BlockPos(int x, int y, int z, int dim) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.dim = dim;
        this.world = DimensionManager.getWorld((int)dim);
    }

    public BlockPos(int x, int y, int z, World dim) {
        this.xPos = x;
        this.yPos = y;
        this.zPos = z;
        this.dim = dim.field_73011_w.field_76574_g;
        this.world = dim;
    }

    public String getLocationString() {
        return "[X: " + this.xPos + "][Y: " + this.yPos + "][Z: " + this.zPos + "][Dim: " + this.dim + "]";
    }

    public int hashCode() {
        int hash = 5;
        hash += 13 * this.xPos;
        hash += 19 * this.yPos;
        hash += 31 * this.zPos;
        return hash += 17 * this.dim;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof BlockPos)) {
            return false;
        }
        BlockPos otherPoint = (BlockPos)other;
        return this.xPos == otherPoint.xPos && this.yPos == otherPoint.yPos && this.zPos == otherPoint.zPos && this.dim == otherPoint.dim;
    }

    public int distanceFrom(BlockPos target) {
        if (target.dim != this.dim) {
            return Short.MIN_VALUE;
        }
        return this.distanceFrom(target.xPos, target.yPos, target.zPos);
    }

    public int distanceFrom(int x, int y, int z) {
        int distanceX = this.xPos - x;
        int distanceY = this.yPos - y;
        int distanceZ = this.zPos - z;
        return distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
    }

    public boolean isWithinRange(BlockPos target, int range) {
        if (target.dim != this.dim) {
            return false;
        }
        return this.isWithinRange(target.xPos, target.yPos, target.zPos, range);
    }

    public boolean isWithinRange(int x, int y, int z, int range) {
        return this.distanceFrom(x, y, z) <= range * range;
    }

    public BlockPos getUp() {
        return new BlockPos(this.xPos, this.yPos + 1, this.zPos, this.dim);
    }

    public BlockPos getDown() {
        return new BlockPos(this.xPos, this.yPos - 1, this.zPos, this.dim);
    }

    public BlockPos getXPos() {
        return new BlockPos(this.xPos + 1, this.yPos, this.zPos, this.dim);
    }

    public BlockPos getXNeg() {
        return new BlockPos(this.xPos - 1, this.yPos, this.zPos, this.dim);
    }

    public BlockPos getZPos() {
        return new BlockPos(this.xPos, this.yPos, this.zPos + 1, this.dim);
    }

    public BlockPos getZNeg() {
        return new BlockPos(this.xPos, this.yPos, this.zPos - 1, this.dim);
    }

    public AutoMap<BlockPos> getSurroundingBlocks() {
        AutoMap<BlockPos> sides = new AutoMap<BlockPos>();
        sides.put(this.getUp());
        sides.put(this.getDown());
        sides.put(this.getXPos());
        sides.put(this.getXNeg());
        sides.put(this.getZPos());
        sides.put(this.getZNeg());
        return sides;
    }

    public Block getBlockAtPos() {
        return this.getBlockAtPos(this);
    }

    public Block getBlockAtPos(BlockPos pos) {
        return this.getBlockAtPos(this.world, pos);
    }

    public Block getBlockAtPos(World world, BlockPos pos) {
        return world.func_147439_a(pos.xPos, pos.yPos, pos.zPos);
    }

    public int getMetaAtPos() {
        return this.getMetaAtPos(this);
    }

    public int getMetaAtPos(BlockPos pos) {
        return this.getMetaAtPos(this.world, pos);
    }

    public int getMetaAtPos(World world, BlockPos pos) {
        return world.func_72805_g(pos.xPos, pos.yPos, pos.zPos);
    }

    public boolean hasSimilarNeighbour() {
        return this.hasSimilarNeighbour(false);
    }

    public boolean hasSimilarNeighbour(boolean strict) {
        for (BlockPos g : this.getSurroundingBlocks().values()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                return true;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            return true;
        }
        return false;
    }

    public AutoMap<BlockPos> getSimilarNeighbour() {
        return this.getSimilarNeighbour(false);
    }

    public AutoMap<BlockPos> getSimilarNeighbour(boolean strict) {
        AutoMap<BlockPos> sides = new AutoMap<BlockPos>();
        for (BlockPos g : this.getSurroundingBlocks().values()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                sides.put(g);
                continue;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            sides.put(g);
        }
        return sides;
    }

    public Set<BlockPos> getValidNeighboursAndSelf() {
        AutoMap<BlockPos> h = this.getSimilarNeighbour(true);
        h.put(this);
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (BlockPos f : h.values()) {
            result.add(f);
        }
        return result;
    }
}

