/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.power.GaugeBounds;
import crazypants.enderio.machine.power.TileCapacitorBank;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPowerStorage
implements IMessage,
IMessageHandler<PacketPowerStorage, IMessage> {
    private int x;
    private int y;
    private int z;
    private int storedEnergy;

    public PacketPowerStorage() {
    }

    public PacketPowerStorage(TileCapacitorBank ent) {
        this.x = ent.field_145851_c;
        this.y = ent.field_145848_d;
        this.z = ent.field_145849_e;
        this.storedEnergy = ent.storedEnergyRF;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.storedEnergy = buf.readInt();
    }

    public IMessage onMessage(PacketPowerStorage message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank me = (TileCapacitorBank)te;
            me.storedEnergyRF = message.storedEnergy;
            double dif = Math.abs(me.lastRenderStoredRatio - me.getEnergyStoredRatio());
            if (dif > 0.025) {
                if (!me.isMultiblock()) {
                    player.field_70170_p.func_147471_g(message.x, message.y, message.z);
                } else {
                    BlockCoord[] mb;
                    for (BlockCoord bc : mb = me.multiblock) {
                        this.updateGaugeRender(player.field_70170_p, bc);
                    }
                }
            }
        }
        return null;
    }

    private void updateGaugeRender(World worldObj, BlockCoord bc) {
        TileCapacitorBank me;
        List<GaugeBounds> gb;
        TileEntity te = worldObj.func_147438_o(bc.x, bc.y, bc.z);
        if (te instanceof TileCapacitorBank && (gb = (me = (TileCapacitorBank)te).getGaugeBounds()) != null && !gb.isEmpty()) {
            worldObj.func_147471_g(bc.x, bc.y, bc.z);
        }
    }
}

