/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge;

import com.google.common.collect.ImmutableList;
import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.HodgepodgeEventHandler;
import com.mitchej123.hodgepodge.client.HodgepodgeClient;
import com.mitchej123.hodgepodge.commands.DebugCommand;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.net.NetworkHandler;
import com.mitchej123.hodgepodge.util.AnchorAlarm;
import com.mitchej123.hodgepodge.util.StatHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.command.ICommand;

@Mod(modid="hodgepodge", version="2.5.90", name="Hodgepodge", dependencies="required-after:gtnhmixins@[2.0.1,);required-after:unimixins@[0.0.14,);required-after:gtnhlib@[0.5.15,);", guiFactory="com.mitchej123.hodgepodge.config.gui.HodgepodgeGuiConfigFactory")
public class Hodgepodge {
    public static final AnchorAlarm ANCHOR_ALARM = new AnchorAlarm();
    public static final HodgepodgeEventHandler EVENT_HANDLER = new HodgepodgeEventHandler();
    public static final String MODID = "hodgepodge";
    public static final String VERSION = "2.5.90";
    public static final String NAME = "Hodgepodge";
    public static final boolean isGTNH = true;
    private final ArtifactVersion minimumClientJoinVersion = new DefaultArtifactVersion("2.5.36");

    public Hodgepodge() {
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String getLabel() {
                return "CPU Threads";
            }

            public String call() {
                return String.valueOf(Runtime.getRuntime().availableProcessors());
            }
        });
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Compat.init(event.getSide());
        EVENT_HANDLER.preinit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)ANCHOR_ALARM);
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            HodgepodgeClient.postInit();
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent aEvent) {
        aEvent.registerServerCommand((ICommand)new DebugCommand());
        EVENT_HANDLER.setAidTriggerDisabled(false);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        if (TweaksConfig.addModEntityStats) {
            StatHandler.addEntityStats();
        }
    }

    @Mod.EventHandler
    public void onModIdMapping(FMLModIdMappingEvent event) {
        if (TweaksConfig.addModItemStats) {
            StatHandler.remap((ImmutableList<FMLModIdMappingEvent.ModRemapping>)event.remappedIds);
        }
    }

    @NetworkCheckHandler
    public boolean checkModList(Map<String, String> versions, Side side) {
        if (side == Side.CLIENT && versions.containsKey(MODID)) {
            return this.minimumClientJoinVersion.compareTo((Object)new DefaultArtifactVersion(versions.get(MODID))) <= 0;
        }
        return true;
    }
}

