/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.everglades.gen.gt;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTLog;
import gregtech.common.blocks.BlockOres;
import gregtech.common.blocks.TileEntityOres;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.everglades.dimension.DimensionEverglades;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT_Base;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGen_GT_Ore_Layer
extends WorldGen_GT {
    public static ArrayList<WorldGen_GT_Ore_Layer> sList = new ArrayList();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public Block mPrimaryMeta;
    public Block mSecondaryMeta;
    public Block mBetweenMeta;
    public Block mSporadicMeta;
    public final Material mPrimary;
    public final Material mSecondary;
    public final Material mBetween;
    public final Material mSporadic;
    public final String mRestrictBiome;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;
    public static final int WRONG_BIOME = 0;
    public static final int WRONG_DIMENSION = 1;
    public static final int NO_ORE_IN_BOTTOM_LAYER = 2;
    public static final int NO_OVERLAP = 3;
    public static final int ORE_PLACED = 4;
    public static final int NO_OVERLAP_AIR_BLOCK = 5;
    public final String aTextWorldgen = "worldgen.";
    private String ore1String = "unset";
    private String ore2String = "unset";
    private String ore3String = "unset";
    private String ore4String = "unset";
    Map<Materials, String> gtOreMap = new HashMap<Materials, String>();

    public WorldGen_GT_Ore_Layer(String aName, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, Material aPrimary, Material aSecondary, Material aBetween, Material aSporadic) {
        this(aName, true, aMinY, aMaxY, aWeight, aDensity, aSize, false, false, false, false, false, false, aPrimary, aSecondary, aBetween, aSporadic);
    }

    public WorldGen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, boolean GC_UNUSED1, boolean GC_UNUSED2, boolean GC_UNUSED3, Material aPrimary, Material aSecondary, Material aBetween, Material aSporadic) {
        super(aName, sList, aDefault);
        Logger.WORLD("Creating Ore Layer Object");
        this.mOverworld = aOverworld;
        this.mNether = aNether;
        this.mEnd = aEnd;
        this.mMinY = (short)5;
        this.mMaxY = (short)14;
        this.mWeight = (short)aWeight;
        this.mDensity = (short)aDensity;
        this.mSize = (short)Math.max(1, aSize);
        this.mPrimary = aPrimary;
        this.mSecondary = aSecondary;
        this.mBetween = aBetween;
        this.mSporadic = aSporadic;
        this.mPrimaryMeta = aPrimary.getOreBlock(1);
        this.mSecondaryMeta = aSecondary.getOreBlock(1);
        this.mBetweenMeta = aBetween.getOreBlock(1);
        this.mSporadicMeta = aSporadic.getOreBlock(1);
        this.mRestrictBiome = "None";
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int aSeedX, int aSeedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        int sZ;
        int eX;
        if (this.mPrimaryMeta == Blocks.field_150348_b || this.mSecondaryMeta == Blocks.field_150348_b || this.mBetweenMeta == Blocks.field_150348_b || this.mSporadicMeta == Blocks.field_150348_b) {
            this.mPrimaryMeta = this.mPrimary.getOreBlock(1);
            this.mSecondaryMeta = this.mSecondary.getOreBlock(1);
            this.mBetweenMeta = this.mBetween.getOreBlock(1);
            this.mSporadicMeta = this.mSporadic.getOreBlock(1);
            Logger.WORLD("[Vein Generator] An Ore in a Vein had defaulted back to a default value, so they have now been reset to correct values.");
        }
        if (this.mWorldGenName.equals("vein0")) {
            if (WorldGen_GT_Base.debugWorldGen) {
                GTLog.out.println(" NoOresInVein-vein0");
            }
            Logger.WORLD("[World Generation Debug] Special Empty Vein placed.");
            return 4;
        }
        if (aDimensionType != DimensionEverglades.DIMID) {
            Logger.WORLD("[World Generation Debug] Wrong dimension.");
            return 1;
        }
        if (!this.mRestrictBiome.equals("None") && !this.mRestrictBiome.equals(aBiome)) {
            return 0;
        }
        int[] placeCount = new int[4];
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int wXVein = aSeedX - aRandom.nextInt(this.mSize);
        int eXVein = aSeedX + 16 + aRandom.nextInt(this.mSize);
        int wX = Math.max(wXVein, aChunkX + 2);
        if (wX >= (eX = Math.min(eXVein, aChunkX + 2 + 16))) {
            Block tBlock = aWorld.func_147439_a(aChunkX + 8, tMinY, aChunkZ + 8);
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, DimensionEverglades.blockSecondLayer) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, DimensionEverglades.blockMainFiller) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, DimensionEverglades.blockSecondaryFiller) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTechAPI.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTechAPI.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        int nZVein = aSeedZ - aRandom.nextInt(this.mSize);
        int sZVein = aSeedZ + 16 + aRandom.nextInt(this.mSize);
        int nZ = Math.max(nZVein, aChunkZ + 2);
        if (nZ >= (sZ = Math.min(sZVein, aChunkZ + 2 + 16))) {
            Block tBlock = aWorld.func_147439_a(aChunkX + 8, tMinY, aChunkZ + 8);
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTechAPI.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 8, tMinY, aChunkZ + 8, GregTechAPI.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        if (WorldGen_GT_Base.debugWorldGen) {
            String tDimensionName = aWorld.field_73011_w.func_80007_l();
            GTLog.out.print("Trying Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY);
        }
        int localDensity = Math.max(1, this.mDensity / (int)Math.sqrt(2.0 + Math.pow(aChunkX / 16 - aSeedX / 16, 2.0) + Math.pow(aChunkZ / 16 - aSeedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, false)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        Logger.WORLD("[World Generation Debug] Trying to set Ores?");
        for (level = tMinY; level < tMinY - 1 + 3; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta != null) {
                        if (!this.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, false)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, false)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, false)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta != null) {
                    if (!this.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, false)) continue;
                    placeCount[0] = placeCount[0] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        while (level < tMinY + 6) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta != null) {
                        if (!this.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, false)) continue;
                        placeCount[0] = placeCount[0] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta == null || !this.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, false)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
            ++level;
        }
        if (WorldGen_GT_Base.debugWorldGen) {
            String tDimensionName = aWorld.field_73011_w.func_80007_l();
            GTLog.out.println("Generated Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY + " wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + this.mDensity + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return 4;
    }

    public boolean setOreBlock(World aWorld, int aX, int aY, int aZ, Block aMetaData, boolean isSmallOre, boolean air) {
        Block tBlock;
        if (!air) {
            aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        }
        if (aMetaData instanceof BlockOres) {
            int r;
            String fString;
            if (this.ore1String.equals("unset")) {
                this.ore1String = Utils.sanitizeString(this.mPrimary.getLocalizedName().toLowerCase());
            }
            if (this.ore2String.equals("unset")) {
                this.ore2String = Utils.sanitizeString(this.mSecondaryMeta.func_149732_F().toLowerCase());
            }
            if (this.ore3String.equals("unset")) {
                this.ore3String = Utils.sanitizeString(this.mBetweenMeta.func_149732_F().toLowerCase());
            }
            if (this.ore4String.equals("unset")) {
                this.ore4String = Utils.sanitizeString(this.mSporadicMeta.func_149732_F().toLowerCase());
            }
            if (this.mPrimaryMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.mName.toLowerCase()));
                    }
                    if (!(fString = this.gtOreMap.get(f)).contains(this.ore1String) || !TileEntityOres.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    return true;
                }
            }
            if (this.mSecondaryMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.mName.toLowerCase()));
                    }
                    if (!(fString = this.gtOreMap.get(f)).contains(this.ore2String) || !TileEntityOres.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    return true;
                }
            }
            if (this.mBetweenMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.mName.toLowerCase()));
                    }
                    if (!(fString = this.gtOreMap.get(f)).contains(this.ore3String) || !TileEntityOres.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    return true;
                }
            }
            if (this.mSporadicMeta == aMetaData) {
                for (Materials f : Materials.values()) {
                    if (!this.gtOreMap.containsKey(f)) {
                        this.gtOreMap.put(f, Utils.sanitizeString(f.mName.toLowerCase()));
                    }
                    if (!(fString = this.gtOreMap.get(f)).contains(this.ore4String) || !TileEntityOres.setOreBlock(aWorld, aX, aY, aZ, r = f.mMetaItemSubID, false)) continue;
                    return true;
                }
            }
        }
        if ((tBlock = aWorld.func_147439_a(aX, aY, aZ)).isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, (Block)Blocks.field_150354_m) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150346_d) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, GregTechAPI.sBlockStones) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, DimensionEverglades.blockSecondLayer) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, DimensionEverglades.blockMainFiller) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, DimensionEverglades.blockSecondaryFiller) || tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, Blocks.field_150322_A)) {
            return aWorld.func_147465_d(aX, aY, aZ, aMetaData, 0, 3);
        }
        return false;
    }
}

