/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import codechicken.nei.recipe.RecipeCatalysts;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.RecipeMapWorkable;
import gregtech.api.metatileentity.implementations.MTESpecialFilter;
import gregtech.api.multitileentity.MultiTileEntityItem;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.ItemMachines;
import gregtech.loaders.preload.GT_Loader_MultiTileEntities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class MTERecipeFilter
extends MTESpecialFilter {
    private static final String TT_machineType = "GT5U.MBTT.MachineType";
    private static final String REPRESENTATION_SLOT_TOOLTIP = "GT5U.recipe_filter.representation_slot.tooltip";
    private static final String EMPTY_REPRESENTATION_SLOT_TOOLTIP = "GT5U.recipe_filter.empty_representation_slot.tooltip";
    public RecipeMap<?> mRecipeMap;
    private List<ItemStack> filteredMachines = new ArrayList<ItemStack>();
    public int mRotationIndex = 0;

    public MTERecipeFilter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{"Filters 1 Recipe Type", "Use Screwdriver to regulate output stack size"});
    }

    public MTERecipeFilter(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTERecipeFilter(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    private static RecipeMap<?> getItemStackMachineRecipeMap(ItemStack stack) {
        if (stack != null) {
            IMetaTileEntity metaTileEntity = ItemMachines.getMetaTileEntity(stack);
            if (metaTileEntity != null) {
                return MTERecipeFilter.getMetaTileEntityRecipeMap(metaTileEntity);
            }
            if (stack.func_77973_b() instanceof MultiTileEntityItem) {
                return MTERecipeFilter.getMuTeRecipeMap(stack);
            }
        }
        return null;
    }

    private static RecipeMap<?> getMetaTileEntityRecipeMap(IMetaTileEntity metaTileEntity) {
        if (metaTileEntity instanceof RecipeMapWorkable) {
            RecipeMapWorkable recipeMapWorkable = (RecipeMapWorkable)((Object)metaTileEntity);
            return recipeMapWorkable.getRecipeMap();
        }
        return null;
    }

    private static RecipeMap<?> getMuTeRecipeMap(@NotNull ItemStack stack) {
        MultiTileEntity tileEntity = GT_Loader_MultiTileEntities.MACHINE_REGISTRY.getReferenceTileEntity(stack);
        if (tileEntity instanceof RecipeMapWorkable) {
            RecipeMapWorkable recipeMapWorkable = (RecipeMapWorkable)((Object)tileEntity);
            return recipeMapWorkable.getRecipeMap();
        }
        return null;
    }

    private static List<ItemStack> getFilteredMachines(RecipeMap<?> recipeMap) {
        return RecipeCatalysts.getRecipeCatalysts((String)recipeMap.getFrontend().getUIProperties().neiTransferRectId).stream().map(positionedStack -> positionedStack.item).collect(Collectors.toList());
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide() || aTick % 8L != 0L && this.mRotationIndex != -1) {
            return;
        }
        if (this.filteredMachines.isEmpty()) {
            return;
        }
        this.mRotationIndex = (this.mRotationIndex + 1) % this.filteredMachines.size();
        this.mInventory[9] = GTUtility.copyAmount(1, this.filteredMachines.get(this.mRotationIndex));
        if (this.mInventory[9] == null) {
            return;
        }
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERecipeFilter(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_RECIPEFILTER), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_RECIPEFILTER_GLOW).glow().build());
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mRecipeMap != null) {
            aNBT.func_74778_a("mRecipeMap", this.mRecipeMap.unlocalizedName);
        }
        NBTTagList tagList = new NBTTagList();
        for (ItemStack filteredMachine : this.filteredMachines) {
            tagList.func_74742_a((NBTBase)filteredMachine.func_77955_b(new NBTTagCompound()));
        }
        aNBT.func_74782_a("filteredMachines", (NBTBase)tagList);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRecipeMap = RecipeMap.getFromOldIdentifier(aNBT.func_74779_i("mRecipeMap"));
        this.filteredMachines.clear();
        NBTTagList tagList = aNBT.func_150295_c("filteredMachines", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ItemStack readStack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
            if (readStack == null) continue;
            this.filteredMachines.add(readStack);
        }
    }

    @Override
    protected boolean isStackAllowed(ItemStack aStack) {
        return this.mRecipeMap != null && this.mRecipeMap.containsInput(aStack);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.mRecipeMap == null ? "" : this.mRecipeMap.unlocalizedName, id -> {
            this.mRecipeMap = RecipeMap.ALL_RECIPE_MAPS.get(id);
        }));
    }

    @Override
    protected List<Text> getEmptySlotTooltip() {
        return Collections.singletonList(Text.localised((String)EMPTY_REPRESENTATION_SLOT_TOOLTIP, (Object[])new Object[0]));
    }

    @Override
    public Function<List<String>, List<String>> getItemStackReplacementTooltip() {
        if (this.mRecipeMap != null) {
            List<String> tooltip = this.assembleItemStackReplacementTooltip(this.mRecipeMap);
            return list -> tooltip;
        }
        return super.getItemStackReplacementTooltip();
    }

    @NotNull
    private List<String> assembleItemStackReplacementTooltip(RecipeMap<?> recipeMap) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(StatCollector.func_74838_a((String)TT_machineType) + ": " + EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)recipeMap.unlocalizedName) + EnumChatFormatting.RESET);
        int recipeSize = recipeMap.getAllRecipes().size();
        if (recipeSize > 0) {
            tooltip.add("Filter size: \u00a7e" + recipeSize + "\u00a7r");
        }
        tooltip.addAll(this.mTooltipCache.getData((String)REPRESENTATION_SLOT_TOOLTIP, (Object[])new Object[0]).text);
        return tooltip;
    }

    @Override
    protected SlotWidget createFilterIconSlot(BaseSlot slot) {
        return new RecipeFilterIconSlotWidget(slot);
    }

    private class RecipeFilterIconSlotWidget
    extends MTESpecialFilter.FilterIconSlotWidget {
        private static final int SYNC_RECIPEMAP_C2S = 98;
        private static final int REQUEST_FILTERED_MACHINES_S2C = 99;

        public RecipeFilterIconSlotWidget(BaseSlot slot) {
            super(slot);
        }

        @Override
        protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
        }

        public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
            this.updateAndSendRecipeMapToServer(this.getContext().getCursor().getItemStack());
            return Interactable.ClickResult.SUCCESS;
        }

        public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
            this.updateAndSendRecipeMapToServer(draggedStack);
            draggedStack.field_77994_a = 0;
            return true;
        }

        private void updateAndSendRecipeMapToServer(ItemStack stack) {
            MTERecipeFilter.this.mRecipeMap = MTERecipeFilter.getItemStackMachineRecipeMap(stack);
            this.updateAndSendRecipeMapToServer(MTERecipeFilter.this.mRecipeMap);
        }

        private void updateAndSendRecipeMapToServer(RecipeMap<?> recipeMap) {
            if (recipeMap != null) {
                MTERecipeFilter.this.filteredMachines = MTERecipeFilter.getFilteredMachines(recipeMap);
            } else {
                MTERecipeFilter.this.filteredMachines = new ArrayList();
                MTERecipeFilter.this.mInventory[9] = null;
            }
            MTERecipeFilter.this.mRotationIndex = -1;
            this.syncToServer(98, buffer -> {
                NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)(recipeMap != null ? recipeMap.unlocalizedName : null));
                buffer.func_150787_b(MTERecipeFilter.this.filteredMachines.size());
                for (ItemStack filteredMachine : MTERecipeFilter.this.filteredMachines) {
                    NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)filteredMachine);
                }
            });
        }

        public void readOnClient(int id, PacketBuffer buf) {
            if (id != 99) {
                super.readOnClient(id, buf);
                return;
            }
            String recipeMapName = NetworkUtils.readStringSafe((PacketBuffer)buf);
            RecipeMap<?> recipeMap = MTERecipeFilter.this.mRecipeMap = recipeMapName != null ? RecipeMap.ALL_RECIPE_MAPS.get(recipeMapName) : null;
            if (MTERecipeFilter.this.mRecipeMap != null) {
                this.updateAndSendRecipeMapToServer(MTERecipeFilter.this.mRecipeMap);
            }
        }

        public void readOnServer(int id, PacketBuffer buf) throws IOException {
            if (id != 98) {
                super.readOnServer(id, buf);
                return;
            }
            String recipeMapName = NetworkUtils.readStringSafe((PacketBuffer)buf);
            MTERecipeFilter.this.mRecipeMap = recipeMapName != null ? RecipeMap.getFromOldIdentifier(recipeMapName) : null;
            MTERecipeFilter.this.mRotationIndex = -1;
            MTERecipeFilter.this.mInventory[9] = null;
            MTERecipeFilter.this.filteredMachines.clear();
            if (MTERecipeFilter.this.mRecipeMap != null) {
                int filteredMachineSize = buf.func_150792_a();
                filteredMachineSize = Math.min(filteredMachineSize, 256);
                for (int i = 0; i < filteredMachineSize; ++i) {
                    ItemStack stack = NetworkUtils.readItemStack((PacketBuffer)buf);
                    if (stack == null) continue;
                    MTERecipeFilter.this.filteredMachines.add(stack);
                }
            }
        }

        public void detectAndSendChanges(boolean init) {
            super.detectAndSendChanges(init);
            if (init && MTERecipeFilter.this.mRecipeMap != null && MTERecipeFilter.this.filteredMachines.isEmpty()) {
                this.syncToClient(99, buffer -> NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)MTERecipeFilter.this.mRecipeMap.unlocalizedName));
            }
        }
    }
}

