/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverPlayerDetector
extends CoverBehavior {
    private String placer = "";
    private int range = 8;

    public CoverPlayerDetector(ITexture coverTexture) {
        super(coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        boolean playerDetected = false;
        if (aTileEntity instanceof IGregTechTileEntity) {
            if (aTileEntity.isUniversalEnergyStored(20L)) {
                aTileEntity.decreaseStoredEnergyUnits(20L, true);
                this.range = 32;
            } else {
                this.range = 8;
            }
            this.placer = ((IGregTechTileEntity)aTileEntity).getOwnerName();
        }
        for (Object tObject : aTileEntity.getWorld().field_73010_i) {
            EntityPlayerMP tEntity;
            int dist;
            if (!(tObject instanceof EntityPlayerMP) || (dist = Math.max(1, (int)(tEntity = (EntityPlayerMP)tObject).func_70011_f((double)aTileEntity.getXCoord() + 0.5, (double)aTileEntity.getYCoord() + 0.5, (double)aTileEntity.getZCoord() + 0.5))) >= this.range) continue;
            if (aCoverVariable == 0) {
                playerDetected = true;
                break;
            }
            if (tEntity.getDisplayName().equalsIgnoreCase(this.placer)) {
                if (aCoverVariable != 1) continue;
                playerDetected = true;
                break;
            }
            if (aCoverVariable != 2) continue;
            playerDetected = true;
            break;
        }
        aTileEntity.setOutputRedstoneSignal(side, (byte)(playerDetected ? 15 : 0));
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 3) < 0) {
            aCoverVariable = 2;
        }
        switch (aCoverVariable) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("068.1", "Emit if any Player is close"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("069.1", "Emit if other Player is close"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("070", "Emit if you are close"));
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new PlayerDetectorUIFactory(buildContext).createWindow();
    }

    private class PlayerDetectorUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public PlayerDetectorUIFactory(CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverPlayerDetector.this, (index, coverData) -> index == CoverPlayerDetector.convert(coverData), (index, coverData) -> new ISerializableObject.LegacyCoverData((int)index)).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(GTUtility.trans("068.1", "Emit if any Player is close")).setPos(0, 0)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(GTUtility.trans("069.1", "Emit if other Player is close")).setPos(0, 18)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofCheck(), widget -> widget.addTooltip(GTUtility.trans("070", "Emit if you are close")).setPos(0, 36)).setPos(10, 25))).widget(new TextWidget(GTUtility.trans("319", "Any player")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(GTUtility.trans("320", "Other players")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 47))).widget(new TextWidget(GTUtility.trans("321", "Only owner")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 65));
        }
    }
}

