/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import goodgenerator.blocks.tileEntity.base.MTELargeTurbineBase;
import goodgenerator.loader.Loaders;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTESupercriticalFluidTurbine
extends MTELargeTurbineBase {
    private boolean looseFit = false;
    private static final IIconContainer turbineOn = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_05");
    private static final IIconContainer turbineOff = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_15");
    private static final IIconContainer turbineEmpty = new Textures.BlockIcons.CustomIcon("icons/turbines/TURBINE_25");

    public MTESupercriticalFluidTurbine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESupercriticalFluidTurbine(String aName) {
        super(aName);
    }

    @Override
    public int fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        int tEU = 0;
        int totalFlow = 0;
        int flow = 0;
        this.realOptFlow = this.looseFit ? (double)turbine.getOptimalLooseSteamFlow() : (double)turbine.getOptimalSteamFlow();
        int remainingFlow = GTUtility.safeInt((long)(this.realOptFlow * 1.25));
        this.storedFluid = 0;
        FluidStack tSCSteam = FluidRegistry.getFluidStack((String)"supercriticalsteam", (int)1);
        for (int i = 0; i < aFluids.size() && remainingFlow > 0; ++i) {
            FluidStack aFluidStack = aFluids.get(i);
            if (tSCSteam.isFluidEqual(aFluidStack)) {
                flow = Math.min(aFluidStack.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluidStack, flow));
                this.storedFluid += aFluidStack.amount;
                remainingFlow -= flow;
                totalFlow += flow;
                continue;
            }
            if (!GTModHandler.isAnySteam(aFluidStack)) continue;
            this.depleteInput(new FluidStack(aFluidStack, aFluidStack.amount));
        }
        if (totalFlow <= 0) {
            return 0;
        }
        tEU = totalFlow;
        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)totalFlow));
        if ((double)totalFlow == this.realOptFlow) {
            tEU = GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency())));
        } else {
            float efficiency = 1.0f - (float)Math.abs(((double)totalFlow - this.realOptFlow) / (double)((float)this.realOptFlow));
            tEU = (int)((float)tEU * efficiency);
            tEU = Math.max(1, GTUtility.safeInt((long)((float)tEU * (this.looseFit ? turbine.getLooseSteamEfficiency() : turbine.getSteamEfficiency()))));
        }
        if ((long)tEU > this.maxPower) {
            tEU = GTUtility.safeInt(this.maxPower);
        }
        return tEU;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.looseFit ^= true;
            GTUtility.sendChatToPlayer(aPlayer, this.looseFit ? GTUtility.trans("500", "Fitting: Loose - More Flow") : GTUtility.trans("501", "Fitting: Tight - More Efficiency"));
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return this.looseFit ? (XSTR.XSTR_INSTANCE.nextInt(2) == 0 ? 0 : 1) : 2;
    }

    @Override
    public String[] getInfoData() {
        ((MTELargeTurbineBase)this).looseFit = this.looseFit;
        return super.getInfoData();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("turbineFitting", this.looseFit);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.looseFit = aNBT.func_74767_n("turbineFitting");
    }

    @Override
    public Block getCasingBlock() {
        return Loaders.supercriticalFluidTurbineCasing;
    }

    @Override
    public int getCasingMeta() {
        return 0;
    }

    @Override
    public int getCasingTextureIndex() {
        return 1538;
    }

    @Override
    public boolean isNewStyleRendering() {
        return true;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Supercritical Steam Turbine").addInfo("Needs a Turbine, place inside controller").addInfo("Use Supercritical Steam to generate power.").addInfo("Outputs 1L of SH Steam per 1L of SC Steam as well as producing power").addInfo("Power output depends on turbine and fitting").addInfo("Use screwdriver to adjust fitting of turbine").beginStructureBlock(3, 3, 4, true).addController("Front center").addCasingInfoMin("SC Turbine Casing", 24, false).addDynamoHatch("Back center", 1).addMaintenanceHatch("Side centered", 2).addInputHatch("Supercritical Fluid, Side centered", 2).addOutputHatch("Superheated Steam, Side centered", 3).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESupercriticalFluidTurbine(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.getCasingTextureForId(1538);
        iTextureArray[1] = facing == side ? (aActive ? TextureFactory.of(turbineOn) : (this.hasTurbine() ? TextureFactory.of(turbineOff) : TextureFactory.of(turbineEmpty))) : Textures.BlockIcons.getCasingTextureForId(1538);
        return iTextureArray;
    }
}

