/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis.mega;

import bartworks.util.BWTooltipReference;
import bartworks.util.BWUtil;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class MegaMultiBlockBase<T extends MegaMultiBlockBase<T>>
extends MTEExtendedPowerMultiBlockBase<T> {
    protected MegaMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MegaMultiBlockBase(String aName) {
        super(aName);
    }

    protected String[] getExtendedInfoData() {
        return new String[0];
    }

    protected long[] getCurrentInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatch hatch : this.getExoticAndNormalEnergyHatchList()) {
            storedEnergy += hatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += hatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new long[]{storedEnergy, maxEnergy};
    }

    @Override
    public String[] getInfoData() {
        long[] ttHatches = this.getCurrentInfoData();
        long storedEnergy = ttHatches[0];
        long maxEnergy = ttHatches[1];
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        long nominalV = this.getMaxInputEu();
        String tName = BWUtil.getTierNameFromVoltage(nominalV);
        if ("MAX+".equals(tName)) {
            tName = EnumChatFormatting.OBFUSCATED + "MAX+";
        }
        String[] extendedInfo = this.getExtendedInfoData();
        String[] baseInfo = new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*" + GTUtility.formatNumbers(this.getMaxInputAmps()) + "A) = " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(nominalV) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + tName + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
        String[] combinedInfo = Arrays.copyOf(baseInfo, baseInfo.length + extendedInfo.length + 1);
        System.arraycopy(extendedInfo, 0, combinedInfo, baseInfo.length, extendedInfo.length);
        combinedInfo[combinedInfo.length - 1] = BWTooltipReference.BW;
        return combinedInfo;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
    }

    protected static class StructureElementAirNoHint<T>
    implements IStructureElement<T> {
        private static final StructureElementAirNoHint<?> INSTANCE = new StructureElementAirNoHint();

        public static <T> IStructureElement<T> getInstance() {
            return INSTANCE;
        }

        private StructureElementAirNoHint() {
        }

        public boolean check(T o, World world, int x, int y, int z) {
            return world.func_147437_c(x, y, z);
        }

        public boolean spawnHint(T o, World world, int x, int y, int z, ItemStack trigger) {
            if (world.func_72899_e(x, y, z) && !world.func_147437_c(x, y, z)) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)13);
            }
            return true;
        }

        public boolean placeBlock(T o, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147468_f(x, y, z);
            return true;
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.createEmpty();
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(T o, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(o, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return IStructureElement.PlaceResult.ACCEPT;
        }
    }
}

