/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.tracks.ISwitchDevice;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackSwitchBase;
import mods.railcraft.common.carts.CartUtils;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackSwitch
extends TrackSwitchBase
implements ITrackReversable {
    private boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SWITCH;
    }

    @Override
    public IIcon getIcon() {
        int index = 0;
        if (this.reversed) {
            index += 2;
        }
        if (this.isVisuallySwitched()) {
            ++index;
        }
        return this.getIcon(index);
    }

    @Override
    public int getBasicRailMetadata(EntityMinecart cart) {
        int meta = this.tileEntity.func_145832_p();
        if (cart != null && this.shouldSwitchForCart(cart)) {
            if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_SOUTH_CORNER.ordinal());
            } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
                meta = this.isMirrored() ? (this.reversed ? EnumTrackMeta.WEST_NORTH_CORNER.ordinal() : EnumTrackMeta.EAST_NORTH_CORNER.ordinal()) : (this.reversed ? EnumTrackMeta.EAST_SOUTH_CORNER.ordinal() : EnumTrackMeta.WEST_SOUTH_CORNER.ordinal());
            }
        }
        return meta;
    }

    @Override
    protected List<UUID> getCartsAtLockEntrance() {
        int x = this.tileEntity.field_145851_c;
        int y = this.tileEntity.field_145848_d;
        int z = this.tileEntity.field_145849_e;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isReversed() != this.isMirrored() ? ++z : --z;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = !this.isReversed() != this.isMirrored() ? ++x : --x;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtDecisionEntrance() {
        int x = this.tileEntity.field_145851_c;
        int y = this.tileEntity.field_145848_d;
        int z = this.tileEntity.field_145849_e;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            z = this.isReversed() != this.isMirrored() ? --z : ++z;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            x = !this.isReversed() != this.isMirrored() ? --x : ++x;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtSpringEntrance() {
        int x = this.tileEntity.field_145851_c;
        int y = this.tileEntity.field_145848_d;
        int z = this.tileEntity.field_145849_e;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            x = this.isMirrored() ? --x : ++x;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            z = this.isMirrored() ? --z : ++z;
        }
        return CartUtils.getMinecartUUIDsAt(this.getWorld(), x, y, z, 0.1f);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("Reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.reversed = data.func_74767_n("Reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.reversed = data.readBoolean();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public ISwitchDevice.ArrowDirection getRedSignDirection() {
        if (this.tileEntity.func_145832_p() == 1) {
            if (this.isVisuallySwitched()) {
                if (this.isMirrored()) {
                    return ISwitchDevice.ArrowDirection.NORTH;
                }
                return ISwitchDevice.ArrowDirection.SOUTH;
            }
            if (this.isReversed() != this.isMirrored()) {
                return ISwitchDevice.ArrowDirection.WEST;
            }
            return ISwitchDevice.ArrowDirection.EAST;
        }
        if (this.isVisuallySwitched()) {
            if (this.isMirrored()) {
                return ISwitchDevice.ArrowDirection.EAST;
            }
            return ISwitchDevice.ArrowDirection.WEST;
        }
        if (this.isReversed() != this.isMirrored()) {
            return ISwitchDevice.ArrowDirection.NORTH;
        }
        return ISwitchDevice.ArrowDirection.SOUTH;
    }

    @Override
    public ISwitchDevice.ArrowDirection getWhiteSignDirection() {
        if (this.tileEntity.func_145832_p() == 1) {
            if (this.isVisuallySwitched()) {
                return ISwitchDevice.ArrowDirection.EAST_WEST;
            }
            return ISwitchDevice.ArrowDirection.NORTH_SOUTH;
        }
        if (this.isVisuallySwitched()) {
            return ISwitchDevice.ArrowDirection.NORTH_SOUTH;
        }
        return ISwitchDevice.ArrowDirection.EAST_WEST;
    }

    @Override
    public ForgeDirection getActuatorLocation() {
        ForgeDirection dir = ForgeDirection.NORTH;
        int meta = this.tileEntity.func_145832_p();
        if (meta == EnumTrackMeta.NORTH_SOUTH.ordinal()) {
            dir = this.isMirrored() ? ForgeDirection.EAST : ForgeDirection.WEST;
        } else if (meta == EnumTrackMeta.EAST_WEST.ordinal()) {
            dir = this.isMirrored() ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return dir;
    }
}

