/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.packets.gui.GUIPacket;
import logisticspipes.proxy.MainProxy;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class NewGuiHandler {
    public static List<GuiProvider> guilist;
    public static Map<Class<? extends GuiProvider>, GuiProvider> guimap;

    public static <T extends GuiProvider> T getGui(Class<T> clazz) {
        return (T)guimap.get(clazz).template();
    }

    public static void initialize() {
        ArrayList<ClassPath.ClassInfo> classes = new ArrayList<ClassPath.ClassInfo>((Collection<ClassPath.ClassInfo>)ClassPath.from((ClassLoader)NewGuiHandler.class.getClassLoader()).getTopLevelClassesRecursive("logisticspipes.network.guis"));
        classes.sort(Comparator.comparing(ClassPath.ClassInfo::getSimpleName));
        guilist = new ArrayList<GuiProvider>(classes.size());
        guimap = new HashMap<Class<? extends GuiProvider>, GuiProvider>(classes.size());
        int currentid = 0;
        for (ClassPath.ClassInfo c : classes) {
            Class cls = c.load();
            GuiProvider instance = (GuiProvider)cls.getConstructors()[0].newInstance(currentid);
            guilist.add(instance);
            guimap.put(cls, instance);
            ++currentid;
        }
    }

    public static void openGui(GuiProvider guiProvider, EntityPlayer oPlayer) {
        if (!(oPlayer instanceof EntityPlayerMP)) {
            throw new UnsupportedOperationException("Gui can only be opened on the server side");
        }
        EntityPlayerMP player = (EntityPlayerMP)oPlayer;
        Container container = guiProvider.getContainer((EntityPlayer)player);
        if (container == null) {
            return;
        }
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        GUIPacket packet = PacketHandler.getPacket(GUIPacket.class);
        LPDataOutputStream data = new LPDataOutputStream();
        guiProvider.writeData(data);
        packet.setGuiID(guiProvider.getId());
        packet.setWindowID(windowId);
        packet.setGuiData(data.toByteArray());
        MainProxy.sendPacketToPlayer(packet, (EntityPlayer)player);
        player.field_71070_bA = container;
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((ICrafting)player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGui(GUIPacket packet, EntityPlayer player) {
        GuiContainer screen;
        int guiID = packet.getGuiID();
        GuiProvider provider = guilist.get(guiID).template();
        provider.readData(new LPDataInputStream(packet.getGuiData()));
        try {
            screen = (GuiContainer)provider.getClientGui(player);
        }
        catch (Exception e) {
            LogisticsPipes.log.error(packet.getClass().getName());
            LogisticsPipes.log.error(packet.toString());
            throw new RuntimeException(e);
        }
        screen.field_147002_h.field_75152_c = packet.getWindowID();
        FMLCommonHandler.instance().showGuiScreen((Object)screen);
    }
}

