/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.NbtBlockType;
import bq_standard.client.gui.tasks.PanelTaskBlockBreak;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskBlockBreak;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class TaskBlockBreak
extends TaskProgressableBase<int[]> {
    public final List<NbtBlockType> blockTypes = new ArrayList<NbtBlockType>();

    public TaskBlockBreak() {
        this.blockTypes.add(new NbtBlockType());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.blockTypes.clear();
        NBTTagList bList = nbt.func_150295_c("blocks", 10);
        for (int i = 0; i < bList.func_74745_c(); ++i) {
            NbtBlockType block = new NbtBlockType();
            block.readFromNBT(bList.func_150305_b(i));
            this.blockTypes.add(block);
        }
        if (nbt.func_150297_b("blockID", 8)) {
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("blockID"));
            targetBlock = targetBlock != Blocks.field_150350_a ? targetBlock : Blocks.field_150364_r;
            int targetMeta = nbt.func_74762_e("blockMeta");
            NBTTagCompound targetNbt = nbt.func_74775_l("blockNBT");
            int targetNum = nbt.func_74762_e("amount");
            NbtBlockType leg = new NbtBlockType();
            leg.b = targetBlock;
            leg.m = targetMeta;
            leg.tags = targetNbt;
            leg.n = targetNum;
            this.blockTypes.add(leg);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList bAry = new NBTTagList();
        for (NbtBlockType block : this.blockTypes) {
            bAry.func_74742_a((NBTBase)block.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("blocks", (NBTBase)bAry);
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.block_break";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskBlockBreak.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskBlockBreak(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, Map.Entry<UUID, IQuest> quest) {
        return null;
    }

    @Override
    public int[] getUsersProgress(UUID uuid) {
        int[] progress = (int[])this.userProgress.get(uuid);
        return progress == null || progress.length != this.blockTypes.size() ? new int[this.blockTypes.size()] : progress;
    }

    @Override
    public int[] readUserProgressFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("data", 9)) {
            int[] data = new int[this.blockTypes.size()];
            List<NBTBase> dNbt = NBTConverter.getTagList(nbt.func_150295_c("data", 3));
            for (int i = 0; i < data.length && i < dNbt.size(); ++i) {
                data[i] = ((NBTBase.NBTPrimitive)dNbt.get(i)).func_150287_d();
            }
            return data;
        }
        int[] data = nbt.func_74759_k("data");
        int[] progress = new int[this.blockTypes.size()];
        System.arraycopy(data, 0, progress, 0, Math.min(data.length, progress.length));
        return progress;
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, int[] progress) {
        nbt.func_74783_a("data", progress);
    }

    @Override
    public void detect(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        pInfo.ALL_UUIDS.forEach(uuid -> {
            if (this.isComplete((UUID)uuid)) {
                return;
            }
            int[] tmp = this.getUsersProgress((UUID)uuid);
            for (int i = 0; i < this.blockTypes.size(); ++i) {
                NbtBlockType block = this.blockTypes.get(i);
                if (block == null || tmp[i] >= block.n) continue;
                return;
            }
            this.setComplete((UUID)uuid);
        });
        pInfo.markDirtyParty(quest.getKey());
    }

    public void onBlockBreak(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest, Block block, int meta, int x, int y, int z) {
        TileEntity tile = block.hasTileEntity(meta) ? pInfo.PLAYER.field_70170_p.func_147438_o(x, y, z) : null;
        NBTTagCompound tags = null;
        if (tile != null) {
            tags = new NBTTagCompound();
            tile.func_145841_b(tags);
        }
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        boolean changed = false;
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            NbtBlockType targetBlock = this.blockTypes.get(i);
            int tmpMeta = targetBlock.m < 0 || targetBlock.m == Short.MAX_VALUE ? Short.MAX_VALUE : meta;
            boolean oreMatch = targetBlock.oreDict.length() > 0 && OreDictionary.getOres((String)targetBlock.oreDict).contains(new ItemStack(block, 1, tmpMeta));
            int index = i;
            if (!oreMatch && (block != targetBlock.b || targetBlock.m >= 0 && meta != targetBlock.m) || !ItemComparison.CompareNBTTag((NBTBase)targetBlock.tags, (NBTBase)tags, true)) continue;
            progress.forEach(entry -> {
                if (((int[])entry.func_76340_b())[index] >= targetBlock.n) {
                    return;
                }
                int[] nArray = (int[])entry.func_76340_b();
                int n = index;
                nArray[n] = nArray[n] + 1;
            });
            changed = true;
            break;
        }
        if (changed) {
            this.setBulkProgress(progress);
            this.detect(pInfo, quest);
        }
    }

    @Override
    public List<String> getTextsForSearch() {
        ArrayList<String> texts = new ArrayList<String>();
        for (NbtBlockType block : this.blockTypes) {
            if (block.getItemStack() == null) continue;
            texts.add(block.getItemStack().getBaseStack().func_82833_r());
        }
        return texts;
    }
}

