/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import com.gtnewhorizons.navigator.api.model.waypoints.WaypointManager;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class InteractableLayerManager
extends LayerManager {
    protected final Map<SupportedMods, WaypointManager> waypointManagers = new EnumMap<SupportedMods, WaypointManager>(SupportedMods.class);
    protected Waypoint activeWaypoint = null;

    public InteractableLayerManager(ButtonManager buttonManager) {
        super(buttonManager);
        for (SupportedMods mod : SupportedMods.values()) {
            WaypointManager waypointManager;
            if (!mod.isEnabled() || (waypointManager = this.addWaypointManager(this, mod)) == null) continue;
            this.waypointManagers.put(mod, waypointManager);
        }
    }

    @Nullable
    protected abstract LayerRenderer addLayerRenderer(InteractableLayerManager var1, SupportedMods var2);

    @Nullable
    protected WaypointManager addWaypointManager(InteractableLayerManager manager, SupportedMods mod) {
        return null;
    }

    public void updateElement(IWaypointAndLocationProvider location) {
    }

    @Override
    @Nullable
    protected final LayerRenderer addLayerRenderer(LayerManager manager, SupportedMods mod) {
        return this.addLayerRenderer(this, mod);
    }

    public void setActiveWaypoint(Waypoint waypoint) {
        this.activeWaypoint = waypoint;
        this.getVisibleLocations().forEach(element -> element.onWaypointUpdated(waypoint));
        this.waypointManagers.values().forEach(translator -> translator.updateActiveWaypoint(waypoint));
    }

    public void clearActiveWaypoint() {
        this.activeWaypoint = null;
        this.getVisibleLocations().forEach(IWaypointAndLocationProvider::onWaypointCleared);
        this.waypointManagers.values().forEach(WaypointManager::clearActiveWaypoint);
    }

    public boolean hasActiveWaypoint() {
        return this.activeWaypoint != null;
    }

    @Nullable
    public WaypointManager getWaypointManager(SupportedMods map) {
        return this.waypointManagers.get((Object)map);
    }

    @Override
    public final void updateElement(ILocationProvider location) {
        if (location instanceof IWaypointAndLocationProvider) {
            IWaypointAndLocationProvider waypointLoc = (IWaypointAndLocationProvider)location;
            if (this.hasActiveWaypoint()) {
                waypointLoc.onWaypointUpdated(this.activeWaypoint);
            }
            this.updateElement(waypointLoc);
        }
    }

    public Collection<IWaypointAndLocationProvider> getVisibleLocations() {
        return super.getVisibleLocations();
    }
}

