/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import cofh.api.energy.IEnergyContainerItem;
import de.keridos.floodlights.compatability.ModCompatibility;
import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityFLElectric;
import de.keridos.floodlights.util.GeneralUtil;
import de.keridos.floodlights.util.MathUtil;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class TileEntityElectricFloodlight
extends TileEntityFLElectric {
    public void func_145845_h() {
        World world = this.func_145831_w();
        if (ModCompatibility.IC2Loaded && !this.wasAddedToEnergyNet && !world.field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsage * (this.mode == 0 ? 1 : 2);
            if (this.inventory[0] != null) {
                if (ModCompatibility.IC2Loaded && this.inventory[0].func_77973_b() instanceof IElectricItem) {
                    double dischargeValue = ((double)this.storage.getMaxEnergyStored() - (double)this.storage.getEnergyStored()) / 8.0;
                    this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(8.0 * ElectricItem.manager.discharge(this.inventory[0], dischargeValue, 4, false, true, false)));
                }
                if (this.inventory[0].func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)this.inventory[0].func_77973_b();
                    int dischargeValue = Math.min(item.getEnergyStored(this.inventory[0]), this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
                    this.storage.modifyEnergyStored(item.extractEnergy(this.inventory[0], dischargeValue, false));
                }
            }
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                if (this.update) {
                    this.removeSource(this.mode);
                    this.addSource(this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientation().ordinal() + 6, 2);
                    this.update = false;
                } else if (!this.wasActive) {
                    this.addSource(this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) + 6, 2);
                }
                if (this.storageEU >= (double)realEnergyUsage / 8.0) {
                    this.storageEU -= (double)realEnergyUsage / 8.0;
                } else {
                    this.storage.modifyEnergyStored(-realEnergyUsage);
                }
                this.wasActive = true;
            } else if ((!this.active || this.storage.getEnergyStored() < realEnergyUsage && this.storageEU < (double)realEnergyUsage / 8.0) && this.wasActive) {
                this.removeSource(this.mode);
                world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 6, 2);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void addSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(false);
        } else if (mode == 1) {
            this.narrowConeSource(false);
        } else if (mode == 2) {
            this.wideConeSource(false);
        }
    }

    public void removeSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(true);
        } else if (mode == 1) {
            this.narrowConeSource(true);
        } else if (mode == 2) {
            this.wideConeSource(true);
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            int realEnergyUsage = ConfigHandler.energyUsage * (this.mode == 0 ? 1 : 2);
            this.removeSource(this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.active && (this.storage.getEnergyStored() >= realEnergyUsage || this.storageEU >= (double)realEnergyUsage / 8.0)) {
                this.addSource(this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((IChatComponent)new ChatComponentText(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

