/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.core;

import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WorldChunkManager.class})
public class MixinWorldChunkManager {
    @Shadow
    private BiomeCache field_76942_f;
    @Shadow
    private GenLayer field_76944_d;
    @Shadow
    private GenLayer field_76945_e;
    private World clientWorld = null;

    @Inject(method={"<init>(Lnet/minecraft/world/World;)V"}, at={@At(value="RETURN")})
    private void noCacheOnClient(World world, CallbackInfo ci) {
        if (world.field_72995_K) {
            this.field_76942_f = null;
            this.field_76944_d = null;
            this.field_76945_e = null;
            this.clientWorld = world;
        }
    }

    @Inject(method={"getBiomeGenAt(II)Lnet/minecraft/world/biome/BiomeGenBase;"}, at={@At(value="HEAD")}, cancellable=true)
    private void safelyGetClientBiome(int x, int z, CallbackInfoReturnable<BiomeGenBase> cir) {
        if (this.field_76942_f == null) {
            if (this.clientWorld != null) {
                cir.setReturnValue((Object)this.clientWorld.func_72807_a(x, z));
            } else {
                ArchaicLogger.LOGGER.warn("A mod attempted to retrieve a biome client-side via a WorldChunkManager without a client world reference. This is not safe. ArchaicFix has prevented a crash but some things may not work properly.");
                cir.setReturnValue((Object)BiomeGenBase.field_76771_b);
            }
        }
    }
}

