/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob;

import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.mob.util.IEndermanRenderer;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.util.BlockPosM;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMobAngryEnderman
extends EntityMob
implements IEndermanRenderer,
GlobalMobData.IIgnoreEnderGoo {
    private static final UUID aggroSpeedBoostID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier aggroSpeedBoost = new AttributeModifier(aggroSpeedBoostID, "Attacking speed boost", 7.4, 0).func_111168_a(false);
    private Entity lastEntityToAttack;
    private int teleportDelay = 0;

    public EntityMobAngryEnderman(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
    }

    public EntityMobAngryEnderman(World world, double x, double y, double z) {
        this(world);
        this.func_70634_a(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)1);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ModCommonProxy.opMobs ? 40.0 : 32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ModCommonProxy.opMobs ? 9.0 : 5.0);
    }

    protected Entity func_70782_k() {
        return this.field_70789_a;
    }

    public void func_70636_d() {
        block7: {
            block8: {
                if (this.func_70026_G()) {
                    this.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
                if (this.lastEntityToAttack != this.field_70789_a) {
                    IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
                    attributeinstance.func_111124_b(aggroSpeedBoost);
                    if (this.field_70789_a != null) {
                        attributeinstance.func_111121_a(aggroSpeedBoost);
                    }
                }
                this.lastEntityToAttack = this.field_70789_a;
                if (this.field_70789_a != null) {
                    this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
                }
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
                if (this.field_70170_p.field_72995_K || !this.func_70089_S()) break block7;
                if (this.field_70789_a == null) break block8;
                if (!(this.field_70789_a.func_70068_e((Entity)this) > 256.0) || this.teleportDelay++ < 30 || !this.teleportToEntity(this.field_70789_a)) break block7;
                this.teleportDelay = 0;
                break block7;
            }
            this.teleportDelay = 0;
            if (this.field_70146_Z.nextInt(30) == 0) {
                for (EntityPlayer player : this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(6.0, 4.0, 6.0))) {
                    if (player.field_71075_bZ.field_75098_d) continue;
                    this.field_70789_a = player;
                    break;
                }
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected boolean teleportRandomly() {
        return this.teleportTo(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0, this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0);
    }

    protected boolean teleportToEntity(Entity entity) {
        Vec3 targVec = Vec3.func_72443_a((double)(this.field_70165_t - entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e()), (double)(this.field_70161_v - entity.field_70161_v)).func_72432_b();
        double dist = 16.0;
        return this.teleportTo(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targVec.field_72450_a * dist, this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - targVec.field_72448_b * dist, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - targVec.field_72449_c * dist);
    }

    protected boolean teleportTo(double x, double y, double z) {
        double origX = this.field_70165_t;
        double origY = this.field_70163_u;
        double origZ = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean wasTeleported = false;
        BlockPosM tmpPos = BlockPosM.tmp((Entity)this);
        if (this.field_70170_p.func_72899_e(tmpPos.x, tmpPos.y, tmpPos.z)) {
            boolean found = false;
            while (!found && tmpPos.y > 0) {
                if (tmpPos.moveDown().getMaterial((IBlockAccess)this.field_70170_p).func_76230_c()) {
                    found = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
            }
            if (found) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    wasTeleported = true;
                }
            }
        }
        if (!wasTeleported) {
            this.func_70107_b(origX, origY, origZ);
            return false;
        }
        int dist = 128;
        for (int i = 0; i < dist; ++i) {
            double prog = (double)i / ((double)dist - 1.0);
            this.field_70170_p.func_72869_a("portal", origX + (this.field_70165_t - origX) * prog + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, origY + (this.field_70163_u - origY) * prog + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, origZ + (this.field_70161_v - origZ) * prog + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0, (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f));
        }
        this.field_70170_p.func_72908_a(origX, origY, origZ, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return Baconizer.soundNormal(this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle");
    }

    protected String func_70621_aR() {
        return Baconizer.soundNormal("mob.endermen.hit");
    }

    protected String func_70673_aS() {
        return Baconizer.soundDeath("mob.endermen.death");
    }

    protected Item func_146068_u() {
        return Items.field_151079_bi;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        Item item = this.func_146068_u();
        if (item != null) {
            int amount = this.field_70146_Z.nextInt(2 + looting);
            for (int a = 0; a < amount; ++a) {
                this.func_145779_a(item, 1);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.setScreaming(true);
        if (source instanceof EntityDamageSourceIndirect && this.field_70789_a == null) {
            for (int attempt = 0; attempt < 64; ++attempt) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        if (super.func_70097_a(source, amount)) {
            CausatumUtils.increase(source, CausatumMeters.END_MOB_DAMAGE, amount * 0.5f);
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.field_76574_g == 1 && this.field_70170_p.func_82737_E() - EntityBossDragon.lastUpdate < 20L && source.func_76346_g() instanceof EntityPlayer) {
            for (Object o : this.field_70170_p.field_72996_f) {
                if (!(o instanceof EntityBossDragon)) continue;
                ((EntityBossDragon)o).achievements.onPlayerKilledEnderman((EntityPlayer)source.func_76346_g());
                break;
            }
        }
        super.func_70645_a(source);
    }

    @Override
    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    public void setScreaming(boolean isScreaming) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(isScreaming ? 1 : 0)));
    }

    protected boolean func_70814_o() {
        return this.field_70170_p.field_73011_w.field_76574_g == 1 ? true : super.func_70814_o();
    }

    public void setCanDespawn(boolean canDespawn) {
        this.field_70180_af.func_75692_b(19, (Object)((byte)(!canDespawn ? 1 : 0)));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("canDespawn", this.field_70180_af.func_75683_a(19) == 0);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setCanDespawn(nbt.func_74767_n("canDespawn"));
    }

    protected void func_70623_bb() {
        if (this.field_70180_af.func_75683_a(19) == 0) {
            super.func_70623_bb();
        }
    }

    @Override
    public boolean isCarrying() {
        return false;
    }

    @Override
    public ItemStack getCarrying() {
        return null;
    }

    public String func_70005_c_() {
        return this.func_94056_bM() ? this.func_94057_bL() : StatCollector.func_74838_a((String)Baconizer.mobName("entity.angryEnderman.name"));
    }
}

