/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.render.texture.TextureBiomeCompass;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.util.IslandSpawnChecker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class ItemBiomeCompass
extends Item {
    @SideOnly(value=Side.CLIENT)
    public static List<Set<ChunkCoordinates>> locations;
    @SideOnly(value=Side.CLIENT)
    public static byte currentBiome;
    @SideOnly(value=Side.CLIENT)
    private static int lastSavedX;
    @SideOnly(value=Side.CLIENT)
    private static int lastSavedZ;

    public void func_77663_a(ItemStack is, World world, Entity entity, int slot, boolean isHeld) {
        if (world.field_72995_K) {
            if (is.func_77942_o() && entity instanceof EntityPlayer) {
                currentBiome = is.func_77978_p().func_74771_c("curBiome");
                if (lastSavedX == Integer.MAX_VALUE && lastSavedZ == Integer.MAX_VALUE) {
                    long seed1 = is.func_77978_p().func_74763_f("seed1");
                    int seed2 = is.func_77978_p().func_74762_e("seed2");
                    for (int x = entity.field_70176_ah - 96; x <= entity.field_70176_ah + 96; ++x) {
                        for (int z = entity.field_70164_aj - 96; z <= entity.field_70164_aj + 96; ++z) {
                            byte biome = IslandSpawnChecker.getIslandBiomeAt(x, z, seed1, seed2);
                            if (biome == -1) continue;
                            locations.get(biome).add(new ChunkCoordinates(x * 16 + 104, 0, z * 16 + 104));
                        }
                    }
                    lastSavedX = entity.field_70176_ah;
                    lastSavedZ = entity.field_70164_aj;
                } else if ((float)(MathUtil.square(entity.field_70176_ah - lastSavedX) + MathUtil.square(entity.field_70164_aj - lastSavedZ)) > 250.0f) {
                    lastSavedZ = Integer.MAX_VALUE;
                    lastSavedX = Integer.MAX_VALUE;
                }
            }
        } else {
            int seed2;
            NBTTagCompound nbt;
            EntityPlayerMP player;
            if (entity instanceof EntityPlayerMP && !(player = (EntityPlayerMP)entity).func_147099_x().func_77443_a((Achievement)AchievementManager.BIOME_COMPASS)) {
                player.func_71064_a((StatBase)AchievementManager.BIOME_COMPASS, 1);
            }
            if (!(nbt = ItemUtil.getTagRoot(is, true)).func_74764_b("seed1")) {
                nbt.func_74772_a("seed1", world.func_72905_C());
                nbt.func_74777_a("seed2", (short)(1 + ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount()));
            } else if (isHeld && entity.field_71093_bK == 1 && entity.field_70173_aa % 100 == 0 && (seed2 = 1 + ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).getDragonDeathAmount()) != nbt.func_74765_d("seed2")) {
                nbt.func_74777_a("seed2", (short)seed2);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        byte biome = ItemUtil.getTagRoot(is, true).func_74771_c("curBiome");
        if ((biome = (byte)(biome + 1)) >= IslandBiomeBase.biomeList.size()) {
            biome = 0;
        }
        is.func_77978_p().func_74774_a("curBiome", biome);
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = new TextureBiomeCompass("hardcoreenderexpansion:biome_compass");
        ((TextureMap)iconRegister).setTextureEntry("hardcoreenderexpansion:biome_compass", (TextureAtlasSprite)this.field_77791_bV);
        locations = new ArrayList<Set<ChunkCoordinates>>(IslandBiomeBase.biomeList.size());
        for (int a = 0; a < IslandBiomeBase.biomeList.size(); ++a) {
            locations.add(a, new HashSet());
        }
        lastSavedZ = Integer.MAX_VALUE;
        lastSavedX = Integer.MAX_VALUE;
    }
}

