/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.glease.ggfab.GGItemList;
import net.glease.ggfab.api.GGFabRecipeMaps;
import net.glease.ggfab.api.GigaGramFabAPI;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

class SingleUseToolRecipeLoader
implements Runnable {
    SingleUseToolRecipeLoader() {
    }

    @Override
    public void run() {
        ToolDictNames[] hardTools = new ToolDictNames[]{ToolDictNames.craftingToolHardHammer, ToolDictNames.craftingToolScrewdriver, ToolDictNames.craftingToolWrench, ToolDictNames.craftingToolCrowbar, ToolDictNames.craftingToolWireCutter, ToolDictNames.craftingToolFile};
        ToolDictNames[] softTools = new ToolDictNames[]{ToolDictNames.craftingToolSoftHammer};
        this.addSingleUseToolRecipe(Materials.Steel, hardTools);
        this.addSingleUseToolRecipe(Materials.Silver, 5000, hardTools);
        this.addSingleUseToolRecipe(Materials.VanadiumSteel, hardTools);
        this.addSingleUseToolRecipe(Materials.TungstenSteel, hardTools);
        this.addSingleUseToolRecipe(Materials.HSSG, hardTools);
        this.addSingleUseToolRecipe(Materials.Rubber, softTools);
        this.addSingleUseToolRecipe(Materials.StyreneButadieneRubber, softTools);
        this.addSingleUseToolRecipe(Materials.Polybenzimidazole, softTools);
        String prefix = "Shape_One_Use_";
        for (GGItemList value : GGItemList.values()) {
            if (!value.name().startsWith(prefix)) continue;
            ToolDictNames type = ToolDictNames.valueOf((String)value.name().substring(prefix.length()));
            GT_ModHandler.addCraftingRecipe((ItemStack)value.get(1L, new Object[0]), (Object[])new Object[]{"h", "P", "I", Character.valueOf('P'), ItemList.Shape_Empty, Character.valueOf('I'), type});
        }
    }

    private void addSingleUseToolRecipe(Materials material, ToolDictNames ... types) {
        this.addSingleUseToolRecipe(material, 10000, types);
    }

    private static long findNiceFactor(long fluids, long count) {
        long end = Math.min(fluids, count);
        for (long i = count / 256L; i < end; ++i) {
            if (fluids % i != 0L || count % i != 0L || count / i >= 256L) continue;
            return i;
        }
        return -1L;
    }

    private void addSingleUseToolRecipe(Materials material, int outputModifier, ToolDictNames ... types) {
        if (material.mStandardMoltenFluid == null) {
            throw new IllegalArgumentException("material does not have molten fluid form");
        }
        for (ToolDictNames type : types) {
            IToolStats stats = GigaGramFabAPI.SINGLE_USE_TOOLS.get(type);
            Long cost = GigaGramFabAPI.COST_SINGLE_USE_TOOLS.get(type);
            if (stats == null || cost == null) {
                throw new IllegalArgumentException(type + " not registered");
            }
            long fluids = cost * 144L / 3628800L;
            long duration = 120L;
            long count = (long)((float)material.mDurability * stats.getMaxDurabilityMultiplier() * (float)outputModifier * 100.0f / (float)stats.getToolDamagePerContainerCraft() / 10000.0f);
            if (count > 256L) {
                long niceFactor = SingleUseToolRecipeLoader.findNiceFactor(fluids, count);
                if (niceFactor < 0L) {
                    double mod = (double)count / 256.0;
                    fluids = Math.max((long)((double)fluids / mod), 1L);
                    duration = Math.max((long)((double)duration / mod), 1L);
                    count = 256L;
                } else {
                    fluids /= niceFactor;
                    duration = Math.max(duration / niceFactor, 1L);
                    count /= niceFactor;
                }
            } else if (count < 128L) {
                long mod = GT_Utility.ceilDiv((long)128L, (long)count);
                fluids *= mod;
                duration *= mod;
                count *= mod;
            }
            GT_Values.RA.stdBuilder().fluidInputs(new FluidStack[]{material.getMolten(fluids)}).metadata(GGFabRecipeMaps.OUTPUT_TYPE, (Object)type).metadata(GGFabRecipeMaps.OUTPUT_COUNT, (Object)((int)count)).eut(TierEU.RECIPE_MV).duration(duration).addTo(GGFabRecipeMaps.toolCastRecipes);
        }
    }
}

