/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Objects;
import speiger.src.collections.longs.collections.LongCollection;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.functions.LongConsumer;
import speiger.src.collections.longs.utils.LongArrays;
import speiger.src.collections.longs.utils.LongIterators;

public abstract class AbstractLongCollection
extends AbstractCollection<Long>
implements LongCollection {
    @Override
    public abstract LongIterator iterator();

    @Override
    @Deprecated
    public boolean add(Long e) {
        return LongCollection.super.add(e);
    }

    @Override
    public boolean addAll(LongCollection c) {
        boolean modified = false;
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= ((AbstractCollection)this).add(iter.nextLong());
        }
        return modified;
    }

    @Override
    public LongCollection copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean contains(Object e) {
        return LongCollection.super.contains(e);
    }

    @Override
    public boolean contains(long e) {
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextLong() != e) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Long> c) {
        return c instanceof LongCollection ? this.addAll((LongCollection)c) : super.addAll(c);
    }

    @Override
    public boolean containsAll(LongCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return true;
        }
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c instanceof LongCollection ? this.containsAll((LongCollection)c) : super.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean containsAny(Collection<?> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        for (Object e : c) {
            if (!this.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(LongCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        LongIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.contains(iter.nextLong())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean remove(Object e) {
        return LongCollection.super.remove(e);
    }

    @Override
    public boolean remLong(long e) {
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextLong() != e) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(LongCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!c.contains(iter.nextLong())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(LongCollection c, LongConsumer r) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(r);
        boolean modified = false;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            long e = iter.nextLong();
            if (!c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(LongCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        boolean modified = false;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.nextLong())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(LongCollection c, LongConsumer r) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(r);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.forEach(r);
            this.clear();
            return modified;
        }
        boolean modified = false;
        LongIterator iter = this.iterator();
        while (iter.hasNext()) {
            long e = iter.nextLong();
            if (c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public long[] toLongArray() {
        if (this.isEmpty()) {
            return LongArrays.EMPTY_ARRAY;
        }
        return this.toLongArray(new long[this.size()]);
    }

    @Override
    public long[] toLongArray(long[] a) {
        if (a == null || a.length < this.size()) {
            a = new long[this.size()];
        }
        LongIterators.unwrap(a, this.iterator());
        if (a.length > this.size()) {
            a[this.size()] = 0L;
        }
        return a;
    }
}

