/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.archaicfix.asm.Mixin;
import org.embeddedt.archaicfix.asm.TargetedMod;
import org.embeddedt.archaicfix.asm.transformer.VampirismTransformer;
import org.embeddedt.archaicfix.config.ArchaicConfig;
import org.embeddedt.archaicfix.config.ConfigException;
import org.embeddedt.archaicfix.config.ConfigurationManager;
import org.embeddedt.archaicfix.helpers.LetsEncryptHelper;

@IFMLLoadingPlugin.Name(value="ArchaicCore")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class ArchaicCore
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"ArchaicCore");
    public static Set<TargetedMod> coreMods;
    private static final ImmutableMap<String, TargetedMod> MODS_BY_CLASS;

    public String[] getASMTransformerClass() {
        return new String[]{"org.embeddedt.archaicfix.asm.ArchaicTransformer"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.archaicfix.early.json";
    }

    private static void detectCoreMods(Set<String> loadedCoreMods) {
        MODS_BY_CLASS.forEach((key, value) -> {
            if (loadedCoreMods.contains(key)) {
                coreMods.add((TargetedMod)((Object)value));
            }
        });
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        ArchaicCore.detectCoreMods(loadedCoreMods);
        LOGGER.info("Detected coremods: [" + coreMods.stream().map(Enum::name).collect(Collectors.joining(", ")) + "]");
        for (Mixin mixin : Mixin.values()) {
            if (mixin.getPhase() != Mixin.Phase.EARLY || !mixin.shouldLoadSide() || !mixin.getFilter().test(coreMods)) continue;
            mixins.add(mixin.getMixin());
        }
        return mixins;
    }

    static {
        VampirismTransformer.init();
        try {
            ConfigurationManager.registerConfig(ArchaicConfig.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        LetsEncryptHelper.replaceSSLContext();
        coreMods = new HashSet<TargetedMod>();
        MODS_BY_CLASS = ImmutableMap.builder().put((Object)"optifine.OptiFineForgeTweaker", (Object)TargetedMod.OPTIFINE).put((Object)"fastcraft.Tweaker", (Object)TargetedMod.FASTCRAFT).put((Object)"cofh.asm.LoadingPlugin", (Object)TargetedMod.COFHCORE).build();
    }
}

