/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesPermissions;
import serverutils.data.Leaderboard;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageLeaderboardResponse;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageLeaderboard
extends MessageToServer {
    private ResourceLocation id;

    public MessageLeaderboard() {
    }

    public MessageLeaderboard(ResourceLocation _id) {
        this.id = _id;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.STATS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeResourceLocation(this.id);
    }

    @Override
    public void readData(DataIn data) {
        this.id = data.readResourceLocation();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        Leaderboard leaderboard = ServerUtilitiesCommon.LEADERBOARDS.get(this.id);
        if (leaderboard != null && PermissionAPI.hasPermission((EntityPlayer)player, ServerUtilitiesPermissions.getLeaderboardNode(leaderboard))) {
            new MessageLeaderboardResponse(player, leaderboard).sendTo(player);
        }
    }
}

