/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.IconProperties;
import serverutils.lib.icon.MutableColor4I;

public class BulletIcon
extends Icon {
    private static final MutableColor4I DEFAULT_COLOR = Color4I.rgb(0xEDEDED).mutable();
    private static final MutableColor4I DEFAULT_COLOR_B = Color4I.rgb(0xFFFFFF).mutable();
    private static final MutableColor4I DEFAULT_COLOR_D = Color4I.rgb(0xDDDDDD).mutable();
    private Color4I color = EMPTY;
    private Color4I colorB = EMPTY;
    private Color4I colorD = EMPTY;
    private boolean inverse = false;

    @Override
    public BulletIcon copy() {
        BulletIcon icon = new BulletIcon();
        icon.color = this.color;
        icon.colorB = this.colorB;
        icon.colorD = this.colorD;
        icon.inverse = this.inverse;
        return icon;
    }

    public BulletIcon setColor(Color4I col) {
        this.color = col;
        if (this.color.isEmpty()) {
            return this;
        }
        MutableColor4I c = this.color.mutable();
        c.addBrightness(18);
        this.colorB = c.copy();
        c = this.color.mutable();
        c.addBrightness(-18);
        this.colorD = c.copy();
        return this;
    }

    @Override
    public BulletIcon withColor(Color4I col) {
        return this.copy().setColor(col);
    }

    @Override
    public BulletIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    public BulletIcon setInverse(boolean v) {
        this.inverse = v;
        return this;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.inverse = properties.getBoolean("inverse", this.inverse);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        Color4I cd;
        Color4I cb;
        Color4I c;
        if (this.color.isEmpty()) {
            c = DEFAULT_COLOR;
            cb = DEFAULT_COLOR_B;
            cd = DEFAULT_COLOR_D;
        } else {
            c = this.color;
            cb = this.colorB;
            cd = this.colorD;
        }
        GlStateManager.disableTexture2D();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GuiHelper.addRectToBuffer(tessellator, x, y + 1, 1, h - 2, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(tessellator, x + w - 1, y + 1, 1, h - 2, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(tessellator, x + 1, y, w - 2, 1, this.inverse ? cd : cb);
        GuiHelper.addRectToBuffer(tessellator, x + 1, y + h - 1, w - 2, 1, this.inverse ? cb : cd);
        GuiHelper.addRectToBuffer(tessellator, x + 1, y + 1, w - 2, h - 2, c);
        tessellator.func_78381_a();
        GlStateManager.enableTexture2D();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public JsonElement getJson() {
        JsonObject o = new JsonObject();
        o.addProperty("id", "bullet");
        if (!this.color.isEmpty()) {
            o.add("color", this.color.getJson());
        }
        return o;
    }
}

