/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.backups.Backups;
import serverutils.command.CmdShutdown;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.events.universe.UniverseClearCacheEvent;
import serverutils.lib.EnumMessageLocation;
import serverutils.lib.config.ConfigEnum;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.data.Universe;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.lib.util.text_components.Notification;
import serverutils.lib.util.text_components.TextComponentParser;
import serverutils.net.MessageUpdatePlayTime;
import serverutils.ranks.Ranks;

public class ServerUtilitiesServerEventHandler {
    public static final ServerUtilitiesServerEventHandler INST = new ServerUtilitiesServerEventHandler();
    private static final ResourceLocation AFK_ID = new ResourceLocation("serverutilities", "afk");
    private static final Pattern STRIKETHROUGH_PATTERN = Pattern.compile("\\~\\~(.*?)\\~\\~");
    private static final String STRIKETHROUGH_REPLACE = "&m$1&m";
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.*?)\\*\\*|__(.*?)__");
    private static final String BOLD_REPLACE = "&l$1$2&l";
    private static final Pattern ITALIC_PATTERN = Pattern.compile("\\*(.*?)\\*|_(.*?)_");
    private static final String ITALIC_REPLACE = "&o$1$2&o";

    @SubscribeEvent
    public void onCacheCleared(UniverseClearCacheEvent event) {
        if (Ranks.INSTANCE != null) {
            Ranks.INSTANCE.clearCache();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerChatEvent(ServerChatEvent event) {
        if (!ServerUtilitiesConfig.ranks.override_chat || !Ranks.isActive()) {
            return;
        }
        EntityPlayerMP player = event.player;
        if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.chat.speak") || NBTUtils.getPersistedData((EntityPlayer)player, false).func_74767_n("muted")) {
            player.func_146105_b(StringUtils.color(ServerUtilities.lang((ICommandSender)player, "commands.mute.muted", new Object[0]), EnumChatFormatting.RED));
            event.setCanceled(true);
            return;
        }
        ChatComponentText main = new ChatComponentText("");
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)player));
        main.func_150257_a(data.getNameForChat(player));
        String message = event.message.trim();
        boolean b = false;
        if (!message.contains("https://") && !message.contains("http://") && PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.chat.formatting")) {
            for (Map.Entry<String, String> entry : ServerUtilitiesCommon.KAOMOJIS.entrySet()) {
                message = message.replace(entry.getValue(), "<emoji:" + entry.getKey() + ">");
            }
            b = !message.equals(message = STRIKETHROUGH_PATTERN.matcher(message).replaceAll(STRIKETHROUGH_REPLACE)) | b;
            String string = message;
            message = BOLD_PATTERN.matcher(message).replaceAll(BOLD_REPLACE);
            b = !string.equals(message) | b;
            String string2 = message;
            message = ITALIC_PATTERN.matcher(message).replaceAll(ITALIC_REPLACE);
            b = !string2.equals(message) | b;
            for (Map.Entry<String, String> entry : ServerUtilitiesCommon.KAOMOJIS.entrySet()) {
                message = message.replace("<emoji:" + entry.getKey() + ">", entry.getValue());
            }
        }
        IChatComponent text = b ? TextComponentParser.parse(message, null) : ForgeHooks.newChatWithLinks((String)message);
        EnumChatFormatting colortf = (EnumChatFormatting)((ConfigEnum)RankConfigAPI.get(player, "serverutilities.chat.text.color")).getValue();
        if (colortf != EnumChatFormatting.WHITE) {
            text.func_150256_b().func_150238_a(colortf);
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "serverutilities.chat.text.bold", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150227_a(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "serverutilities.chat.text.italic", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150217_b(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "serverutilities.chat.text.underlined", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "serverutilities.chat.text.strikethrough", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150225_c(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "serverutilities.chat.text.obfuscated", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150237_e(Boolean.valueOf(true));
        }
        main.func_150257_a(text);
        event.component = new ChatComponentTranslation("serverutilities.chat.format", new Object[]{main});
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        long now = System.currentTimeMillis();
        if (event.phase == TickEvent.Phase.START) {
            if (ClaimedChunks.isActive()) {
                ClaimedChunks.instance.update(universe, now);
            }
        } else {
            EntityPlayerMP playerToKickForAfk = null;
            boolean afkEnabled = ServerUtilitiesConfig.afk.isEnabled(universe.server);
            for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
                long maxTime;
                boolean isAFK;
                if (ServerUtils.isFake(player)) continue;
                boolean fly = player.field_71075_bZ.field_75101_c;
                if (!player.field_71075_bZ.field_75098_d && NBTUtils.getPersistedData((EntityPlayer)player, false).func_74767_n("fly")) {
                    player.field_71075_bZ.field_75101_c = true;
                }
                if (fly != player.field_71075_bZ.field_75101_c) {
                    player.func_71016_p();
                }
                if (!afkEnabled) continue;
                ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player));
                boolean prevIsAfk = data.afkTime >= ServerUtilitiesConfig.afk.getNotificationTimer();
                data.afkTime = System.currentTimeMillis() - player.func_154331_x();
                boolean bl = isAFK = data.afkTime >= ServerUtilitiesConfig.afk.getNotificationTimer();
                if (prevIsAfk != isAFK) {
                    for (EntityPlayerMP player1 : universe.server.func_71203_ab().field_72404_b) {
                        EnumMessageLocation location = ServerUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player1)).getAFKMessageLocation();
                        if (location == EnumMessageLocation.OFF) continue;
                        IChatComponent component = ServerUtilities.lang((ICommandSender)player1, isAFK ? "permission.serverutilities.afk.timer.is_afk" : "permission.serverutilities.afk.timer.isnt_afk", player.getDisplayName());
                        component.func_150256_b().func_150238_a(EnumChatFormatting.GRAY);
                        if (location == EnumMessageLocation.CHAT) {
                            player1.func_145747_a(component);
                            continue;
                        }
                        Notification.of(AFK_ID, component).send(universe.server, (EntityPlayer)player1);
                    }
                    ServerUtilities.LOGGER.info(player.getDisplayName() + (isAFK ? " is now AFK" : " is no longer AFK"));
                }
                if (playerToKickForAfk != null || (maxTime = RankConfigAPI.get(player.field_71133_b, player.func_146103_bH(), "serverutilities.afk.timer").getTimer().millis()) <= 0L || data.afkTime < maxTime) continue;
                playerToKickForAfk = player;
            }
            if (playerToKickForAfk != null && playerToKickForAfk.field_71135_a != null) {
                playerToKickForAfk.field_71135_a.func_147231_a((IChatComponent)new ChatComponentTranslation("multiplayer.disconnect.idling", new Object[0]));
            }
            if (ServerUtilitiesUniverseData.shutdownTime > 0L && ServerUtilitiesUniverseData.shutdownTime - now <= 0L) {
                CmdShutdown.shutdown(universe.server);
            }
            if (Backups.nextBackup > 0L && Backups.nextBackup <= now) {
                Backups.run(null, "");
            }
            if (Backups.thread != null && Backups.thread.isDone) {
                Backups.thread = null;
                Backups.postBackup();
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.START && event.world.field_73011_w.field_76574_g == ServerUtilitiesConfig.world.spawn_dimension) {
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_time != -1) {
                event.world.func_72877_b((long)ServerUtilitiesConfig.world.forced_spawn_dimension_time);
            }
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_weather != -1) {
                event.world.func_72912_H().func_76084_b(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 1);
                event.world.func_72912_H().func_76069_a(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 2);
            }
            if (ServerUtilitiesConfig.world.show_playtime && event.world.func_82737_E() % 20L == 7L) {
                for (EntityPlayer player : event.world.field_73010_i) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    new MessageUpdatePlayTime(playerMP.func_147099_x().func_77444_a(StatList.field_75948_k)).sendTo(playerMP);
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerChatEventLog(ServerChatEvent event) {
        if (ServerUtilitiesConfig.world.logging.chat_enable) {
            ServerUtilitiesUniverseData.chatLog(String.format("From %s: %s", event.username, event.message));
        }
    }
}

