/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EntityWirelessTracker
extends Entity
implements WirelessTransmittingDevice {
    String attachedPlayerName;
    boolean attached;
    boolean item;
    float attachedX;
    float attachedY;
    float attachedZ;
    float attachedYaw;
    int attachmentCounter = 2;
    int freq;
    boolean loaded;
    public Entity attachedEntity;
    public static final double torad = 0.017453;
    public static final double todeg = 57.295779;

    public EntityWirelessTracker(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityWirelessTracker(World world, int freq) {
        this(world);
        this.freq = freq;
    }

    public EntityWirelessTracker(World world, int freq, EntityLivingBase entityliving) {
        this(world, freq);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        float speed = 1.3f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * speed;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f)) * speed;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f)) * speed;
        this.freq = freq;
    }

    protected void func_70088_a() {
    }

    public boolean func_70112_a(double d) {
        return true;
    }

    public void func_70030_z() {
        if (this.attachmentCounter < -6000 && !this.attached || !this.field_70170_p.field_72995_K && this.attachedInOtherDimension()) {
            this.func_70106_y();
            return;
        }
        if (!this.loaded && !this.field_70170_p.field_72995_K) {
            this.loaded = true;
            RedstoneEtherAddons.server().addTracker(this);
            if (!this.attachedToLogout()) {
                RedstoneEther.server().addTransmittingDevice(this);
            }
        }
        this.field_70121_D.func_72328_c(this.field_70121_D.func_72314_b(0.0, 0.2, 0.0));
        super.func_70030_z();
        this.field_70121_D.func_72328_c(this.field_70121_D.func_72314_b(0.0, -0.2, 0.0));
        if (this.attached && this.attachedEntity == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.findAttachedEntity();
            }
        } else if (this.isAttachedToEntity()) {
            this.trackEntity();
            if (!this.field_70170_p.field_72995_K) {
                this.checkDetachment();
            }
        } else {
            this.applyPhysics();
            this.moveEntityWithBounce(1.0);
            if (!this.field_70170_p.field_72995_K) {
                this.attachToNearbyEntities();
            }
        }
        if (this.item && this.attachmentCounter == 0) {
            this.item = false;
            if (!this.field_70170_p.field_72995_K) {
                RedstoneEtherAddons.server().updateTracker(this);
            }
        }
        if (this.func_70027_ad()) {
            this.func_70066_B();
            if (!this.field_70170_p.field_72995_K) {
                RedstoneEtherAddons.server().updateTracker(this);
            }
            this.item = true;
            this.attachmentCounter = 1200;
        }
        if (!this.attachedToLogout()) {
            --this.attachmentCounter;
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource == DamageSource.field_76371_c || par1DamageSource == DamageSource.field_76380_i) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            RedstoneEther.server().removeTransmittingDevice(this);
            RedstoneEtherAddons.server().removeTracker(this);
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.item && par1EntityPlayer.field_71071_by.func_70441_a(new ItemStack((Item)WirelessRedstoneAddons.tracker, 1, this.freq))) {
            this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            par1EntityPlayer.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    private void checkDetachment() {
        int z;
        int y;
        int x;
        if (this.attachedEntity.field_70128_L && this.attachedPlayerName != null) {
            this.attachedEntity = null;
            RedstoneEther.server().removeTransmittingDevice(this);
            return;
        }
        if (this.attachedEntity.func_70027_ad() || this.attachedEntity.field_70128_L) {
            this.detachFromEntity();
        }
        if (this.isRetractingStickyPistonFacing(x = MathHelper.func_76128_c((double)this.field_70165_t), (y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)(this.field_70131_O / 2.0f)))) + 2, z = MathHelper.func_76128_c((double)this.field_70161_v), 0) || this.isRetractingStickyPistonFacing(x, y - 2, z, 1) || this.isRetractingStickyPistonFacing(x, y, z + 2, 2) || this.isRetractingStickyPistonFacing(x, y, z - 2, 3) || this.isRetractingStickyPistonFacing(x + 2, y, z, 4) || this.isRetractingStickyPistonFacing(x - 2, y, z, 5)) {
            this.detachFromEntity();
        }
    }

    public boolean isRetractingStickyPistonFacing(int x, int y, int z, int facing) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block != Blocks.field_150326_M) {
            return false;
        }
        TileEntity t = this.field_70170_p.func_147438_o(x, y, z);
        if (!(t instanceof TileEntityPiston)) {
            return false;
        }
        TileEntityPiston tep = (TileEntityPiston)t;
        return tep.func_145864_c() == facing && !tep.func_145868_b() && tep.func_145861_a() == Blocks.field_150320_F;
    }

    private void detachFromEntity() {
        this.attachedEntity = null;
        this.attached = false;
        this.attachedX = 0.0f;
        this.attachedY = 0.0f;
        this.attachedZ = 0.0f;
        this.attachedYaw = 0.0f;
        this.attachmentCounter = 5;
        this.attachedPlayerName = null;
        this.field_70159_w = (double)this.field_70146_Z.nextFloat() - 0.5;
        this.field_70181_x = (double)this.field_70146_Z.nextFloat() - 0.5;
        this.field_70179_y = (double)this.field_70146_Z.nextFloat() - 0.5;
        RedstoneEtherAddons.server().updateTracker(this);
    }

    private void trackEntity() {
        Vector3 relPos = this.getRotatedAttachment();
        this.func_70107_b(this.attachedEntity.field_70165_t + relPos.x, this.attachedEntity.field_70163_u + (double)(this.attachedEntity.field_70131_O / 2.0f) - (double)this.attachedEntity.field_70129_M + relPos.y - (double)this.field_70131_O, this.attachedEntity.field_70161_v + relPos.z);
    }

    private void applyPhysics() {
        this.field_70181_x -= 0.05;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        }
        this.func_145771_j(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
    }

    private void attachToNearbyEntities() {
        if (this.isAttachedToEntity() || this.item || this.attachmentCounter > 0) {
            return;
        }
        for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)-10.0, (double)-10.0, (double)-10.0, (double)10.0, (double)10.0, (double)10.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            AxisAlignedBB bb = entity.field_70121_D;
            if (bb == null || !((double)entity.field_70130_N >= 0.3) || !this.tryAttach(entity, 0.4, 0.2)) continue;
            return;
        }
    }

    private boolean tryAttach(Entity entity, double extraw, double extrah) {
        Vector3 evec = Vector3.fromEntityCenter((Entity)entity);
        Vector3 posVec = new Vector3(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
        Vector3 lastPosVec = new Vector3(this.field_70142_S, this.field_70137_T + (double)(this.field_70131_O / 2.0f), this.field_70136_U);
        Vector3 diffVec = lastPosVec.copy().subtract(posVec);
        double distanceBetweenTicks = diffVec.mag();
        double width = (double)entity.field_70130_N + extraw;
        double height = (double)entity.field_70131_O + extrah;
        for (double d = 0.0; d <= distanceBetweenTicks; d += 0.05) {
            Vector3 interpVec = diffVec.copy().normalize().multiply(d).add(lastPosVec);
            double xDiff = Math.abs(evec.x - interpVec.x);
            double yDiff = Math.abs(evec.y - interpVec.y);
            double zDiff = Math.abs(evec.z - interpVec.z);
            if (!(yDiff <= height / 2.0) || !(xDiff <= width / 2.0) || !(zDiff <= width / 2.0)) continue;
            this.attachToEntity(interpVec, entity);
            return true;
        }
        return false;
    }

    public void attachToEntity(Vector3 pos, Entity e) {
        this.attached = true;
        this.attachedEntity = e;
        this.attachedX = (float)(pos.x - e.field_70165_t);
        this.attachedY = (float)(pos.y + (double)(this.field_70131_O / 2.0f) - (e.field_70163_u - (double)e.field_70129_M + (double)(e.field_70131_O / 2.0f)));
        this.attachedZ = (float)(pos.z - e.field_70161_v);
        this.attachedYaw = this.getEntityRotation();
        if (this.attachedEntity instanceof EntityPlayer) {
            this.attachedPlayerName = this.attachedEntity.func_70005_c_();
        }
        this.moveToEntityExterior();
        RedstoneEtherAddons.server().updateTracker(this);
    }

    private void moveToEntityExterior() {
        Vector3 attachPosVec2 = this.getRotatedAttachment().normalize().multiply((double)Math.max(this.attachedEntity.field_70130_N, this.attachedEntity.field_70131_O));
        Vector3 diffVec = attachPosVec2.copy().negate();
        double distanceBetweenTicks = diffVec.mag();
        double width = this.attachedEntity.field_70130_N;
        double height = this.attachedEntity.field_70131_O;
        for (double d = 0.0; d <= distanceBetweenTicks; d += 0.05) {
            Vector3 interpVec = diffVec.copy().normalize().multiply(d).add(attachPosVec2);
            double xDiff = Math.abs(interpVec.x);
            double yDiff = Math.abs(interpVec.y);
            double zDiff = Math.abs(interpVec.z);
            if (!(yDiff <= height / 2.0) || !(xDiff <= width / 2.0) || !(zDiff <= width / 2.0)) continue;
            this.attachedYaw = this.getEntityRotation();
            this.attachedX = (float)interpVec.x;
            this.attachedY = (float)interpVec.y;
            this.attachedZ = (float)interpVec.z;
            return;
        }
    }

    public boolean isAttachedToEntity() {
        return this.attachedEntity != null;
    }

    public void moveEntityWithBounce(double bounceFactor) {
        double dx = this.field_70159_w;
        double dz = this.field_70179_y;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        boolean isCollidedX = this.field_70159_w != dx;
        boolean isCollidedZ = this.field_70179_y != dz;
        this.field_70159_w = dx;
        this.field_70179_y = dz;
        if (isCollidedX) {
            this.field_70159_w *= -bounceFactor;
            this.field_70165_t += Math.signum(this.field_70159_w) * 0.1;
        }
        if (isCollidedZ) {
            this.field_70179_y *= -bounceFactor;
            this.field_70161_v += Math.signum(this.field_70179_y) * 0.1;
        }
        this.func_145771_j(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
    }

    private void findAttachedEntity() {
        if (this.attachmentCounter == 0) {
            this.detachFromEntity();
            return;
        }
        if (this.attachedPlayerName != null) {
            EntityPlayerMP player = ServerUtils.getPlayer((String)this.attachedPlayerName);
            if (player != null) {
                this.attachedEntity = player;
                this.moveToEntityExterior();
                RedstoneEther.server().addTransmittingDevice(this);
                this.attachmentCounter = 0;
                return;
            }
        } else {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)-10.0, (double)-10.0, (double)-10.0, (double)10.0, (double)10.0, (double)10.0).func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                if (!this.tryAttach(entity, 0.4, 0.2)) continue;
                this.attachmentCounter = 0;
                return;
            }
            --this.attachmentCounter;
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("attached", this.attached);
        nbttagcompound.func_74777_a("attachCount", (short)this.attachmentCounter);
        nbttagcompound.func_74757_a("item", this.item);
        nbttagcompound.func_74777_a("freq", (short)this.freq);
        if (this.attachedPlayerName != null) {
            nbttagcompound.func_74778_a("player", this.attachedPlayerName);
            nbttagcompound.func_74776_a("attachedX", this.attachedX);
            nbttagcompound.func_74776_a("attachedY", this.attachedY);
            nbttagcompound.func_74776_a("attachedZ", this.attachedZ);
            nbttagcompound.func_74776_a("attachedYaw", this.attachedYaw);
        }
    }

    public void onChunkUnload() {
        if (!this.field_70170_p.field_72995_K) {
            RedstoneEther.server().removeTransmittingDevice(this);
            RedstoneEtherAddons.server().removeTracker(this);
        }
    }

    public boolean attachedInOtherDimension() {
        return this.attachedEntity instanceof EntityPlayer && ((EntityPlayer)this.attachedEntity).field_71093_bK != this.getDimension();
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.attached = nbttagcompound.func_74767_n("attached");
        this.attachmentCounter = nbttagcompound.func_74765_d("attachCount");
        this.freq = nbttagcompound.func_74765_d("freq");
        this.item = nbttagcompound.func_74767_n("item");
        if (nbttagcompound.func_74764_b("player")) {
            this.attachedPlayerName = nbttagcompound.func_74779_i("player");
            this.attachedX = nbttagcompound.func_74760_g("attachedX");
            this.attachedY = nbttagcompound.func_74760_g("attachedY");
            this.attachedZ = nbttagcompound.func_74760_g("attachedZ");
            this.attachedYaw = nbttagcompound.func_74760_g("attachedYaw");
        }
        if (this.attached) {
            this.attachmentCounter = 5;
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public Vector3 getRotatedAttachment() {
        Vector3 relPos = new Vector3((double)this.attachedX, (double)this.attachedY, (double)this.attachedZ);
        Quat rot = Quat.aroundAxis((double)0.0, (double)1.0, (double)0.0, (double)((double)(this.getEntityRotation() - this.attachedYaw) * 0.017453));
        rot.rotate(relPos);
        return relPos;
    }

    public float getEntityRotation() {
        if (this.attachedEntity instanceof EntityLivingBase) {
            return -((EntityLivingBase)this.attachedEntity).field_70761_aq;
        }
        return this.attachedEntity.field_70177_z;
    }

    public boolean attachedToLogout() {
        return this.attached && this.attachedEntity == null && this.attachedPlayerName != null;
    }

    public void copyToDimension(int dimension) {
        WorldServer otherWorld = DimensionManager.getWorld((int)dimension);
        EntityWirelessTracker copy = new EntityWirelessTracker((World)otherWorld, this.freq);
        copy.attached = true;
        copy.attachedPlayerName = this.attachedPlayerName;
        copy.attachedX = this.attachedX;
        copy.attachedY = this.attachedY;
        copy.attachedZ = this.attachedZ;
        copy.attachedYaw = this.attachedYaw;
        copy.func_70107_b(this.attachedEntity.field_70165_t, this.attachedEntity.field_70163_u, this.attachedEntity.field_70161_v);
        otherWorld.func_72838_d((Entity)copy);
    }

    @Override
    public EntityLivingBase getAttachedEntity() {
        if (this.attachedEntity instanceof EntityLivingBase) {
            return (EntityLivingBase)this.attachedEntity;
        }
        return null;
    }

    @Override
    public Vector3 getPosition() {
        return Vector3.fromEntityCenter((Entity)this);
    }

    @Override
    public int getDimension() {
        return CommonUtils.getDimension((World)this.field_70170_p);
    }

    @Override
    public int getFreq() {
        return this.freq;
    }
}

