/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CraftingCPUStatus
implements Comparable<CraftingCPUStatus> {
    @Nullable
    private final ICraftingCPU serverCluster;
    private final String name;
    private final int serial;
    private final long storage;
    private final long coprocessors;
    private final boolean isBusy;
    private final long totalItems;
    private final long remainingItems;
    private final IAEItemStack crafting;

    public CraftingCPUStatus() {
        this.serverCluster = null;
        this.name = "ERROR";
        this.serial = 0;
        this.storage = 0L;
        this.coprocessors = 0L;
        this.isBusy = false;
        this.totalItems = 0L;
        this.remainingItems = 0L;
        this.crafting = null;
    }

    public CraftingCPUStatus(ICraftingCPU cluster, int serial) {
        this.serverCluster = cluster;
        this.name = cluster.getName();
        this.serial = serial;
        this.isBusy = cluster.isBusy();
        if (this.isBusy) {
            this.crafting = cluster.getFinalOutput();
            this.totalItems = cluster.getStartItemCount();
            this.remainingItems = cluster.getRemainingItemCount();
        } else {
            this.crafting = null;
            this.totalItems = 0L;
            this.remainingItems = 0L;
        }
        this.storage = cluster.getAvailableStorage();
        this.coprocessors = cluster.getCoProcessors();
    }

    public CraftingCPUStatus(NBTTagCompound i) {
        this.serverCluster = null;
        this.name = i.func_74779_i("name");
        this.serial = i.func_74762_e("serial");
        this.storage = i.func_74763_f("storage");
        this.coprocessors = i.func_74763_f("coprocessors");
        this.isBusy = i.func_74767_n("isBusy");
        this.totalItems = i.func_74763_f("totalItems");
        this.remainingItems = i.func_74763_f("remainingItems");
        this.crafting = i.func_74764_b("crafting") ? AEItemStack.loadItemStackFromNBT(i.func_74775_l("crafting")) : null;
    }

    public CraftingCPUStatus(ByteBuf packet) throws IOException {
        this(CraftingCPUStatus.readNBTFromPacket(packet));
    }

    private static NBTTagCompound readNBTFromPacket(ByteBuf packet) throws IOException {
        int size = packet.readInt();
        byte[] tagBytes = new byte[size];
        packet.readBytes(tagBytes);
        ByteArrayInputStream di = new ByteArrayInputStream(tagBytes);
        return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(di));
    }

    public void writeToNBT(NBTTagCompound i) {
        if (this.name != null && !this.name.isEmpty()) {
            i.func_74778_a("name", this.name);
        }
        i.func_74768_a("serial", this.serial);
        i.func_74772_a("storage", this.storage);
        i.func_74772_a("coprocessors", this.coprocessors);
        i.func_74757_a("isBusy", this.isBusy);
        i.func_74772_a("totalItems", this.totalItems);
        i.func_74772_a("remainingItems", this.remainingItems);
        if (this.crafting != null) {
            NBTTagCompound stack = new NBTTagCompound();
            this.crafting.writeToNBT(stack);
            i.func_74782_a("crafting", (NBTBase)stack);
        }
    }

    public void writeToPacket(ByteBuf i) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)data);
        byte[] tagBytes = bytes.toByteArray();
        int size = tagBytes.length;
        i.writeInt(size);
        i.writeBytes(tagBytes);
    }

    @Nullable
    public ICraftingCPU getServerCluster() {
        return this.serverCluster;
    }

    public String getName() {
        return this.name;
    }

    public int getSerial() {
        return this.serial;
    }

    public long getStorage() {
        return this.storage;
    }

    public long getCoprocessors() {
        return this.coprocessors;
    }

    public long getTotalItems() {
        return this.totalItems;
    }

    public long getRemainingItems() {
        return this.remainingItems;
    }

    public IAEItemStack getCrafting() {
        return this.crafting;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    @Override
    public int compareTo(CraftingCPUStatus o) {
        int a = ItemSorters.compareLong(o.getCoprocessors(), this.getCoprocessors());
        if (a != 0) {
            return a;
        }
        return ItemSorters.compareLong(o.getStorage(), this.getStorage());
    }

    public String formatStorage() {
        return Platform.formatByteDouble(this.getStorage());
    }
}

