/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Map;
import openmods.calc.Frame;
import openmods.calc.types.multi.MetaObject;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class IntegerAttrs {
    private final Map<String, IntAttr> attrs = Maps.newHashMap();

    public IntegerAttrs() {
        this.attrs.put("bitLength", new IntAttr(){

            @Override
            public TypedValue get(TypeDomain domain, BigInteger value) {
                return domain.create(BigInteger.class, BigInteger.valueOf(value.bitLength()));
            }
        });
        this.attrs.put("chr", new IntAttr(){

            @Override
            public TypedValue get(TypeDomain domain, BigInteger value) {
                char[] chars = Character.toChars(value.intValue());
                return domain.create(String.class, new String(chars));
            }
        });
    }

    public MetaObject.SlotAttr createAttrSlot() {
        return new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                IntAttr attr = (IntAttr)IntegerAttrs.this.attrs.get(key);
                if (attr == null) {
                    return Optional.absent();
                }
                BigInteger value = self.as(BigInteger.class);
                return Optional.of((Object)attr.get(self.domain, value));
            }
        };
    }

    public MetaObject.SlotDir createDirSlot() {
        return MetaObjectUtils.dirFromIterable(this.attrs.keySet());
    }

    private static interface IntAttr {
        public TypedValue get(TypeDomain var1, BigInteger var2);
    }
}

