/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.models.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gtnewhorizons.angelica.api.BlockPos;
import com.gtnewhorizons.angelica.api.QuadProvider;
import com.gtnewhorizons.angelica.api.QuadView;
import com.gtnewhorizons.angelica.compat.mojang.Axis;
import com.gtnewhorizons.angelica.models.NdQuadBuilder;
import com.gtnewhorizons.angelica.models.json.ModelDisplay;
import com.gtnewhorizons.angelica.models.json.ModelElement;
import com.gtnewhorizons.angelica.models.json.Variant;
import com.gtnewhorizons.angelica.utils.DirUtil;
import com.gtnewhorizons.angelica.utils.JsonUtil;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import me.jellysquid.mods.sodium.client.model.quad.Quad;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class JsonModel
implements QuadProvider {
    @Nullable
    private final ResourceLocation parentId;
    @Nullable
    private JsonModel parent;
    private final boolean useAO;
    private final Map<ModelDisplay.Position, ModelDisplay> display;
    private final Map<String, String> textures;
    private List<ModelElement> elements;
    private List<QuadView> allQuadStore = new ObjectArrayList();
    private final Map<ForgeDirection, List<QuadView>> sidedQuadStore = new Object2ObjectOpenHashMap();
    private static final List<QuadView> EMPTY = ObjectImmutableList.of();

    JsonModel(@Nullable ResourceLocation parentId, boolean useAO, Map<ModelDisplay.Position, ModelDisplay> display, Map<String, String> textures, List<ModelElement> elements) {
        this.parentId = parentId;
        this.useAO = useAO;
        this.display = display;
        this.textures = textures;
        this.elements = elements;
    }

    JsonModel(JsonModel og) {
        this.parentId = og.parentId;
        this.parent = og.parent;
        this.useAO = og.useAO;
        this.display = og.display;
        this.textures = og.textures;
        this.elements = og.elements;
    }

    public void bake(Variant v) {
        Matrix4f vRot = v.getAffineMatrix();
        NdQuadBuilder builder = new NdQuadBuilder();
        for (ModelElement e : this.elements) {
            Matrix4f rot = e.getRotation() == null ? ModelElement.Rotation.NOOP.getAffineMatrix() : e.getRotation().getAffineMatrix();
            Vector3f from = e.getFrom();
            Vector3f to = e.getTo();
            for (ModelElement.Face f : e.getFaces()) {
                int n;
                for (int i = 0; i < 4; ++i) {
                    Vector3f vert = rot.transformPosition(NdQuadBuilder.mapSideToVertex(from, to, i, f.getName()));
                    vRot.transformPosition(vert);
                    builder.pos(i, vert.x, vert.y, vert.z);
                }
                builder.cullFace(f.getCullFace());
                builder.nominalFace(f.getName());
                switch (f.getRotation()) {
                    case 90: {
                        n = 1;
                        break;
                    }
                    case 180: {
                        n = 2;
                        break;
                    }
                    case 270: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int flags = n;
                Vector4f uv = f.getUv();
                if (uv != null) {
                    builder.uv(0, uv.x, uv.y);
                    builder.uv(1, uv.x, uv.w);
                    builder.uv(2, uv.z, uv.w);
                    builder.uv(3, uv.z, uv.y);
                } else {
                    flags |= 4;
                }
                builder.spriteBake(this.textures.get(f.getTexture()), flags);
                int tint = f.getTintIndex();
                builder.color(tint, tint, tint, tint);
                builder.mat.setAO(this.useAO);
                QuadView q = builder.build(new Quad());
                this.allQuadStore.add(q);
                this.sidedQuadStore.computeIfAbsent(f.getCullFace(), o -> new ObjectArrayList()).add(q);
            }
        }
        this.allQuadStore = new ObjectImmutableList(this.allQuadStore);
        for (ForgeDirection f : DirectionUtil.ALL_DIRECTIONS) {
            List l = this.sidedQuadStore.computeIfAbsent(f, o -> EMPTY);
            if (l.isEmpty()) continue;
            this.sidedQuadStore.put(f, (List<QuadView>)new ObjectImmutableList((Collection)l));
        }
    }

    public List<ResourceLocation> getParents() {
        return Arrays.asList(this.parentId);
    }

    @Override
    public List<QuadView> getQuads(IBlockAccess world, BlockPos pos, Block block, int meta, ForgeDirection dir, Random random, int color, Supplier<QuadView> quadPool) {
        return this.sidedQuadStore.getOrDefault(dir, EMPTY);
    }

    public void resolveParents(Function<ResourceLocation, JsonModel> modelLoader) {
        if (this.parentId != null && this.parent == null) {
            JsonModel p = (JsonModel)modelLoader.apply((Object)this.parentId);
            p.resolveParents(modelLoader);
            this.parent = p;
            if (this.elements.isEmpty()) {
                this.elements = this.parent.elements;
            }
            for (Map.Entry<String, String> e : this.parent.textures.entrySet()) {
                this.textures.putIfAbsent(e.getKey(), e.getValue());
            }
            boolean flat = false;
            Object2ObjectOpenHashMap tmp = new Object2ObjectOpenHashMap();
            while (!flat) {
                flat = true;
                for (Map.Entry<String, String> e : this.textures.entrySet()) {
                    if (this.textures.containsKey(e.getValue())) {
                        if (!e.getKey().equals(e.getValue())) {
                            tmp.put(e.getKey(), this.textures.get(e.getValue()));
                        } else {
                            tmp.put(e.getKey(), "");
                        }
                        flat = false;
                        continue;
                    }
                    tmp.put(e.getKey(), e.getValue());
                }
                this.textures.putAll((Map<String, String>)tmp);
            }
        }
    }

    public boolean isUseAO() {
        return this.useAO;
    }

    static class Deserializer
    implements JsonDeserializer<JsonModel> {
        Deserializer() {
        }

        private Vector3f loadVec3(JsonObject in, String name) {
            JsonArray arr = in.getAsJsonArray(name);
            Vector3f ret = new Vector3f();
            for (int i = 0; i < 3; ++i) {
                ret.setComponent(i, arr.get(i).getAsFloat());
            }
            return ret;
        }

        private Vector4f loadVec4(JsonObject in, String name) {
            JsonArray arr = in.getAsJsonArray(name);
            Vector4f ret = new Vector4f();
            for (int i = 0; i < 4; ++i) {
                ret.setComponent(i, arr.get(i).getAsFloat());
            }
            return ret;
        }

        private ModelDisplay loadADisplay(JsonObject in) {
            Vector3f rotation = this.loadVec3(in, "rotation");
            Vector3f translation = this.loadVec3(in, "translation");
            Vector3f scale = this.loadVec3(in, "scale");
            return new ModelDisplay(rotation, translation, scale);
        }

        private Map<ModelDisplay.Position, ModelDisplay> loadDisplay(JsonObject in) {
            Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(ModelDisplay.Position.values().length);
            if (in.has("display")) {
                JsonObject display = in.getAsJsonObject("display");
                for (Map.Entry j : display.entrySet()) {
                    String name = (String)j.getKey();
                    ModelDisplay.Position pos = ModelDisplay.Position.getByName(name);
                    ret.put(pos, this.loadADisplay(((JsonElement)j.getValue()).getAsJsonObject()));
                }
            }
            for (ModelDisplay.Position p : ModelDisplay.Position.values()) {
                ret.putIfAbsent(p, ModelDisplay.DEFAULT);
            }
            return ret;
        }

        private Map<String, String> loadTextures(JsonObject in) {
            Object2ObjectOpenHashMap textures = new Object2ObjectOpenHashMap();
            if (in.has("textures")) {
                for (Map.Entry e : in.getAsJsonObject("textures").entrySet()) {
                    String s = ((JsonElement)e.getValue()).getAsString();
                    if (s.startsWith("#")) {
                        s = s.substring(1);
                    }
                    textures.put((String)e.getKey(), s);
                }
            }
            return textures;
        }

        private ModelElement.Rotation loadRotation(JsonObject in) {
            if (in.has("rotation")) {
                JsonObject json = in.getAsJsonObject("rotation");
                Vector3f origin = this.loadVec3(json, "origin").div(16.0f);
                Axis axis = Axis.fromName(JsonUtil.loadStr(json, "axis"));
                float angle = JsonUtil.loadFloat(json, "angle");
                boolean rescale = JsonUtil.loadBool(json, "rescale", false);
                return new ModelElement.Rotation(origin, axis, angle, rescale);
            }
            return null;
        }

        private List<ModelElement.Face> loadFaces(JsonObject in) {
            ObjectArrayList ret = new ObjectArrayList();
            JsonObject json = in.getAsJsonObject("faces");
            for (Map.Entry e : json.entrySet()) {
                ForgeDirection side = DirUtil.fromName((String)e.getKey());
                JsonObject face = ((JsonElement)e.getValue()).getAsJsonObject();
                Vector4f uv = face.has("uv") ? this.loadVec4(face, "uv") : null;
                String texture = JsonUtil.loadStr(face, "texture");
                if (texture.startsWith("#")) {
                    texture = texture.substring(1);
                }
                ForgeDirection cullFace = DirUtil.fromName(JsonUtil.loadStr(face, "cullface", "unknown"));
                int rotation = JsonUtil.loadInt(face, "rotation", 0);
                int tintIndex = JsonUtil.loadInt(face, "tintindex", -1);
                ret.add(new ModelElement.Face(side, uv, texture, cullFace, rotation, tintIndex));
            }
            return ret;
        }

        private List<ModelElement> loadElements(JsonObject in) {
            ObjectArrayList ret = new ObjectArrayList();
            if (in.has("elements")) {
                JsonArray arr = in.getAsJsonArray("elements");
                for (JsonElement e : arr) {
                    JsonObject json = e.getAsJsonObject();
                    Vector3f from = this.loadVec3(json, "from").div(16.0f);
                    Vector3f to = this.loadVec3(json, "to").div(16.0f);
                    ModelElement.Rotation rotation = this.loadRotation(json);
                    boolean shade = JsonUtil.loadBool(json, "shade", true);
                    List<ModelElement.Face> faces = this.loadFaces(json);
                    ret.add(new ModelElement(from, to, rotation, shade, faces));
                }
            }
            return ret;
        }

        public JsonModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject in = json.getAsJsonObject();
            String parent = JsonUtil.loadStr(in, "parent", "");
            ResourceLocation parentId = parent.isEmpty() ? null : new ResourceLocation(parent);
            boolean useAO = JsonUtil.loadBool(in, "ambientocclusion", true);
            Map<ModelDisplay.Position, ModelDisplay> display = this.loadDisplay(in);
            Map<String, String> textures = this.loadTextures(in);
            List<ModelElement> elements = this.loadElements(in);
            return new JsonModel(parentId, useAO, display, textures, elements);
        }
    }
}

