/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.ChangeableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.kuba6000.mobsinfo.api.utils.ItemID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kubatech.api.helpers.GTHelper;
import kubatech.api.utils.ModUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class DynamicInventory<T> {
    int width;
    int height;
    Supplier<Integer> slotsGetter;
    private int slots = 0;
    private int usedSlots = 0;
    List<T> inventory;
    TInventoryGetter<T> inventoryGetter;
    TInventoryInjector inventoryInjector = null;
    TInventoryExtractor<T> inventoryExtractor = null;
    TInventoryReplacerOrMerger inventoryReplacer = null;
    Supplier<Boolean> isEnabledGetter = null;
    boolean isEnabled = true;
    List<GTHelper.StackableItemSlot> drawables = new ArrayList<GTHelper.StackableItemSlot>();

    public DynamicInventory(int width, int height, Supplier<Integer> slotsGetter, List<T> inventory, TInventoryGetter<T> inventoryGetter) {
        this.width = width;
        this.height = height;
        this.slotsGetter = slotsGetter;
        this.inventory = inventory;
        this.inventoryGetter = inventoryGetter;
    }

    public DynamicInventory<T> allowInventoryInjection(TInventoryInjector inventoryInjector) {
        this.inventoryInjector = inventoryInjector;
        return this;
    }

    public DynamicInventory<T> allowInventoryExtraction(TInventoryExtractor<T> inventoryExtractor) {
        this.inventoryExtractor = inventoryExtractor;
        return this;
    }

    public DynamicInventory<T> allowInventoryReplace(TInventoryReplacerOrMerger inventoryReplacer) {
        this.inventoryReplacer = inventoryReplacer;
        return this;
    }

    public DynamicInventory<T> setEnabled(Supplier<Boolean> isEnabled) {
        this.isEnabledGetter = isEnabled;
        return this;
    }

    public UITexture getItemSlot() {
        return ModularUITextures.ITEM_SLOT;
    }

    public Widget asWidget(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ChangeableWidget container = new ChangeableWidget(() -> this.createWidget(buildContext.getPlayer()));
        container.attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> {
            if (this.slots != this.slotsGetter.get()) {
                this.slots = this.slotsGetter.get();
                container.notifyChangeNoSync();
            }
            return this.slots;
        }, i -> {
            if (this.slots != i) {
                this.slots = i;
                container.notifyChangeNoSync();
            }
        }), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> {
            if (this.usedSlots != this.inventory.size()) {
                this.usedSlots = this.inventory.size();
                container.notifyChangeNoSync();
            }
            return this.usedSlots;
        }, i -> {
            if (this.usedSlots != i) {
                this.usedSlots = i;
                container.notifyChangeNoSync();
            }
        }), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.ListSyncer(() -> {
            HashMap<ItemID, Integer> itemMap = new HashMap<ItemID, Integer>();
            HashMap<ItemID, ItemStack> stackMap = new HashMap<ItemID, ItemStack>();
            HashMap<ItemID, ArrayList> realSlotMap = new HashMap<ItemID, ArrayList>();
            int mStorageSize = this.inventory.size();
            for (int i = 0; i < mStorageSize; ++i) {
                ItemStack stack = this.inventoryGetter.get(this.inventory.get(i));
                ItemID id = ItemID.createNoCopy((ItemStack)stack, (boolean)false);
                itemMap.merge(id, 1, Integer::sum);
                stackMap.putIfAbsent(id, stack);
                realSlotMap.computeIfAbsent(id, unused -> new ArrayList()).add(i);
            }
            ArrayList<GTHelper.StackableItemSlot> newDrawables = new ArrayList<GTHelper.StackableItemSlot>();
            for (Map.Entry entry : itemMap.entrySet()) {
                newDrawables.add(new GTHelper.StackableItemSlot((Integer)entry.getValue(), (ItemStack)stackMap.get(entry.getKey()), (ArrayList)realSlotMap.get(entry.getKey())));
            }
            if (!Objects.equals(newDrawables, this.drawables)) {
                this.drawables = newDrawables;
                container.notifyChangeNoSync();
            }
            return this.drawables;
        }, l -> {
            this.drawables.clear();
            this.drawables.addAll((Collection<GTHelper.StackableItemSlot>)l);
            container.notifyChangeNoSync();
        }, (buffer, i) -> {
            try {
                i.write((PacketBuffer)buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, buffer -> {
            try {
                return GTHelper.StackableItemSlot.read(buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }), (IWidgetBuilder)builder);
        if (this.isEnabledGetter != null) {
            container.attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this.isEnabledGetter, i -> {
                this.isEnabled = i;
            }), (IWidgetBuilder)builder);
        }
        return container;
    }

    private Widget createWidget(EntityPlayer player) {
        Scrollable dynamicInventoryWidget = new Scrollable().setVerticalScroll();
        ArrayList<Widget> buttons = new ArrayList<Widget>();
        if (!ModUtils.isClientThreaded()) {
            HashMap<ItemID, Integer> itemMap = new HashMap<ItemID, Integer>();
            HashMap<ItemID, ItemStack> stackMap = new HashMap<ItemID, ItemStack>();
            HashMap<ItemID, ArrayList> realSlotMap = new HashMap<ItemID, ArrayList>();
            int inventorySize = this.inventory.size();
            for (int i = 0; i < inventorySize; ++i) {
                ItemStack stack = this.inventoryGetter.get(this.inventory.get(i));
                ItemID id = ItemID.createNoCopy((ItemStack)stack, (boolean)false);
                itemMap.merge(id, 1, Integer::sum);
                stackMap.putIfAbsent(id, stack);
                realSlotMap.computeIfAbsent(id, unused -> new ArrayList()).add(i);
            }
            this.drawables = new ArrayList<GTHelper.StackableItemSlot>();
            for (Map.Entry entry : itemMap.entrySet()) {
                this.drawables.add(new GTHelper.StackableItemSlot((Integer)entry.getValue(), (ItemStack)stackMap.get(entry.getKey()), (ArrayList)realSlotMap.get(entry.getKey())));
            }
        }
        int ID = 0;
        while (ID < this.drawables.size()) {
            int finalID = ID++;
            buttons.add(new ButtonWidget(){

                public void drawBackground(float partialTicks) {
                    super.drawBackground(partialTicks);
                    if (!DynamicInventory.this.isEnabled) {
                        GL11.glDisable((int)2896);
                        GL11.glEnable((int)3042);
                        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                        ModularGui.drawSolidRect((float)1.0f, (float)1.0f, (float)16.0f, (float)16.0f, (int)Color.withAlpha((int)Color.BLACK.normal, (int)128));
                        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        GL11.glDisable((int)3042);
                    } else if (this.isHovering() && !this.getContext().getCursor().hasDraggable()) {
                        GL11.glDisable((int)2896);
                        GL11.glEnable((int)3042);
                        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                        ModularGui.drawSolidRect((float)1.0f, (float)1.0f, (float)16.0f, (float)16.0f, (int)Theme.INSTANCE.getSlotHighlight());
                        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        GL11.glDisable((int)3042);
                    }
                }
            }.setPlayClickSound(false).setOnClick((clickData, widget) -> {
                if (!(player instanceof EntityPlayerMP)) {
                    return;
                }
                if (!this.isEnabledGetter.get().booleanValue()) {
                    return;
                }
                if (clickData.mouseButton == 2) {
                    if (this.drawables.size() <= finalID) {
                        return;
                    }
                    if (player.field_71075_bZ.field_75098_d && player.field_71071_by.func_70445_o() == null) {
                        int realID = this.drawables.get((int)finalID).realSlots.get(0);
                        ItemStack stack = this.inventoryGetter.get(this.inventory.get(realID)).func_77946_l();
                        stack.field_77994_a = stack.func_77976_d();
                        player.field_71071_by.func_70437_b(stack);
                        ((EntityPlayerMP)player).field_71137_h = false;
                        ((EntityPlayerMP)player).func_71113_k();
                        return;
                    }
                } else if (clickData.shift) {
                    if (this.inventoryExtractor == null) {
                        return;
                    }
                    if (this.drawables.size() <= finalID) {
                        return;
                    }
                    int realID = this.drawables.get((int)finalID).realSlots.get(0);
                    T removed = this.inventoryExtractor.extract(realID);
                    if (removed != null) {
                        ItemStack stack = this.inventoryGetter.get(removed);
                        if (player.field_71071_by.func_70441_a(stack)) {
                            player.field_71069_bz.func_75142_b();
                        } else {
                            player.func_70099_a(stack, 0.0f);
                        }
                        return;
                    }
                } else {
                    ItemStack input = player.field_71071_by.func_70445_o();
                    if (input != null) {
                        if (this.drawables.size() > finalID) {
                            if (this.inventoryReplacer == null) {
                                return;
                            }
                            int realID = this.drawables.get((int)finalID).realSlots.get(0);
                            ItemStack removed = this.inventoryReplacer.replaceOrMerge(realID, input);
                            if (removed == null) {
                                return;
                            }
                            player.field_71071_by.func_70437_b(removed.field_77994_a == 0 ? null : removed);
                        } else {
                            if (this.inventoryInjector == null) {
                                return;
                            }
                            if (clickData.mouseButton == 1) {
                                ItemStack copy = input.func_77946_l();
                                copy.field_77994_a = 1;
                                ItemStack leftover = this.inventoryInjector.inject(copy);
                                if (leftover == null) {
                                    return;
                                }
                                --input.field_77994_a;
                                if (input.field_77994_a > 0) {
                                    ((EntityPlayerMP)player).field_71137_h = true;
                                    ((EntityPlayerMP)player).func_71113_k();
                                    return;
                                }
                                player.field_71071_by.func_70437_b(null);
                            } else {
                                ItemStack leftover = this.inventoryInjector.inject(input);
                                if (leftover == null) {
                                    return;
                                }
                                if (input.field_77994_a > 0) {
                                    ((EntityPlayerMP)player).field_71137_h = true;
                                    ((EntityPlayerMP)player).func_71113_k();
                                    return;
                                }
                                player.field_71071_by.func_70437_b(null);
                            }
                        }
                        ((EntityPlayerMP)player).field_71137_h = false;
                        ((EntityPlayerMP)player).func_71113_k();
                        return;
                    }
                    if (this.drawables.size() > finalID) {
                        if (this.inventoryExtractor == null) {
                            return;
                        }
                        int realID = this.drawables.get((int)finalID).realSlots.get(0);
                        T removed = this.inventoryExtractor.extract(realID);
                        if (removed != null) {
                            ItemStack stack = this.inventoryGetter.get(removed);
                            player.field_71071_by.func_70437_b(stack);
                            ((EntityPlayerMP)player).field_71137_h = false;
                            ((EntityPlayerMP)player).func_71113_k();
                            return;
                        }
                    }
                }
            }).setBackground(() -> {
                IDrawable[] iDrawableArray = new IDrawable[4];
                iDrawableArray[0] = this.getItemSlot();
                iDrawableArray[1] = new ItemDrawable(this.drawables.size() > finalID ? this.drawables.get((int)finalID).stack : null).withFixedSize(16.0f, 16.0f, 1.0f, 1.0f);
                iDrawableArray[2] = new Text(this.drawables.size() > finalID && this.drawables.get((int)finalID).count > 1 ? (this.drawables.get((int)finalID).count > 99 ? "+99" : String.valueOf(this.drawables.get((int)finalID).count)) : "").color(Color.WHITE.normal).alignment(Alignment.TopLeft).withOffset(1.0f, 1.0f);
                iDrawableArray[3] = new Text(this.drawables.size() > finalID && this.drawables.get((int)finalID).stack.field_77994_a > 1 ? String.valueOf(this.drawables.get((int)finalID).stack.field_77994_a) : "").color(Color.WHITE.normal).shadow().alignment(Alignment.BottomRight);
                return iDrawableArray;
            }).dynamicTooltip(() -> {
                if (this.drawables.size() > finalID) {
                    ArrayList<String> tip = new ArrayList<String>(Collections.singletonList(this.drawables.get((int)finalID).stack.func_82833_r()));
                    if (this.drawables.get((int)finalID).count > 1) {
                        tip.add(EnumChatFormatting.DARK_PURPLE + "There are " + this.drawables.get((int)finalID).count + " identical slots");
                    }
                    return tip;
                }
                return Collections.emptyList();
            }).setSize(18, 18));
        }
        buttons.add(new ButtonWidget(){

            public void drawBackground(float partialTicks) {
                super.drawBackground(partialTicks);
                if (!DynamicInventory.this.isEnabled) {
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    ModularGui.drawSolidRect((float)1.0f, (float)1.0f, (float)16.0f, (float)16.0f, (int)Color.withAlpha((int)Color.BLACK.normal, (int)128));
                    GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GL11.glDisable((int)3042);
                } else if (this.isHovering() && !this.getContext().getCursor().hasDraggable()) {
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    ModularGui.drawSolidRect((float)1.0f, (float)1.0f, (float)16.0f, (float)16.0f, (int)Theme.INSTANCE.getSlotHighlight());
                    GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    GL11.glDisable((int)3042);
                }
            }
        }.setPlayClickSound(false).setOnClick((clickData, widget) -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (!this.isEnabledGetter.get().booleanValue()) {
                return;
            }
            ItemStack input = player.field_71071_by.func_70445_o();
            if (input != null) {
                if (clickData.mouseButton == 1) {
                    ItemStack copy = input.func_77946_l();
                    copy.field_77994_a = 1;
                    ItemStack leftover = this.inventoryInjector.inject(copy);
                    if (leftover == null) {
                        return;
                    }
                    --input.field_77994_a;
                    if (input.field_77994_a > 0) {
                        ((EntityPlayerMP)player).field_71137_h = true;
                        ((EntityPlayerMP)player).func_71113_k();
                        return;
                    }
                    player.field_71071_by.func_70437_b(null);
                } else {
                    ItemStack leftover = this.inventoryInjector.inject(input);
                    if (leftover == null) {
                        return;
                    }
                    if (input.field_77994_a > 0) {
                        ((EntityPlayerMP)player).field_71137_h = true;
                        ((EntityPlayerMP)player).func_71113_k();
                        return;
                    }
                    player.field_71071_by.func_70437_b(null);
                }
                ((EntityPlayerMP)player).field_71137_h = false;
                ((EntityPlayerMP)player).func_71113_k();
                return;
            }
        }).setBackground(() -> new IDrawable[]{this.getItemSlot(), new Text(this.slots - this.usedSlots <= 1 ? "" : (this.slots - this.usedSlots > 99 ? "+99" : String.valueOf(this.slots - this.usedSlots))).color(Color.WHITE.normal).alignment(Alignment.TopLeft).withOffset(1.0f, 1.0f)}).dynamicTooltip(() -> {
            ArrayList<String> tip = new ArrayList<String>(Collections.singleton(EnumChatFormatting.GRAY + "Empty slot"));
            if (this.slots - this.usedSlots > 1) {
                tip.add(EnumChatFormatting.DARK_PURPLE + "There are " + (this.slots - this.usedSlots) + " identical slots");
            }
            return tip;
        }).setSize(18, 18));
        int perRow = this.width / 18;
        int imax = (buttons.size() - 1) / perRow;
        for (int i = 0; i <= imax; ++i) {
            int jmax;
            DynamicPositionedRow row = new DynamicPositionedRow().setSynced(false);
            int j = 0;
            int n = jmax = i == imax ? (buttons.size() - 1) % perRow : perRow - 1;
            while (j <= jmax) {
                int finalI = i * perRow;
                int finalJ = j++;
                int ID2 = finalI + finalJ;
                row.widget((Widget)buttons.get(ID2));
            }
            dynamicInventoryWidget.widget(row.setPos(0, i * 18));
        }
        return dynamicInventoryWidget.setSize(this.width, this.height);
    }

    @FunctionalInterface
    public static interface TInventoryReplacerOrMerger {
        public ItemStack replaceOrMerge(int var1, ItemStack var2);
    }

    @FunctionalInterface
    public static interface TInventoryExtractor<T> {
        public T extract(int var1);
    }

    @FunctionalInterface
    public static interface TInventoryInjector {
        public ItemStack inject(ItemStack var1);
    }

    @FunctionalInterface
    public static interface TInventoryGetter<T> {
        public ItemStack get(T var1);
    }
}

